/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.breakpoint.GdbBreakpointLocation;
import agent.gdb.manager.parsing.GdbCValueParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetBreakpointSpec;
import agent.gdb.model.impl.GdbModelTargetInferior;
import generic.Unique;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="BreakpointLocation", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetBreakpointLocation
extends DefaultTargetObject<TargetObject, GdbModelTargetBreakpointSpec>
implements TargetBreakpointLocation {
    protected static final String LOC_PREFIX = "-location";
    protected final GdbModelImpl impl;
    protected final GdbBreakpointLocation loc;
    protected Address address;
    protected Integer length;
    protected String display;

    protected static String indexLocation(GdbBreakpointLocation loc) {
        return PathUtils.makeIndex((long)loc.getSub());
    }

    protected static String keyLocation(GdbBreakpointLocation loc) {
        return PathUtils.makeKey((String)GdbModelTargetBreakpointLocation.indexLocation(loc));
    }

    public GdbModelTargetBreakpointLocation(GdbModelTargetBreakpointSpec spec, GdbBreakpointLocation loc) {
        super((AbstractDebuggerObjectModel)spec.impl, (TargetObject)spec, GdbModelTargetBreakpointLocation.keyLocation(loc), "BreakpointLocation");
        this.impl = spec.impl;
        this.loc = loc;
        this.impl.addModelObject(loc, (TargetObject)this);
        if (!spec.info.getType().isWatchpoint()) {
            this.address = this.doGetAddress();
            this.length = 1;
            this.doChangeAttributes("Initialized");
        }
    }

    protected void doChangeAttributes(String reason) {
        this.display = this.computeDisplay();
        this.changeAttributes(List.of(), Map.of("_spec", this.parent, "_address", this.address, "_length", this.length, "_display", this.display), reason);
        this.placeLocations();
    }

    protected CompletableFuture<Void> initWpt() {
        assert (this.loc.getAddr() == null);
        String what = ((GdbModelTargetBreakpointSpec)this.parent).info.getWhat();
        String exp = what.startsWith(LOC_PREFIX) ? what.substring(LOC_PREFIX.length()) : what;
        int iid = (Integer)Unique.assertOne(this.loc.getInferiorIds());
        GdbModelTargetInferior inf = this.impl.session.inferiors.getTargetInferior(iid);
        String addrSizeExp = String.format("{(long long)&(%s), (long long)sizeof(%s)}", exp, exp);
        return ((CompletableFuture)inf.inferior.evaluate(addrSizeExp).thenAccept(result -> {
            List<Long> vals;
            try {
                vals = GdbCValueParser.parseArray(result).expectLongs();
            }
            catch (GdbParsingUtils.GdbParseError e) {
                throw new AssertionError("Unexpected result type: " + result, e);
            }
            if (vals.size() != 2) {
                throw new AssertionError((Object)("Unexpected result count: " + result));
            }
            this.address = this.impl.space.getAddress(vals.get(0).longValue());
            this.length = vals.get(1).intValue();
            this.doChangeAttributes("Initialized");
        })).exceptionally(ex -> {
            Msg.warn((Object)((Object)this), (Object)("Could not evaluated breakpoint location and/or size: " + ex));
            this.address = this.impl.space.getAddress(0L);
            this.length = 1;
            this.doChangeAttributes("Defaulted for eval/parse error");
            return null;
        });
    }

    protected String computeDisplay() {
        return String.format("%d.%d %s", ((GdbModelTargetBreakpointSpec)this.parent).info.getNumber(), this.loc.getSub(), this.address);
    }

    protected Address doGetAddress() {
        return this.impl.space.getAddress(this.loc.addrAsLong());
    }

    public Integer getLength() {
        return this.length;
    }

    protected void placeLocations() {
        for (GdbModelTargetInferior inf : this.impl.session.inferiors.getCachedElements().values()) {
            if (this.loc.getInferiorIds().contains(inf.inferior.getId())) {
                inf.addBreakpointLocation(this);
                continue;
            }
            inf.removeBreakpointLocation(this);
        }
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        this.removeLocations();
        super.doInvalidate(branch, reason);
    }

    protected void removeLocations() {
        for (GdbModelTargetInferior inf : this.impl.session.inferiors.getCachedElements().values()) {
            inf.removeBreakpointLocation(this);
        }
    }

    public GdbModelTargetBreakpointSpec getSpecification() {
        return (GdbModelTargetBreakpointSpec)this.parent;
    }
}

