/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbProcessThreadGroup;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetAvailableContainer;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Attachable", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetAttachable
extends DefaultTargetObject<TargetObject, GdbModelTargetAvailableContainer>
implements TargetAttachable {
    public static final String PID_ATTRIBUTE_NAME = "_pid";
    private GdbProcessThreadGroup process;
    protected long pid;
    protected String display;

    protected static String indexAttachable(GdbProcessThreadGroup process) {
        return PathUtils.makeIndex((int)process.getPid());
    }

    protected static String keyAttachable(GdbProcessThreadGroup process) {
        return PathUtils.makeKey((String)GdbModelTargetAttachable.indexAttachable(process));
    }

    protected static String computeDisplay(GdbProcessThreadGroup process, Integer base) {
        if (base == 16) {
            return String.format("0x%x %s", process.getPid(), process.getDescription());
        }
        return String.format("%d %s", process.getPid(), process.getDescription());
    }

    public GdbModelTargetAttachable(GdbModelImpl impl, GdbModelTargetAvailableContainer parent, GdbProcessThreadGroup process) {
        super((AbstractDebuggerObjectModel)impl, (TargetObject)parent, GdbModelTargetAttachable.keyAttachable(process), "Attachable");
        this.process = process;
        this.pid = process.getPid();
        this.display = GdbModelTargetAttachable.computeDisplay(process, 10);
        this.changeAttributes(List.of(), List.of(), Map.of(PID_ATTRIBUTE_NAME, this.pid, "_display", this.display), "Initialized");
    }

    @TargetAttributeType(name="_pid", hidden=true)
    public long getPid() {
        return this.pid;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setBase(Object value) {
        this.display = GdbModelTargetAttachable.computeDisplay(this.process, (Integer)value);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.display), "Initialized");
    }
}

