/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadAndFrameId;
import org.apache.commons.text.StringEscapeUtils;

public class GdbEvaluateCommand
extends AbstractGdbCommandWithThreadAndFrameId<String> {
    private static final String MI2_CMD = "-data-evaluate-expression";
    public static final int MAX_EXPR_LEN = 4094 - "-data-evaluate-expression".length() - " --thread ".length() - " --frame ".length() - 6;
    private final String expression;

    public GdbEvaluateCommand(GdbManagerImpl manager, Integer threadId, Integer frameId, String expression) {
        super(manager, threadId, frameId);
        this.expression = expression;
    }

    @Override
    protected String encode(String threadPart, String framePart) {
        return MI2_CMD + threadPart + framePart + " \"" + StringEscapeUtils.escapeJava((String)this.expression) + "\"";
    }

    @Override
    public String complete(GdbPendingCommand<?> pending) {
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        return done.assumeValue();
    }
}

