/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangePluginEvent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;
import java.util.Iterator;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Byte Viewer", shortDescription="Displays bytes in memory", description="Provides a component for showing the bytes in memory.  Additional plugins provide capabilites for this plugin to show the bytes in various formats (e.g., hex, octal, decimal).  The hex format plugin is loaded by default when this plugin is loaded.", servicesRequired={ProgramManager.class, GoToService.class, NavigationHistoryService.class, ClipboardService.class}, eventsConsumed={ProgramLocationPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramSelectionPluginEvent.class, ProgramHighlightPluginEvent.class, ProgramClosedPluginEvent.class, ByteBlockChangePluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, ByteBlockChangePluginEvent.class})
public class ByteViewerPlugin
extends AbstractByteViewerPlugin<ProgramByteViewerComponentProvider> {
    public ByteViewerPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected ProgramByteViewerComponentProvider createProvider(boolean isConnected) {
        return new ProgramByteViewerComponentProvider(this.tool, this, isConnected);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            this.currentProgram = ((ProgramActivatedPluginEvent)event).getActiveProgram();
        } else if (event instanceof ProgramLocationPluginEvent) {
            this.currentLocation = ((ProgramLocationPluginEvent)event).getLocation();
        }
        this.connectedProvider.doHandleEvent(event);
    }

    void programClosed(Program closedProgram) {
        Iterator iterator = this.disconnectedProviders.iterator();
        while (iterator.hasNext()) {
            ProgramByteViewerComponentProvider provider = (ProgramByteViewerComponentProvider)((Object)iterator.next());
            if (provider.getProgram() != closedProgram) continue;
            iterator.remove();
            this.removeProvider(provider);
        }
    }

    @Override
    public void updateLocation(ProgramByteViewerComponentProvider provider, ProgramLocationPluginEvent event, boolean export) {
        if (this.eventsDisabled()) {
            return;
        }
        if (provider == this.connectedProvider) {
            this.fireProgramLocationPluginEvent(provider, event);
        } else if (export) {
            this.exportLocation(provider.getProgram(), event.getLocation());
        }
    }

    @Override
    public void fireProgramLocationPluginEvent(ProgramByteViewerComponentProvider provider, ProgramLocationPluginEvent event) {
        if (SystemUtilities.isEqual((Object)event.getLocation(), (Object)this.currentLocation)) {
            return;
        }
        this.currentLocation = event.getLocation();
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)event);
        }
    }

    @Override
    public void updateSelection(ByteViewerComponentProvider provider, ProgramSelectionPluginEvent event, Program program) {
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)event);
        }
    }

    @Override
    public void highlightChanged(ByteViewerComponentProvider provider, ProgramSelection highlight) {
        if (provider == this.connectedProvider) {
            this.tool.firePluginEvent((PluginEvent)new ProgramHighlightPluginEvent(this.getName(), highlight, this.connectedProvider.getProgram()));
        }
    }
}

