/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.tar;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.tar.TarFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

@FileSystemInfo(type="tar", description="TAR", priority=10, factory=TarFileSystemFactory.class)
public class TarFileSystem
implements GFileSystem {
    private FSRLRoot fsrl;
    private FileSystemService fsService;
    private ByteProvider provider;
    private FileSystemIndexHelper<TarMetadata> fsih;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private int fileCount;

    public TarFileSystem(FSRLRoot fsrl, ByteProvider provider, FileSystemService fsService) {
        this.fsrl = fsrl;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsrl);
        this.provider = provider;
        this.fsService = fsService;
    }

    ByteProvider getProvider() {
        return this.provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void mount(TaskMonitor monitor) throws IOException, CancelledException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(this.provider.getInputStream(0L));){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tarInput.getNextTarEntry()) != null) {
                int fileNum;
                monitor.setMessage(tarEntry.getName());
                monitor.checkCanceled();
                ++this.fileCount;
                GFile newFile = this.fsih.storeFile(tarEntry.getName(), (long)this.fileCount, tarEntry.isDirectory(), tarEntry.getSize(), (Object)new TarMetadata(tarEntry, fileNum));
                if (tarEntry.getSize() >= 0x200000L) continue;
                ByteProvider bp = this.fsService.getDerivedByteProvider(this.fsrl.getContainer(), newFile.getFSRL(), newFile.getPath(), tarEntry.getSize(), () -> tarInput, monitor);
                try {
                    this.fsih.updateFSRL(newFile, newFile.getFSRL().withMD5(bp.getFSRL().getMD5()));
                }
                finally {
                    if (bp == null) continue;
                    bp.close();
                }
            }
            return;
        }
    }

    public String getName() {
        return this.fsrl.getContainer().getName();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsih.clear();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public FSRLRoot getFSRL() {
        return this.fsrl;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        TarMetadata tmd = (TarMetadata)this.fsih.getMetadata(file);
        if (tmd == null) {
            return null;
        }
        TarArchiveEntry blob = tmd.tarArchiveEntry;
        return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.NAME_ATTR, (Object)blob.getName()), FileAttribute.create((FileAttributeType)FileAttributeType.SIZE_ATTR, (Object)blob.getSize()), FileAttribute.create((FileAttributeType)FileAttributeType.MODIFIED_DATE_ATTR, (Object)blob.getLastModifiedDate()), FileAttribute.create((FileAttributeType)FileAttributeType.FILE_TYPE_ATTR, (Object)this.tarToFileType(blob)), FileAttribute.create((FileAttributeType)FileAttributeType.USER_NAME_ATTR, (Object)blob.getUserName()), FileAttribute.create((FileAttributeType)FileAttributeType.GROUP_NAME_ATTR, (Object)blob.getGroupName()), FileAttribute.create((FileAttributeType)FileAttributeType.USER_ID_ATTR, (Object)blob.getLongUserId()), FileAttribute.create((FileAttributeType)FileAttributeType.GROUP_ID_ATTR, (Object)blob.getLongGroupId()), FileAttribute.create((FileAttributeType)FileAttributeType.UNIX_ACL_ATTR, (Object)blob.getMode())});
    }

    private FileType tarToFileType(TarArchiveEntry tae) {
        if (tae.isDirectory()) {
            return FileType.DIRECTORY;
        }
        if (tae.isSymbolicLink()) {
            return FileType.SYMBOLIC_LINK;
        }
        if (tae.isFile()) {
            return FileType.FILE;
        }
        return FileType.UNKNOWN;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        TarMetadata tmd = (TarMetadata)this.fsih.getMetadata(file);
        if (tmd == null) {
            throw new IOException("Unknown file " + file);
        }
        ByteProvider fileBP = this.fsService.getDerivedByteProvider(this.provider.getFSRL(), file.getFSRL(), file.getPath(), tmd.tarArchiveEntry.getSize(), () -> {
            TarArchiveEntry tarEntry;
            TarArchiveInputStream tarInput = new TarArchiveInputStream(this.provider.getInputStream(0L));
            int fileNum = 0;
            while ((tarEntry = tarInput.getNextTarEntry()) != null) {
                if (fileNum == tmd.fileNum) {
                    if (!tmd.tarArchiveEntry.getName().equals(tarEntry.getName())) {
                        throw new IOException("Mismatch between filenum and tarEntry for " + file);
                    }
                    return tarInput;
                }
                ++fileNum;
            }
            throw new IOException("Could not find requested file " + file);
        }, monitor);
        return fileBP;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    private static class TarMetadata {
        TarArchiveEntry tarArchiveEntry;
        int fileNum;

        TarMetadata(TarArchiveEntry tae, int fileNum) {
            this.tarArchiveEntry = tae;
            this.fileNum = fileNum;
        }
    }
}

