/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.dmg.DmgClientFileSystemFactory;
import ghidra.file.formats.ios.dmg.DmgServerProcessManager;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@FileSystemInfo(type="dmg", description="iOS Disk Image (DMG)", factory=DmgClientFileSystemFactory.class)
public class DmgClientFileSystem
implements GFileSystem {
    private final FSRLRoot fsrl;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private FileSystemIndexHelper<Object> fsih;
    private File decryptedDmgFile;
    private boolean deleteFileWhenDone;
    private DmgServerProcessManager processManager;
    private CancelledListener listener = () -> this.processManager.interruptCmd();
    private FileSystemService fsService;

    public DmgClientFileSystem(File decryptedDmgFile, boolean deleteFileWhenDone, FSRLRoot fsrl, FileSystemService fsService) {
        this.fsrl = fsrl;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsrl);
        this.decryptedDmgFile = decryptedDmgFile;
        this.deleteFileWhenDone = deleteFileWhenDone;
        this.fsService = fsService;
    }

    public void mount(TaskMonitor monitor) throws CancelledException, IOException {
        this.processManager = new DmgServerProcessManager(this.decryptedDmgFile, this.fsrl.getContainer().getName());
        monitor.addCancelledListener(this.listener);
        try {
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, 1L);
            this.recurseDirectories(this.fsih.getRootDir(), (TaskMonitor)upwtm);
        }
        finally {
            monitor.removeCancelledListener(this.listener);
        }
        Msg.info((Object)this, (Object)("Indexed " + this.fsih.getFileCount() + " files in " + this.fsrl.getContainer().getName()));
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.processManager.close();
        this.processManager = null;
        this.fsih.clear();
        this.fsih = null;
        if (this.deleteFileWhenDone) {
            Msg.info((Object)this, (Object)("Deleting DMG temp file:" + this.decryptedDmgFile));
            this.decryptedDmgFile.delete();
        }
    }

    public String getName() {
        return this.fsrl.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsrl;
    }

    public boolean isClosed() {
        return this.processManager == null;
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.addCancelledListener(this.listener);
        try {
            ByteProvider fileProvider;
            List<String> results = this.processManager.sendCmd("get_data " + file.getPath(), 1);
            File extractedFile = new File(results.get(0));
            if (!extractedFile.exists() || extractedFile.length() == 0L) {
                ByteProvider byteProvider = null;
                return byteProvider;
            }
            ByteProvider byteProvider = fileProvider = this.fsService.pushFileToCache(extractedFile, file.getFSRL(), monitor);
            return byteProvider;
        }
        finally {
            monitor.removeCancelledListener(this.listener);
        }
    }

    private void recurseDirectories(GFile dir, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Indexing " + dir.getName());
        List<GFile> files = this.getRawListing(dir);
        for (GFile f : files) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            GFile newF = this.fsih.storeFileWithParent(f.getName(), dir, -1L, f.isDirectory(), f.getLength(), null);
            if (!newF.isDirectory()) continue;
            this.recurseDirectories(newF, monitor);
        }
    }

    private List<GFile> getRawListing(GFile dir) throws IOException {
        List<String> childInfo = this.processManager.sendCmd("get_listing " + dir.getPath(), -3);
        if (childInfo.size() % 3 != 0) {
            throw new IOException("Bad response for get_listing for directory " + dir);
        }
        ArrayList<GFile> results = new ArrayList<GFile>();
        for (int i = 0; i < childInfo.size(); i += 3) {
            String name = childInfo.get(i + 0);
            boolean isDirectory = childInfo.get(i + 1).equals("true");
            long length = Long.parseLong(childInfo.get(i + 2));
            GFileImpl gFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)dir, (String)name, (boolean)isDirectory, (long)length, null);
            results.add((GFile)gFile);
        }
        return results;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public int getFileCount() {
        return this.fsih.getFileCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        monitor.addCancelledListener(this.listener);
        FileAttributes fileAttributes = new FileAttributes();
        try {
            List<String> infoResults = this.processManager.sendCmd("get_info " + file.getPath(), -1);
            int count = 1;
            for (String s : infoResults) {
                String[] sParts = s.split(": *", 2);
                if (sParts.length == 2) {
                    fileAttributes.add(sParts[0], (Object)sParts[1]);
                    continue;
                }
                fileAttributes.add("Unknown Attribute " + count++, (Object)s);
            }
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"DMG: Unable To Get Info", (Object)e.getMessage());
        }
        finally {
            monitor.removeCancelledListener(this.listener);
        }
        return fileAttributes;
    }
}

