/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VdexStringTable
implements StructConverter {
    private int stringCount;
    private List<String> strings = new ArrayList<String>();

    VdexStringTable(BinaryReader reader) throws IOException {
        this.stringCount = Byte.toUnsignedInt(reader.readNextByte());
        for (int i = 0; i < this.stringCount; ++i) {
            this.strings.add(reader.readNextAsciiString());
        }
    }

    public int getStringCount() {
        return this.stringCount;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public int getSize() {
        int size = 1;
        for (int i = 0; i < this.stringCount; ++i) {
            String string = this.strings.get(i);
            size += string.length() + 1;
        }
        return size;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(VdexStringTable.class.getSimpleName() + "_" + this.stringCount, 0);
        structure.add(BYTE, "stringCount", null);
        for (int i = 0; i < this.stringCount; ++i) {
            String string = this.strings.get(i);
            structure.add(STRING, string.length() + 1, "string_" + i, null);
        }
        structure.setCategoryPath(new CategoryPath("/vdex"));
        return structure;
    }
}

