/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatInstructionSet;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.List;

public class OatHeader_12
extends OatHeader {
    protected int oat_checksum_;
    protected int instruction_set_;
    protected int instruction_set_features_bitmap_;
    protected int dex_file_count_;
    protected int oat_dex_files_offset_;
    protected int executable_offset_;
    protected int jni_dlsym_lookup_offset_;
    protected int jni_dlsym_lookup_critical_trampoline_offset_;
    protected int quick_generic_jni_trampoline_offset_;
    protected int quick_imt_conflict_trampoline_offset_;
    protected int quick_resolution_trampoline_offset_;
    protected int quick_to_interpreter_bridge_offset_;
    protected int nterp_trampoline_offset_;
    protected int key_value_store_size_;

    OatHeader_12(BinaryReader reader) throws IOException {
        super(reader);
        this.oat_checksum_ = reader.readNextInt();
        this.instruction_set_ = reader.readNextInt();
        this.instruction_set_features_bitmap_ = reader.readNextInt();
        this.dex_file_count_ = reader.readNextInt();
        this.oat_dex_files_offset_ = reader.readNextInt();
        this.executable_offset_ = reader.readNextInt();
        this.jni_dlsym_lookup_offset_ = reader.readNextInt();
        this.jni_dlsym_lookup_critical_trampoline_offset_ = reader.readNextInt();
        this.quick_generic_jni_trampoline_offset_ = reader.readNextInt();
        this.quick_imt_conflict_trampoline_offset_ = reader.readNextInt();
        this.quick_resolution_trampoline_offset_ = reader.readNextInt();
        this.quick_to_interpreter_bridge_offset_ = reader.readNextInt();
        this.nterp_trampoline_offset_ = reader.readNextInt();
        this.key_value_store_size_ = reader.readNextInt();
    }

    @Override
    public int getOatDexFilesOffset(BinaryReader reader) {
        return this.oat_dex_files_offset_;
    }

    @Override
    public int getDexFileCount() {
        return this.dex_file_count_;
    }

    @Override
    public int getKeyValueStoreSize() {
        return this.key_value_store_size_;
    }

    @Override
    public List<OatDexFile> getOatDexFileList() {
        return this.oatDexFileList;
    }

    @Override
    public OatInstructionSet getInstructionSet() {
        return OatInstructionSet.valueOf(this.instruction_set_);
    }

    @Override
    public int getExecutableOffset() {
        return this.executable_offset_;
    }

    @Override
    public int getChecksum() {
        return this.oat_checksum_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatHeader_12.class.getSimpleName(), 0);
        structure.add(STRING, 4, "magic_", null);
        structure.add(STRING, 4, "version_", null);
        structure.add(DWORD, "oat_checksum_", null);
        structure.add(DWORD, "instruction_set_", null);
        structure.add(DWORD, "instruction_set_features_bitmap_", null);
        structure.add(DWORD, "dex_file_count_", null);
        structure.add(DWORD, "oat_dex_files_offset_", null);
        structure.add(DWORD, "executable_offset_", null);
        structure.add(DWORD, "jni_dlsym_lookup_offset_", null);
        structure.add(DWORD, "jni_dlsym_lookup_critical_trampoline_offset_", null);
        structure.add(DWORD, "quick_generic_jni_trampoline_offset_", null);
        structure.add(DWORD, "quick_imt_conflict_trampoline_offset_", null);
        structure.add(DWORD, "quick_resolution_trampoline_offset_", null);
        structure.add(DWORD, "quick_to_interpreter_bridge_offset_", null);
        structure.add(DWORD, "nterp_trampoline_offset_", null);
        structure.add(DWORD, "key_value_store_size_", null);
        for (int i = 0; i < this.orderedKeyList.size(); ++i) {
            String key = (String)this.orderedKeyList.get(i);
            String value = (String)this.key_value_store_.get(key);
            structure.add(STRING, key.length() + 1, "key_value_store_[" + i + "].key", null);
            structure.add(STRING, value.length() + 1, "key_value_store_[" + i + "].value", null);
        }
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

