/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.fbpk.FBPT;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FBPK_Partition
implements StructConverter {
    private int type;
    private String name;
    private int dataSize;
    private int unknown1;
    private int offsetToNextPartitionTable;
    private int unknown2;
    private FBPT fbpt;
    private long dataStartOffset;

    public FBPK_Partition(BinaryReader reader) throws IOException {
        this.type = reader.readNextInt();
        this.name = reader.readNextAsciiString(36);
        this.dataSize = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
        this.offsetToNextPartitionTable = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        if (this.type == 0) {
            this.fbpt = new FBPT(reader);
        } else if (this.type == 1) {
            this.dataStartOffset = reader.getPointerIndex();
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public FBPT getFBPT() {
        return this.fbpt;
    }

    public long getDataStartOffset() {
        return this.dataStartOffset;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getOffsetToNextPartitionTable() {
        return this.offsetToNextPartitionTable;
    }

    public boolean isDirectory() {
        return this.getType() == 0;
    }

    public boolean isFile() {
        return this.getType() == 1;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPK_Partition.class.getSimpleName(), 0);
        struct.add(DWORD, "type", null);
        struct.add(STRING, 36, "name", null);
        struct.add(DWORD, "dataSize", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "offsetToNextPartitionTable", null);
        struct.add(DWORD, "unknown2", null);
        return struct;
    }
}

