/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.DefaultGraphMouse;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensKillingGraphMousePlugin;
import org.jungrapht.visualization.control.LensMagnificationGraphMousePlugin;
import org.jungrapht.visualization.control.LensRegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.LensSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.LensTranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.LensVertexSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLensGraphMouse<V, E>
extends DefaultGraphMouse<V, E>
implements LensGraphMouse {
    private static final Logger log = LoggerFactory.getLogger(DefaultLensGraphMouse.class);
    protected LensMagnificationGraphMousePlugin magnificationPlugin;
    protected LensKillingGraphMousePlugin lensKillingGraphMousePlugin;
    protected LensTranslatingGraphMousePlugin lensTranslatingGraphMousePlugin;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public DefaultLensGraphMouse() {
        this(new Builder());
        this.magnificationPlugin = new LensMagnificationGraphMousePlugin(1.0f, 6.0f, 0.2f);
    }

    DefaultLensGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly, builder.singleSelectionMask, builder.toggleSingleSelectionMask, builder.regionSelectionMask, builder.toggleRegionSelectionMask, builder.regionSelectionCompleteMask, builder.toggleRegionSelectionCompleteMask, builder.translatingMask, builder.lensTranslatingMask, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask, builder.magnificationPlugin);
    }

    DefaultLensGraphMouse(float in, float out, boolean vertexSelectionOnly, int singleSelectionMask, int toggleSingleSelectionMask, int regionSelectionMask, int toggleRegionSelectionMask, int regionSelectionCompleteMask, int toggleRegionSelectionCompleteMask, int translatingMask, int lensTranslatingMask, int scalingMask, int xAxisScalingMask, int yAxisScalingMask, LensMagnificationGraphMousePlugin magnificationPlugin) {
        super(in, out, vertexSelectionOnly, singleSelectionMask, toggleSingleSelectionMask, regionSelectionMask, toggleRegionSelectionMask, regionSelectionCompleteMask, toggleRegionSelectionCompleteMask, translatingMask, scalingMask, xAxisScalingMask, yAxisScalingMask);
        this.magnificationPlugin = magnificationPlugin;
        this.lensTranslatingGraphMousePlugin = new LensTranslatingGraphMousePlugin(lensTranslatingMask);
        this.lensKillingGraphMousePlugin = new LensKillingGraphMousePlugin();
        this.lensTranslatingGraphMousePlugin = new LensTranslatingGraphMousePlugin();
    }

    @Override
    public void setKillSwitch(Runnable killSwitch) {
        this.lensKillingGraphMousePlugin.setKillSwitch(killSwitch);
    }

    @Override
    public void loadPlugins() {
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), this.scalingMask, this.xAxisScalingMask, this.yAxisScalingMask, this.in, this.out);
        this.selectingPlugin = this.vertexSelectionOnly ? ((LensVertexSelectingGraphMousePlugin.Builder)((LensVertexSelectingGraphMousePlugin.Builder)LensVertexSelectingGraphMousePlugin.builder().singleSelectionMask(this.singleSelectionMask)).toggleSingleSelectionMask(this.toggleSingleSelectionMask)).build() : ((LensSelectingGraphMousePlugin.Builder)((LensSelectingGraphMousePlugin.Builder)LensSelectingGraphMousePlugin.builder().singleSelectionMask(this.singleSelectionMask)).toggleSingleSelectionMask(this.toggleSingleSelectionMask)).build();
        this.regionSelectingPlugin = new LensRegionSelectingGraphMousePlugin(this.regionSelectionMask, this.toggleRegionSelectionMask, this.regionSelectionCompleteMask, this.toggleRegionSelectionCompleteMask);
        this.translatingPlugin = ((TranslatingGraphMousePlugin.Builder)TranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
        this.add(this.lensKillingGraphMousePlugin);
        this.add(this.lensTranslatingGraphMousePlugin);
        this.add(this.selectingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.regionSelectingPlugin);
        this.add(this.magnificationPlugin);
        this.add(this.scalingPlugin);
    }

    public static class Builder<V, E, T extends DefaultLensGraphMouse, B extends Builder<V, E, T, B>>
    extends DefaultGraphMouse.Builder<V, E, T, B> {
        protected int lensTranslatingMask = Modifiers.masks.get(System.getProperty("jungrapht.lensTranslatingMask", "MB1"));
        protected LensMagnificationGraphMousePlugin magnificationPlugin = new LensMagnificationGraphMousePlugin(1.0f, 6.0f, 0.2f);

        public B magnificationPlugin(LensMagnificationGraphMousePlugin magnificationPlugin) {
            this.magnificationPlugin = magnificationPlugin;
            return (B)((Builder)this.self());
        }

        public B lensTranslatingMask(int lensTranslatingMask) {
            this.lensTranslatingMask = lensTranslatingMask;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new DefaultLensGraphMouse(this);
        }
    }
}

