/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.CoreGTreeNode;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeRootParentNode;
import docking.widgets.tree.TreeTaskMonitor;
import docking.widgets.tree.support.BreadthFirstIterator;
import docking.widgets.tree.support.DepthFirstIterator;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import util.CollectionUtils;

public abstract class GTreeNode
extends CoreGTreeNode
implements Comparable<GTreeNode> {
    @Override
    protected List<GTreeNode> generateChildren() {
        return Collections.emptyList();
    }

    public String getDisplayText() {
        return this.getName();
    }

    public abstract String getName();

    public abstract Icon getIcon(boolean var1);

    public abstract String getToolTip();

    public abstract boolean isLeaf();

    @Override
    public int compareTo(GTreeNode node) {
        return this.getName().compareToIgnoreCase(node.getName());
    }

    public void addNode(GTreeNode node) {
        Swing.runNow(() -> this.doAddNode(node));
    }

    public void addNodes(List<GTreeNode> nodes) {
        Swing.runNow(() -> this.doAddNodes(nodes));
    }

    public void addNode(int index, GTreeNode node) {
        Swing.runNow(() -> this.doAddNode(index, node));
    }

    public List<GTreeNode> getChildren() {
        return Collections.unmodifiableList(this.children());
    }

    public int getChildCount() {
        return this.children().size();
    }

    public GTreeNode getChild(String name) {
        for (GTreeNode node : this.children()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    public GTreeNode getChild(int index) {
        return this.children().get(index);
    }

    public int getNodeCount() {
        int count = 1;
        for (GTreeNode node : this.children()) {
            count += node.getNodeCount();
        }
        return count;
    }

    public int getLeafCount() {
        if (this.isLeaf() || !this.isLoaded()) {
            return 1;
        }
        int count = 0;
        for (GTreeNode node : this.children()) {
            count += node.getLeafCount();
        }
        return count == 0 ? 1 : count;
    }

    public int getIndexInParent() {
        GTreeNode parent = this.getParent();
        if (parent == null) {
            return -1;
        }
        return parent.getIndexOfChild(this);
    }

    public int getIndexOfChild(GTreeNode node) {
        return this.children().indexOf(node);
    }

    public TreePath getTreePath() {
        return new TreePath(this.getPathToRoot(this, 0));
    }

    public void removeAll() {
        Swing.runNow(() -> this.doSetChildrenAndFireEvent(null));
    }

    public void removeNode(GTreeNode node) {
        Swing.runNow(() -> this.doRemoveNode(node));
    }

    public void setChildren(List<GTreeNode> childList) {
        Swing.runNow(() -> this.doSetChildrenAndFireEvent(childList));
    }

    public boolean isAncestor(GTreeNode node) {
        for (GTreeNode nodeParent = node.getParent(); nodeParent != null; nodeParent = nodeParent.getParent()) {
            if (!nodeParent.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void valueChanged(Object newValue) {
    }

    public boolean isEditable() {
        return false;
    }

    public GTreeNode getRoot() {
        if (this.isRoot()) {
            return this;
        }
        GTreeNode myParent = this.getParent();
        if (myParent != null) {
            return myParent.getRoot();
        }
        return null;
    }

    public GTreeNode filter(GTreeFilter filter, TaskMonitor monitor) throws CancelledException, CloneNotSupportedException {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (this.isLoaded()) {
            for (GTreeNode child : this.children()) {
                monitor.checkCanceled();
                GTreeNode filtered = child.filter(filter, monitor);
                if (filtered != null) {
                    list.add(filtered);
                }
                monitor.incrementProgress(1L);
            }
        }
        if (this.isRoot() || !list.isEmpty() || filter.acceptsNode(this)) {
            GTreeNode clone = this.clone();
            clone.doSetChildren(list);
            return clone;
        }
        return null;
    }

    public int loadAll(TaskMonitor monitor) throws CancelledException {
        List<GTreeNode> children = this.children();
        monitor = new TreeTaskMonitor(monitor, children.size());
        int count = 1;
        for (GTreeNode child : children) {
            monitor.checkCanceled();
            count += child.loadAll(monitor);
            monitor.incrementProgress(1L);
        }
        return count;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTreeNode other = (GTreeNode)obj;
        return this.getName().equals(other.getName());
    }

    public Stream<GTreeNode> stream(boolean depthFirst) {
        return CollectionUtils.asStream(this.iterator(depthFirst));
    }

    public Iterator<GTreeNode> iterator(boolean depthFirst) {
        if (depthFirst) {
            return new DepthFirstIterator(this);
        }
        return new BreadthFirstIterator(this);
    }

    public String toString() {
        return this.getName();
    }

    public void fireNodeStructureChanged(GTreeNode node) {
        Swing.runNow(() -> this.doFireNodeStructureChanged());
    }

    public void fireNodeChanged(GTreeNode parentNode, GTreeNode node) {
        Swing.runNow(() -> this.doFireNodeChanged());
    }

    public void expand() {
        GTree tree = this.getTree();
        if (tree != null) {
            tree.expandPath(this);
        }
    }

    public void collapse() {
        GTree tree = this.getTree();
        if (tree != null) {
            tree.collapseAll(this);
        }
    }

    public boolean isExpanded() {
        GTree tree = this.getTree();
        if (tree != null) {
            return tree.isExpanded(this.getTreePath());
        }
        return false;
    }

    private GTreeNode[] getPathToRoot(GTreeNode node, int depth) {
        GTreeNode[] returnNodes;
        if (node == null || node instanceof GTreeRootParentNode) {
            if (depth == 0) {
                return null;
            }
            returnNodes = new GTreeNode[depth];
        } else {
            returnNodes = this.getPathToRoot(node.getParent(), ++depth);
            returnNodes[returnNodes.length - depth] = node;
        }
        return returnNodes;
    }
}

