/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableRowMapper;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.table.column.GColumnRenderer;
import java.util.Comparator;

public class MappedTableColumn<ROW_TYPE, EXPECTED_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>
extends AbstractDynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> {
    protected final TableRowMapper<ROW_TYPE, EXPECTED_ROW_TYPE, DATA_SOURCE> mapper;
    protected final DynamicTableColumn<EXPECTED_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> tableColumn;

    protected MappedTableColumn(TableRowMapper<ROW_TYPE, EXPECTED_ROW_TYPE, DATA_SOURCE> mapper, DynamicTableColumn<EXPECTED_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> tableColumn) {
        this(mapper, tableColumn, tableColumn.getUniqueIdentifier());
    }

    protected MappedTableColumn(TableRowMapper<ROW_TYPE, EXPECTED_ROW_TYPE, DATA_SOURCE> mapper, DynamicTableColumn<EXPECTED_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> tableColumn, String uniqueIdentifier) {
        super(uniqueIdentifier);
        this.mapper = mapper;
        this.tableColumn = tableColumn;
    }

    public Class<?> getMappedColumnClass() {
        if (this.tableColumn instanceof MappedTableColumn) {
            return ((MappedTableColumn)this.tableColumn).getMappedColumnClass();
        }
        return this.tableColumn.getClass();
    }

    @Override
    public Class<COLUMN_TYPE> getColumnClass() {
        return this.tableColumn.getColumnClass();
    }

    @Override
    public Class<ROW_TYPE> getSupportedRowType() {
        return this.mapper.getSourceType();
    }

    @Override
    public String getColumnDisplayName(Settings settings) {
        return this.tableColumn.getColumnDisplayName(settings);
    }

    @Override
    public String getColumnDescription() {
        return this.tableColumn.getColumnDescription();
    }

    @Override
    public String getColumnName() {
        return this.tableColumn.getColumnName();
    }

    @Override
    public int getMaxLines(Settings settings) {
        return this.tableColumn.getMaxLines(settings);
    }

    @Override
    public GColumnRenderer<COLUMN_TYPE> getColumnRenderer() {
        return this.tableColumn.getColumnRenderer();
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.tableColumn.getSettingsDefinitions();
    }

    @Override
    public int getColumnPreferredWidth() {
        return this.tableColumn.getColumnPreferredWidth();
    }

    @Override
    public Comparator<COLUMN_TYPE> getComparator() {
        return this.tableColumn.getComparator();
    }

    @Override
    public COLUMN_TYPE getValue(ROW_TYPE rowObject, Settings settings, DATA_SOURCE data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        if (rowObject == null) {
            return null;
        }
        EXPECTED_ROW_TYPE mappedObject = this.mapper.map(rowObject, data, serviceProvider);
        if (mappedObject == null) {
            return null;
        }
        return this.tableColumn.getValue(mappedObject, settings, data, serviceProvider);
    }

    @Override
    public String toString() {
        return "TableColumn: " + this.getUniqueIdentifier();
    }
}

