/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.StrutFieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.json.Json;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class VerticalLayoutTextField
implements TextField {
    protected List<FieldRow> subFields;
    protected int startX;
    protected int width;
    protected int preferredWidth;
    protected HighlightFactory hlFactory;
    private int height;
    private int heightAbove;
    private int numDataRows;
    private boolean isPrimary;
    private String fullText;
    private List<String> lines;
    private String rowSeparator;
    protected boolean isClipped;

    @Deprecated(since="10.1", forRemoval=true)
    public VerticalLayoutTextField(FieldElement[] textElements, int startX, int width, int maxLines, HighlightFactory hlFactory) {
        this(Arrays.asList(textElements), startX, width, maxLines, hlFactory, " ");
    }

    public VerticalLayoutTextField(List<FieldElement> textElements, int startX, int width, int maxLines, HighlightFactory hlFactory) {
        this(textElements, startX, width, maxLines, hlFactory, " ");
    }

    protected VerticalLayoutTextField(List<FieldElement> textElements, int startX, int width, int maxLines, HighlightFactory hlFactory, String rowSeparator) {
        this.startX = startX;
        this.width = width;
        this.hlFactory = hlFactory;
        this.rowSeparator = rowSeparator;
        this.lines = this.generateLines(textElements);
        this.fullText = this.generateText(textElements, rowSeparator);
        this.subFields = this.layoutElements(textElements, maxLines);
        this.numDataRows = textElements.size();
        this.preferredWidth = this.calculatePreferredWidth();
        this.calculateHeight();
    }

    private List<String> generateLines(List<FieldElement> textElements) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldElement field : textElements) {
            list.add(field.getText());
        }
        return list;
    }

    private String generateText(List<FieldElement> elements, String delimiter) {
        StringBuilder buf = new StringBuilder();
        int n = elements.size() - 1;
        for (int i = 0; i < n; ++i) {
            buf.append(elements.get(i).getText()).append(delimiter);
        }
        buf.append(elements.get(n).getText());
        return buf.toString();
    }

    protected void calculateHeight() {
        this.heightAbove = this.subFields.get((int)0).field.getHeightAbove();
        for (FieldRow fieldRow : this.subFields) {
            this.height += fieldRow.field.getHeight();
        }
    }

    private int calculatePreferredWidth() {
        int widest = 0;
        for (FieldRow fieldRow : this.subFields) {
            widest = Math.max(widest, fieldRow.field.getPreferredWidth());
        }
        return widest;
    }

    @Override
    public String getText() {
        return this.fullText;
    }

    @Override
    public String getTextWithLineSeparators() {
        return StringUtils.join(this.lines, (char)'\n');
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStartX() {
        return this.startX;
    }

    @Override
    public int getNumDataRows() {
        return this.numDataRows;
    }

    @Override
    public int getNumRows() {
        return this.subFields.size();
    }

    @Override
    public int getNumCols(int row) {
        TextField f = this.getField(row);
        return f.getNumCols(0);
    }

    @Override
    public int getRow(int y) {
        int startY = -this.heightAbove;
        if (y < startY) {
            return 0;
        }
        int ySoFar = startY;
        int n = this.subFields.size();
        for (int i = 0; i < n; ++i) {
            TextField f = this.getField(i);
            if ((ySoFar += f.getHeight()) <= y) continue;
            return i;
        }
        return n - 1;
    }

    @Override
    public int getCol(int row, int x) {
        TextField f = this.getField(row);
        return f.getCol(0, x);
    }

    @Override
    public int getY(int row) {
        int startY;
        int y = startY = -this.heightAbove;
        int n = Math.min(row, this.subFields.size() - 1);
        for (int i = 0; i < n; ++i) {
            TextField f = this.getField(i);
            y += f.getHeight();
        }
        return y;
    }

    @Override
    public int getX(int row, int col) {
        TextField f = this.getField(row);
        return f.getX(0, col);
    }

    @Override
    public boolean isValid(int row, int col) {
        if (row < 0 || row >= this.subFields.size()) {
            return false;
        }
        TextField f = this.getField(row);
        return f.isValid(0, col);
    }

    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLoc, int rowHeight) {
        int startY;
        if (context.isPrinting()) {
            this.print(g, context);
            return;
        }
        int cursorTextOffset = -1;
        int cursorRow = -1;
        if (cursorLoc != null) {
            cursorTextOffset = this.screenLocationToTextOffset(cursorLoc.row(), cursorLoc.col());
            cursorRow = cursorLoc.row();
        }
        Highlight[] highlights = this.hlFactory.getHighlights(this, this.getText(), cursorTextOffset);
        int columns = 0;
        int n = this.subFields.size();
        int myStartY = -this.heightAbove;
        int myEndY = myStartY + rowHeight;
        int clipStartY = clip.y;
        int clipEndY = clip.y + clip.height;
        Color fieldBackgroundColor = colorManager.getBackgroundColor();
        if (fieldBackgroundColor != null) {
            g.setColor(fieldBackgroundColor);
            startY = Math.max(myStartY, clipStartY);
            int endY = Math.min(myEndY, clipEndY);
            int clippedHeight = endY - startY;
            g.fillRect(this.startX, startY, this.width, clippedHeight);
        }
        startY = myStartY;
        int translatedY = 0;
        int extraSpace = this.rowSeparator.length();
        for (int i = 0; i < n; ++i) {
            ClippingTextField subField = (ClippingTextField)this.getField(i);
            int subFieldHeight = subField.getHeight();
            int endY = startY + subFieldHeight;
            if (startY > clipEndY) break;
            if (endY >= clipStartY) {
                for (Highlight highlight : highlights) {
                    highlight.setOffset(-columns);
                }
                subField.paintSelection(g, colorManager, i, rowHeight);
                subField.paintHighlights(g, highlights);
                subField.paintText(c, g, context);
                if (cursorRow == i) {
                    subField.paintCursor(g, context.getCursorColor(), cursorLoc);
                }
            }
            startY += subFieldHeight;
            g.translate(0, subFieldHeight);
            translatedY += subFieldHeight;
            columns += subField.getText().length() + extraSpace;
        }
        g.translate(0, -translatedY);
    }

    private void print(Graphics g, PaintContext context) {
        int n = this.subFields.size();
        for (int i = 0; i < n; ++i) {
            ClippingTextField clippingField = (ClippingTextField)this.getField(i);
            clippingField.print(g, context);
            g.translate(0, clippingField.getHeight());
        }
        g.translate(0, -this.height);
    }

    @Override
    public Rectangle getCursorBounds(int row, int col) {
        if (row < 0 || row >= this.subFields.size()) {
            return null;
        }
        TextField f = this.getField(row);
        Rectangle r = f.getCursorBounds(0, col);
        for (int i = 0; i < row; ++i) {
            f = this.getField(i);
            r.y += f.getHeight();
        }
        return r;
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.width && y >= -this.heightAbove && y < this.height - this.heightAbove;
    }

    @Override
    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.heightAbove || topOfScreen > this.height - this.heightAbove) {
            return max;
        }
        int row = this.getRow(topOfScreen);
        int y = this.getY(row);
        int rowOffset = topOfScreen - y;
        int rowHeight = this.getField(row).getHeight();
        if (direction > 0) {
            return rowHeight - rowOffset;
        }
        if (rowOffset == 0) {
            return -rowHeight;
        }
        return -rowOffset;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void setPrimary(boolean state) {
        this.isPrimary = state;
    }

    @Override
    public int getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        return this.height - this.heightAbove;
    }

    @Override
    public void rowHeightChanged(int heightAbove1, int heightBelow) {
    }

    @Override
    public FieldElement getFieldElement(int screenRow, int screenColumn) {
        TextField f = this.getField(screenRow);
        int fieldRow = 0;
        return f.getFieldElement(fieldRow, screenColumn);
    }

    protected List<FieldRow> layoutElements(List<FieldElement> textElements, int maxLines) {
        ArrayList<FieldRow> newSubFields = new ArrayList<FieldRow>();
        boolean tooManyLines = textElements.size() > maxLines;
        int currentRow = 0;
        for (int i = 0; i < textElements.size() && i < maxLines; ++i) {
            FieldElement element = textElements.get(i);
            if (tooManyLines && i == maxLines - 1) {
                FieldElement[] elements = new FieldElement[]{element, new StrutFieldElement(500)};
                element = new CompositeFieldElement(elements);
            }
            TextField field = this.createFieldForLine(element);
            int modelRow = currentRow;
            int screenRow = newSubFields.size();
            newSubFields.add(new FieldRow(field, modelRow, screenRow));
            this.isClipped |= field.isClipped();
            currentRow += field.getNumRows();
        }
        this.isClipped |= tooManyLines;
        return newSubFields;
    }

    protected TextField createFieldForLine(FieldElement element) {
        return new ClippingTextField(this.startX, this.width, element, this.hlFactory);
    }

    @Override
    public RowColLocation screenToDataLocation(int screenRow, int screenColumn) {
        screenRow = Math.min(screenRow, this.subFields.size() - 1);
        screenRow = Math.max(screenRow, 0);
        TextField field = this.getField(screenRow);
        screenColumn = Math.min(screenColumn, field.getText().length());
        screenColumn = Math.max(screenColumn, 0);
        int dataRow = this.getDataRow(field);
        return field.screenToDataLocation(dataRow, screenColumn);
    }

    @Override
    public RowColLocation dataToScreenLocation(int dataRow, int dataColumn) {
        FieldRow fieldRow = this.getFieldRowFromDataRow(dataRow);
        TextField field = fieldRow.field;
        RowColLocation location = field.dataToScreenLocation(dataRow, dataColumn);
        int screenRow = fieldRow.screenRow;
        return location.withRow(screenRow);
    }

    @Override
    public int screenLocationToTextOffset(int row, int col) {
        if (row >= this.subFields.size()) {
            return this.getText().length();
        }
        int extraSpace = this.rowSeparator.length();
        int len = 0;
        for (int i = 0; i < row; ++i) {
            len += this.lines.get(i).length() + extraSpace;
        }
        return len += Math.min(col, this.lines.get(row).length());
    }

    @Override
    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        int absoluteOffset = textOffset;
        int extraSpace = this.rowSeparator.length();
        int n = this.subFields.size();
        for (int i = 0; i < n; ++i) {
            int len = this.lines.get(i).length();
            if (absoluteOffset < len + extraSpace) {
                return new RowColLocation(i, absoluteOffset);
            }
            absoluteOffset -= len + extraSpace;
        }
        int lastRow = n - 1;
        TextField field = this.getField(lastRow);
        int lastColumn = field.getText().length();
        return new DefaultRowColLocation(lastRow, lastColumn);
    }

    @Override
    public boolean isClipped() {
        return this.isClipped;
    }

    protected List<String> getLines() {
        return this.lines;
    }

    private TextField getField(int screenRow) {
        if (screenRow >= this.subFields.size()) {
            return null;
        }
        return this.subFields.get((int)screenRow).field;
    }

    private FieldRow getFieldRowFromDataRow(int dataRow) {
        int currentRow = 0;
        for (FieldRow row : this.subFields) {
            int length = row.field.getNumDataRows();
            if (currentRow + length > dataRow) {
                return row;
            }
            currentRow += length;
        }
        return this.subFields.get(this.subFields.size() - 1);
    }

    private int getDataRow(TextField field) {
        for (FieldRow fieldRow : this.subFields) {
            if (fieldRow.field != field) continue;
            return fieldRow.dataRow;
        }
        return 0;
    }

    private class FieldRow {
        private TextField field;
        private int dataRow;
        private int screenRow;

        FieldRow(TextField field, int dataRow, int screenRow) {
            this.field = field;
            this.dataRow = dataRow;
            this.screenRow = screenRow;
        }

        public String toString() {
            return Json.toString((Object)this);
        }
    }
}

