/*
 * Decompiled with CFR 0.152.
 */
package docking.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.Timer;

public class AnimatedIcon
implements Icon {
    private static final int MAGIC_TIMER_CALLS_WITHOUT_PAINT_CALL = 5;
    private final List<? extends Icon> iconList;
    private int currentIconIndex = 0;
    private Component component;
    private int height;
    private int width;
    private int skipFrames;
    private int skipFrameCount = 0;
    private Timer timer;
    private int paintCounter = 0;

    public AnimatedIcon(List<? extends Icon> icons, int frameDelay, int framesToSkip) {
        this.iconList = icons;
        this.skipFrames = framesToSkip;
        this.timer = new Timer(frameDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (--AnimatedIcon.this.paintCounter <= 0) {
                    AnimatedIcon.this.timer.stop();
                    return;
                }
                if (AnimatedIcon.this.skipFrameCount > 0) {
                    --AnimatedIcon.this.skipFrameCount;
                    return;
                }
                if (++AnimatedIcon.this.currentIconIndex >= AnimatedIcon.this.iconList.size()) {
                    AnimatedIcon.this.currentIconIndex = 0;
                    AnimatedIcon.this.skipFrameCount = AnimatedIcon.this.skipFrames;
                }
                if (AnimatedIcon.this.component != null) {
                    AnimatedIcon.this.component.repaint();
                }
            }
        });
        for (Icon icon : this.iconList) {
            this.width = Math.max(this.width, icon.getIconWidth());
            this.height = Math.max(this.height, icon.getIconHeight());
        }
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    private void restartAnimation() {
        this.timer.start();
        this.paintCounter = 5;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.restartAnimation();
        this.iconList.get(this.currentIconIndex).paintIcon(c, g, x, y);
        this.component = c;
    }
}

