/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.action.DockingActionIf;
import docking.help.GHelpBroker;
import docking.help.GHelpClassLoader;
import docking.help.GHelpSet;
import docking.help.Help;
import docking.help.HelpDescriptor;
import docking.help.HelpService;
import generic.concurrent.GThreadPool;
import generic.util.WindowUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.swing.JButton;
import javax.swing.UIManager;
import resources.ResourceManager;
import utilities.util.reflection.ReflectionUtilities;

public class HelpManager
implements HelpService {
    public static final String SHOW_AID_KEY = "SHOW.HELP.NAVIGATION.AID";
    private static final String TABLE_OF_CONTENTS_FILENAME_KEY = "data";
    private static final URL HELP_NOT_FOUND_PAGE_URL = ResourceManager.getResource((String)"help/empty.htm");
    private static final String TABLE_OF_CONTENTS_VIEW_NAME = "TOC";
    private static final String GHIDRA_HELP_TITLE = "Ghidra Help";
    private GHelpSet mainHS;
    private HelpBroker mainHB;
    private HashMap<URL, HelpSet> urlToHelpSets = new HashMap();
    private java.util.Map<Object, HelpLocation> helpLocations = new WeakHashMap<Object, HelpLocation>();
    private List<HelpSet> helpSetsPendingMerge = new ArrayList<HelpSet>();
    private boolean hasMergedHelpSets;
    private boolean isValidHelp;
    private boolean hasBeenDisplayed;
    private Set<Object> excludedFromHelp = Collections.newSetFromMap(new WeakHashMap());

    protected HelpManager(URL url) throws HelpSetException {
        this.mainHS = new GHelpSet(new GHelpClassLoader(null), url);
        this.mainHB = this.mainHS.createHelpBroker();
        this.mainHS.setTitle(GHIDRA_HELP_TITLE);
        this.setColorResources();
        this.isValidHelp = this.isValidHelp();
    }

    protected void registerHelp() {
        this.mergePendingHelpSets();
        Help.installHelpService(this);
    }

    @Override
    public boolean helpExists() {
        return this.isValidHelp && this.hasMergedHelpSets;
    }

    public void addHelpSet(URL url, GHelpClassLoader classLoader) throws HelpSetException {
        HelpSet hs = this.createHelpSet(url, classLoader);
        if (hs == null) {
            return;
        }
        if (this.hasMergedHelpSets) {
            this.mainHS.add(hs);
        } else {
            this.helpSetsPendingMerge.add(hs);
        }
    }

    @Override
    public void excludeFromHelp(Object helpObject) {
        this.excludedFromHelp.add(helpObject);
        this.helpLocations.remove(helpObject);
    }

    @Override
    public boolean isExcludedFromHelp(Object helpObject) {
        return this.excludedFromHelp.contains(helpObject);
    }

    @Override
    public void clearHelp(Object helpObject) {
        this.helpLocations.remove(helpObject);
    }

    @Override
    public void registerHelp(Object helpObject, HelpLocation location) {
        if (location == null) {
            Throwable t = ReflectionUtilities.createJavaFilteredThrowable();
            Msg.debug((Object)this, (Object)"Deprecated use of registerHelp() - use excludeFromHelp()\n", (Throwable)t);
            this.excludeFromHelp(helpObject);
            return;
        }
        if (helpObject instanceof Window) {
            Msg.error((Object)this, (Object)"Cannot register help for a top-level window", (Throwable)new AssertException());
            return;
        }
        if (this.isExcluded(helpObject)) {
            return;
        }
        this.helpLocations.put(helpObject, location);
    }

    private boolean isExcluded(Object helpee) {
        return this.excludedFromHelp.contains(helpee);
    }

    @Override
    public HelpLocation getHelpLocation(Object helpObj) {
        return this.helpLocations.get(helpObj);
    }

    public GHelpSet getMasterHelpSet() {
        return this.mainHS;
    }

    @Override
    public void showHelp(URL url) {
        if (!this.isValidHelp) {
            Msg.warn((Object)this, (Object)"Help is not in a valid state.  This can happen when help has not been built.");
            return;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getActiveWindow();
        this.displayHelp(url, window);
    }

    @Override
    public void showHelp(Object helpObj, boolean infoOnly, Component owner) {
        if (!this.isValidHelp && !infoOnly) {
            Msg.warn((Object)this, (Object)"Help is not in a valid state.  This can happen when help has not been built.");
            return;
        }
        while (owner != null && !(owner instanceof Window)) {
            owner = owner.getParent();
        }
        Window window = (Window)owner;
        Dialog modalDialog = WindowUtilities.findModalestDialog();
        if (modalDialog != null) {
            window = modalDialog;
        }
        HelpLocation loc = this.findHelpLocation(helpObj);
        if (infoOnly) {
            this.displayHelpInfo(helpObj, loc, window);
            return;
        }
        if (loc != null) {
            URL url = loc.getHelpURL();
            if (url != null) {
                this.displayHelp(url, window);
                return;
            }
            String helpIDString = loc.getHelpId();
            if (helpIDString != null) {
                try {
                    this.displayHelp(this.createHelpID(helpIDString), window);
                    return;
                }
                catch (BadIDException e) {
                    Msg.info((Object)this, (Object)("Could not find help for ID: \"" + helpIDString + "\" from HelpLocation: " + loc));
                }
            }
        }
        this.displayHelp(this.mainHS.getHomeID(), window);
    }

    private Map.ID createHelpID(String helpIDString) {
        BadIDException helpException = null;
        try {
            return Map.ID.create((String)helpIDString, (HelpSet)this.mainHS);
        }
        catch (BadIDException bide) {
            Map combinedMap;
            Map.ID ID2;
            helpException = bide;
            URL URL2 = null;
            try {
                URL2 = new URL(helpIDString);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (URL2 != null && (ID2 = (combinedMap = this.mainHS.getCombinedMap()).getIDFromURL(URL2)) != null) {
                return ID2;
            }
            throw helpException;
        }
    }

    private HelpLocation findHelpLocation(Object helpObj) {
        if (helpObj instanceof HelpDescriptor) {
            HelpDescriptor helpDescriptor = (HelpDescriptor)helpObj;
            Object helpObject = helpDescriptor.getHelpObject();
            return this.helpLocations.get(helpObject);
        }
        return this.helpLocations.get(helpObj);
    }

    private String getFilenameForHelpLocation(HelpLocation helpLocation) {
        URL helpFileURL = this.getURLForHelpLocation(helpLocation);
        if (helpFileURL == null) {
            return null;
        }
        String file = helpFileURL.getFile();
        int filenameStart = file.lastIndexOf(47) + 1;
        int anchorIndex = file.indexOf(35);
        int filenameEnd = anchorIndex == -1 ? file.length() : anchorIndex;
        return file.substring(filenameStart, filenameEnd);
    }

    private URL getURLForHelpLocation(HelpLocation helpLocation) {
        String helpId = helpLocation.getHelpId();
        Map.ID id = null;
        try {
            id = this.createHelpID(helpId);
        }
        catch (BadIDException e) {
            return null;
        }
        if (id == null) {
            return helpLocation.getHelpURL();
        }
        HelpSet hs = id.hs;
        try {
            return hs.getCombinedMap().getURLFromID(id);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean hasValidHelp(Object helpee, HelpLocation location) {
        if (this.isKeybindingOnly(helpee)) {
            return true;
        }
        if (location == null) {
            return false;
        }
        return this.isValidHelpLocation(location);
    }

    private boolean isValidHelpLocation(HelpLocation helpLoc) {
        if (helpLoc.getHelpURL() != null) {
            return true;
        }
        String helpId = helpLoc.getHelpId();
        Map.ID id = null;
        try {
            id = this.createHelpID(helpId);
        }
        catch (BadIDException badIDException) {
            // empty catch block
        }
        if (id == null) {
            return false;
        }
        HelpSet helpSet = id.getHelpSet();
        Map combinedMap = helpSet.getCombinedMap();
        try {
            URL url = combinedMap.getURLFromID(id);
            if (url == null) {
                Msg.debug((Object)this, (Object)("Unable to find help for ID: " + id));
                return false;
            }
            return this.isURLValid(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void displayHelp(Object help, Window owner) {
        if (help == null) {
            return;
        }
        boolean wasDisplayed = this.mainHB.isDisplayed();
        if (this.mainHB instanceof DefaultHelpBroker) {
            ((DefaultHelpBroker)this.mainHB).setActivationWindow(owner);
        }
        this.mainHB.setDisplayed(true);
        if (!wasDisplayed) {
            SystemUtilities.runSwingLater(() -> this.displayHelp(help, owner));
            return;
        }
        this.mergePendingHelpSets();
        URL helpURL = null;
        if (help instanceof Map.ID) {
            helpURL = this.getURLForID((Map.ID)help);
        } else if (help instanceof URL) {
            helpURL = (URL)help;
        }
        this.displayHelpUrl(help, helpURL);
        this.printBadHelp();
        this.hasBeenDisplayed = true;
    }

    private void printBadHelp() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        if (this.hasBeenDisplayed) {
            return;
        }
        GThreadPool.runAsync((String)"GSwing Worker", this::doPrintBadHelp);
    }

    private void doPrintBadHelp() {
        java.util.Map<Object, HelpLocation> badHelp;
        try {
            badHelp = this.getInvalidHelpLocations(TaskMonitor.DUMMY);
            if (badHelp.isEmpty()) {
                return;
            }
        }
        catch (CancelledException e) {
            return;
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append("Found the following invalid help locations:\n");
        for (HelpLocation loc : badHelp.values()) {
            buffy.append('\t').append(loc.toString()).append('\n');
            buffy.append("                ").append(loc.getInceptionInformation()).append('\n');
        }
        new Throwable("Bad Help Locations Found!\n" + buffy.toString()).printStackTrace();
    }

    public java.util.Map<Object, HelpLocation> getInvalidHelpLocations(TaskMonitor monitor) throws CancelledException {
        WeakHashMap<Object, HelpLocation> map = new WeakHashMap<Object, HelpLocation>();
        java.util.Map<Object, HelpLocation> helpLocationsCopy = this.copyHelpLocations();
        monitor.initialize((long)helpLocationsCopy.size());
        Set<Map.Entry<Object, HelpLocation>> entries = helpLocationsCopy.entrySet();
        for (Map.Entry<Object, HelpLocation> entry : entries) {
            monitor.checkCanceled();
            Object helpee = entry.getKey();
            HelpLocation location = entry.getValue();
            monitor.setMessage("Checking " + helpee);
            if (!this.hasValidHelp(helpee, location)) {
                map.put(helpee, location);
            }
            monitor.incrementProgress(1L);
        }
        return map;
    }

    private java.util.Map<Object, HelpLocation> copyHelpLocations() {
        return (java.util.Map)Swing.runNow(() -> new HashMap<Object, HelpLocation>(this.helpLocations));
    }

    private boolean isKeybindingOnly(Object helpee) {
        if (!(helpee instanceof DockingActionIf)) {
            return false;
        }
        DockingActionIf action = (DockingActionIf)helpee;
        if (action.getToolBarData() != null) {
            return false;
        }
        if (action.getMenuBarData() != null) {
            return false;
        }
        return action.getPopupMenuData() == null;
    }

    private void displayHelpUrl(Object help, URL helpUrl) {
        if (helpUrl == null) {
            Msg.debug((Object)this, (Object)("Unable to find help for object: " + help));
        }
        helpUrl = this.validateUrl(helpUrl);
        if (this.hasBeenDisplayed && helpUrl.equals(this.mainHB.getCurrentURL())) {
            this.reloadPage(helpUrl);
            return;
        }
        this.mainHB.setCurrentURL(this.validateUrl(helpUrl));
    }

    private void reloadPage(URL helpURL) {
        if (!(this.mainHB instanceof GHelpBroker)) {
            return;
        }
        ((GHelpBroker)this.mainHB).reloadHelpPage(this.validateUrl(helpURL));
    }

    private URL getURLForID(Map.ID ID2) {
        Map map = this.mainHS.getCombinedMap();
        try {
            return map.getURLFromID(ID2);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private URL validateUrl(URL url) {
        if (url == null) {
            return HELP_NOT_FOUND_PAGE_URL;
        }
        try {
            InputStream inputStream = url.openStream();
            inputStream.close();
            return url;
        }
        catch (IOException iOException) {
            return HELP_NOT_FOUND_PAGE_URL;
        }
    }

    private boolean isValidHelp() {
        NavigatorView TOCView = this.mainHS.getNavigatorView(TABLE_OF_CONTENTS_VIEW_NAME);
        Hashtable parametersTable = TOCView.getParameters();
        String filename = (String)parametersTable.get(TABLE_OF_CONTENTS_FILENAME_KEY);
        ClassLoader loader = this.mainHS.getLoader();
        URL testResource = loader.getResource(filename);
        if (testResource == null) {
            return false;
        }
        return this.isURLValid(testResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isURLValid(URL url) {
        InputStream testStream = null;
        try {
            testStream = url.openStream();
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (testStream != null) {
                try {
                    testStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void mergePendingHelpSets() {
        for (HelpSet helpSet : this.helpSetsPendingMerge) {
            try {
                if (this.isExcludedHelpSet(helpSet)) continue;
                this.mainHS.add(helpSet);
            }
            catch (Exception e) {
                Msg.warn((Object)this, (Object)("Unable to load HelpSet: " + helpSet.getHelpSetURL().toExternalForm()), (Throwable)e);
            }
        }
        this.hasMergedHelpSets = true;
        this.helpSetsPendingMerge.clear();
    }

    boolean hasMergedHelpSets() {
        return this.hasMergedHelpSets;
    }

    private boolean isExcludedHelpSet(HelpSet helpSet) {
        if (this.mainHS.getHelpSetURL().equals(helpSet.getHelpSetURL())) {
            return true;
        }
        URL URL2 = helpSet.getHelpSetURL();
        String URLString = URL2.toString();
        return URLString.endsWith("Dummy_HelpSet.hs");
    }

    private HelpSet createHelpSet(URL url, GHelpClassLoader classLoader) throws HelpSetException {
        if (!this.urlToHelpSets.containsKey(url)) {
            GHelpSet hs = new GHelpSet(classLoader, url);
            this.urlToHelpSets.put(url, hs);
            return hs;
        }
        return null;
    }

    private void setColorResources() {
        UIManager.put("EditorPane.selectionBackground", new Color(204, 204, 255));
        UIManager.put("EditorPane.selectionForeground", UIManager.get("EditorPane.foreground"));
    }

    private void displayHelpInfo(Object helpObj, HelpLocation loc, Window parent) {
        String msg = this.getHelpInfo(helpObj, loc);
        Msg.showInfo((Object)this, (Component)parent, (String)"Help Info", (Object)msg);
    }

    private String getHelpInfo(Object helpObj, HelpLocation helpLoc) {
        if (helpObj == null) {
            return "Help Object is null";
        }
        boolean isHelpDescriptor = false;
        StringBuilder buffy = new StringBuilder();
        buffy.append("HELP OBJECT: " + helpObj.getClass().getName());
        buffy.append("\n");
        if (helpObj instanceof HelpDescriptor) {
            HelpDescriptor helpDescriptor = (HelpDescriptor)helpObj;
            buffy.append(helpDescriptor.getHelpInfo());
            isHelpDescriptor = true;
        } else if (helpObj instanceof JButton) {
            Container c;
            JButton button = (JButton)helpObj;
            buffy.append("   BUTTON: " + button.getText());
            buffy.append("\n");
            for (c = button; c != null && !(c instanceof Window); c = c.getParent()) {
            }
            if (c instanceof Dialog) {
                buffy.append("   DIALOG: " + ((Dialog)c).getTitle());
                buffy.append("\n");
            }
            if (c instanceof Frame) {
                buffy.append("   FRAME: " + ((Frame)c).getTitle());
                buffy.append("\n");
            }
        }
        buffy.append("\nHELP-LOCATION-> ");
        if (helpLoc != null) {
            String inception;
            String filename;
            buffy.append(helpLoc.toString());
            String str = helpLoc.getTopic();
            if (str != null) {
                buffy.append("\n   TOPIC:       ");
                buffy.append(str);
            }
            if ((filename = this.getFilenameForHelpLocation(helpLoc)) != null) {
                buffy.append("\n   FILENAME: ");
                buffy.append(filename);
            }
            if ((str = helpLoc.getAnchor()) != null) {
                buffy.append("\n   ANCHOR:   ");
                buffy.append(str);
            }
            if (!isHelpDescriptor && (inception = helpLoc.getInceptionInformation()) != null) {
                buffy.append("\n   \n");
                buffy.append("   CREATED AT: " + inception);
                buffy.append("\n   ");
            }
        } else {
            buffy.append("<NO HELP AVAILABLE>");
        }
        return buffy.toString();
    }
}

