/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DockableToolBarManager;
import docking.DockingUtils;
import docking.action.DockingActionIf;
import docking.util.AnimationUtils;
import docking.widgets.VariableHeightPanel;
import docking.widgets.label.GDLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class GenericHeader
extends JPanel {
    private static final Color NON_FOCUS_START_COLOR = new Color(150, 150, 150);
    private static final Color FOCUS_START_COLOR = new Color(30, 30, 150);
    private static final int MINIMUM_TITLE_SIZE = 80;
    private Color nonFocusColor = NON_FOCUS_START_COLOR;
    private Color focusColor = FOCUS_START_COLOR;
    protected Component component;
    protected DockableToolBarManager toolBarMgr;
    private VariableHeightPanel toolbar;
    private JComponent menuCloseToolbar;
    private int numLines = 0;
    protected TitlePanel titlePanel;
    private boolean useSingleLineLayoutOverride;
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            GenericHeader.this.setSelected(true);
            GenericHeader.this.requestFocus();
        }
    };

    public GenericHeader() {
        this(NON_FOCUS_START_COLOR, FOCUS_START_COLOR);
    }

    public GenericHeader(Color nonFocusColor, Color focusColor) {
        this.nonFocusColor = nonFocusColor;
        this.focusColor = focusColor;
        BorderLayout layout = new BorderLayout();
        layout.setVgap(1);
        this.setLayout(layout);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setFocusable(false);
        this.titlePanel = new TitlePanel();
        this.toolBarMgr = new DockableToolBarManager(this);
        this.resetComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GenericHeader.this.updateLayout();
            }
        });
    }

    public void dispose() {
        this.toolBarMgr.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() == 0) {
            return new Dimension(100, 20);
        }
        return super.getPreferredSize();
    }

    public void setNoWrapToolbar(boolean noWrap) {
        this.useSingleLineLayoutOverride = noWrap;
        this.updateLayout();
    }

    @Override
    public void requestFocus() {
        if (this.component == null) {
            return;
        }
        this.component.requestFocus();
    }

    private void installMouseListener(Component comp) {
        if (comp instanceof Container) {
            Component[] comps;
            Container c = (Container)comp;
            for (Component element : comps = c.getComponents()) {
                this.installMouseListener(element);
            }
        }
        comp.removeMouseListener(this.mouseListener);
        comp.addMouseListener(this.mouseListener);
    }

    protected void resetComponents() {
        if (this.toolBarMgr == null) {
            return;
        }
        this.toolbar = (VariableHeightPanel)this.toolBarMgr.getToolBar();
        this.menuCloseToolbar = this.toolBarMgr.getMenuCloseToolBar();
        this.numLines = 0;
    }

    public void update() {
        if (this.toolBarMgr == null) {
            return;
        }
        this.resetComponents();
        this.updateLayout();
        this.installMouseListener(this);
    }

    void updateLayout() {
        if (this.toolbar == null) {
            if (this.numLines != 1) {
                this.constructOneLinePanel();
            }
            return;
        }
        Dimension mySize = this.getSize();
        Dimension toolBarSize = this.toolbar.getPreferredLayoutSize();
        Dimension d = this.menuCloseToolbar.getPreferredSize();
        if (mySize.width == 0 || toolBarSize.width + d.width + 80 < mySize.width || this.useSingleLineLayoutOverride) {
            if (this.numLines != 1) {
                this.constructOneLinePanel();
            }
        } else if (this.numLines != 2) {
            this.constructMultiLinePanel();
        }
    }

    private void constructOneLinePanel() {
        this.removeAll();
        if (this.toolbar == null) {
            this.add((Component)this.menuCloseToolbar, "East");
        } else {
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            this.toolbar.setBorder(BorderFactory.createEmptyBorder());
            panel.add(this.toolbar);
            panel.add(this.menuCloseToolbar);
            this.add((Component)panel, "East");
            this.toolbar.setUseSingleLineLayout(true);
            this.toolbar.invalidate();
        }
        this.add((Component)this.titlePanel, "Center");
        this.numLines = 1;
        this.validateInvalidate();
    }

    protected void validateInvalidate() {
        this.toolbar.invalidate();
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        } else {
            this.validate();
        }
    }

    private void constructMultiLinePanel() {
        this.removeAll();
        this.toolbar.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
        this.add((Component)this.toolbar, "South");
        this.add((Component)this.titlePanel, "Center");
        this.add((Component)this.menuCloseToolbar, "East");
        this.numLines = 2;
        if (this.useSingleLineLayoutOverride) {
            this.toolbar.setUseSingleLineLayout(true);
        } else {
            this.toolbar.setUseSingleLineLayout(false);
        }
        this.validateInvalidate();
    }

    public void actionAdded(DockingActionIf action) {
        this.toolBarMgr.addAction(action);
    }

    public void actionRemoved(DockingActionIf action) {
        this.toolBarMgr.removeAction(action);
    }

    public DockingActionIf getAction(String name) {
        return this.toolBarMgr.getAction(name);
    }

    public int getToolBarWidth() {
        JComponent toolBarComponent = this.toolBarMgr.getToolBar();
        return toolBarComponent.getMinimumSize().width;
    }

    public void setSelected(boolean hasFocus) {
        this.titlePanel.setSelected(hasFocus);
    }

    protected Animator createEmphasizingAnimator() {
        if (!AnimationUtils.isAnimationEnabled()) {
            return null;
        }
        TitleFlasher titleFlasher = new TitleFlasher();
        return titleFlasher.animator;
    }

    public boolean isSelected() {
        return this.titlePanel.isSelected();
    }

    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
    }

    public void setIcon(Icon icon) {
        this.titlePanel.setIcon(icon);
    }

    public void setColor(Color color) {
        this.focusColor = color;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    protected class TitlePanel
    extends JPanel {
        private PopupMouseListener popupMouseListener;
        private JLabel titleLabel;
        private boolean isSelected;

        TitlePanel() {
            super(new BorderLayout());
            this.isSelected = false;
            this.setFocusable(false);
            this.titleLabel = new GDLabel();
            this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.titleLabel.setForeground(Color.BLACK);
            this.titleLabel.setFocusable(false);
            this.add((Component)this.titleLabel, "Center");
        }

        void installRenameAction(MouseListener listener) {
            if (this.popupMouseListener != null) {
                this.titleLabel.removeMouseListener(this.popupMouseListener);
            }
            this.popupMouseListener = new PopupMouseListener(listener);
            this.titleLabel.addMouseListener(this.popupMouseListener);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Rectangle r = this.getBounds();
            GradientPaint gp = this.isSelected ? new GradientPaint(r.x, r.y, GenericHeader.this.focusColor, r.x + r.width, r.y, this.getBackground()) : new GradientPaint(r.x, r.y, GenericHeader.this.nonFocusColor, r.x + r.width, r.y, this.getBackground());
            g2d.setPaint(gp);
            g2d.fill(r);
        }

        void setTitle(String s) {
            this.titleLabel.setText(s);
            this.titleLabel.setToolTipText(s);
        }

        void setIcon(Icon icon) {
            if ((icon = DockingUtils.scaleIconAsNeeded(icon)) != null) {
                this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            } else {
                this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            }
            this.titleLabel.setIcon(icon);
        }

        boolean isSelected() {
            return this.isSelected;
        }

        JComponent getDragComponent() {
            return this.titleLabel;
        }

        void setSelected(boolean state) {
            this.isSelected = state;
            this.titleLabel.setForeground(state ? Color.WHITE : Color.BLACK);
            this.repaint();
        }

        private class PopupMouseListener
        extends MouseAdapter {
            private MouseListener popupListenerDelegate;

            PopupMouseListener(MouseListener popupListenerDelegage) {
                this.popupListenerDelegate = popupListenerDelegage;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return;
                }
                this.popupListenerDelegate.mouseClicked(e);
            }
        }
    }

    public class TitleFlasher {
        Animator animator = PropertySetter.createAnimator((int)1000, (Object)this, (String)"color", (Object[])new Color[]{NON_FOCUS_START_COLOR, NON_FOCUS_START_COLOR, Color.YELLOW, FOCUS_START_COLOR});

        TitleFlasher() {
            this.animator.setAcceleration(0.2f);
            this.animator.setDeceleration(0.8f);
            this.animator.setRepeatBehavior(Animator.RepeatBehavior.REVERSE);
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    TitleFlasher.this.done();
                }
            });
            this.animator.start();
            GenericHeader.this.titlePanel.setSelected(true);
        }

        public void setColor(Color updatedColor) {
            GenericHeader.this.focusColor = updatedColor;
            GenericHeader.this.titlePanel.repaint();
        }

        private void done() {
            GenericHeader.this.focusColor = FOCUS_START_COLOR;
            GenericHeader.this.titlePanel.repaint();
        }
    }
}

