/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InjectContext {
    public SleighLanguage language;
    public Address baseAddr;
    public Address nextAddr;
    public Address callAddr;
    public Address refAddr;
    public ArrayList<Varnode> inputlist;
    public ArrayList<Varnode> output;

    public void restoreXml(SAXParser parser, String xml, AddressFactory addrFactory) throws PcodeXMLException {
        Handler handler = new Handler(addrFactory);
        try {
            parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new PcodeXMLException("Problem parsing inject context: " + e.getMessage());
        }
        catch (IOException e) {
            throw new PcodeXMLException("Problem parsing inject context: " + e.getMessage());
        }
    }

    private class Handler
    extends DefaultHandler {
        private AddressFactory addrFactory;
        private Address curaddr;
        private int state = 0;

        Handler(AddressFactory adFact) {
            this.addrFactory = adFact;
        }

        @Override
        public void startElement(String uri, String localName, String rawName, Attributes attr) throws SAXException {
            if (rawName.equals("context")) {
                this.state = 1;
            } else if (rawName.equals("input")) {
                InjectContext.this.inputlist = new ArrayList();
                this.state = 3;
            } else if (rawName.equals("output")) {
                InjectContext.this.output = new ArrayList();
                this.state = 4;
            } else if (rawName.equals("addr")) {
                this.curaddr = AddressXML.readXML(rawName, attr, this.addrFactory);
                if (this.state == 1) {
                    InjectContext.this.baseAddr = this.curaddr;
                    this.state = 2;
                } else if (this.state == 2) {
                    InjectContext.this.callAddr = this.curaddr;
                } else if (this.state == 3) {
                    int size = SpecXmlUtils.decodeInt((String)attr.getValue("size"));
                    Varnode vn = new Varnode(this.curaddr, size);
                    InjectContext.this.inputlist.add(vn);
                } else if (this.state == 4) {
                    int size = SpecXmlUtils.decodeInt((String)attr.getValue("size"));
                    Varnode vn = new Varnode(this.curaddr, size);
                    InjectContext.this.output.add(vn);
                }
            } else {
                throw new SAXException("Unrecognized inject tag: " + rawName);
            }
        }
    }
}

