/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class RelocationDBAdapterV3
extends RelocationDBAdapter {
    static final int VERSION = 3;
    private Table relocTable;
    private AddressMap addrMap;

    RelocationDBAdapterV3(DBHandle handle, AddressMap addrMap, boolean create) throws IOException, VersionException {
        this.addrMap = addrMap;
        if (create) {
            this.relocTable = handle.createTable("Relocations", SCHEMA);
        } else {
            this.relocTable = handle.getTable("Relocations");
            if (this.relocTable == null) {
                throw new VersionException("Missing Table: Relocations");
            }
            if (this.relocTable.getSchema().getVersion() != 3) {
                int version = this.relocTable.getSchema().getVersion();
                if (version < 3) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    void add(long addrKey, int type, long[] values, byte[] bytes, String symbolName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord get(long addrKey) throws IOException {
        return this.relocTable.getRecord(addrKey);
    }

    @Override
    void remove(long addrKey) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.relocTable.getRecordCount();
    }

    @Override
    int getVersion() {
        return 3;
    }

    @Override
    RecordIterator iterator() throws IOException {
        return new AddressKeyRecordIterator(this.relocTable, this.addrMap);
    }

    @Override
    RecordIterator iterator(AddressSetView set) throws IOException {
        return new AddressKeyRecordIterator(this.relocTable, this.addrMap, set, set.getMinAddress(), true);
    }

    @Override
    RecordIterator iterator(Address start) throws IOException {
        return new AddressKeyRecordIterator(this.relocTable, this.addrMap, start, true);
    }

    @Override
    DBRecord adaptRecord(DBRecord rec) {
        DBRecord newRec = SCHEMA.createRecord(rec.getKey());
        newRec.setIntValue(0, rec.getIntValue(0));
        long[] values = new long[]{rec.getLongValue(1)};
        newRec.setField(1, (Field)new BinaryCodedField(values));
        newRec.setBinaryData(2, null);
        newRec.setString(3, null);
        return newRec;
    }
}

