/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBitfieldMsType;
import ghidra.app.util.pdb.pdbapplicator.EnumTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class BitfieldTypeApplier
extends MsTypeApplier {
    private MsTypeApplier elementTypeApplier = null;

    public BitfieldTypeApplier(PdbApplicator applicator, AbstractBitfieldMsType msType) {
        super(applicator, msType);
    }

    @Override
    BigInteger getSize() {
        if (this.elementTypeApplier == null) {
            return BigInteger.ZERO;
        }
        return this.elementTypeApplier.getSize();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.dataType = this.applyBitfieldMsType((AbstractBitfieldMsType)this.msType);
    }

    private DataType applyBitfieldMsType(AbstractBitfieldMsType type) {
        this.elementTypeApplier = this.applicator.getTypeApplier(type.getElementRecordNumber());
        if (this.elementTypeApplier instanceof ModifierTypeApplier) {
            this.elementTypeApplier = ((ModifierTypeApplier)this.elementTypeApplier).getModifiedTypeApplier();
        }
        if (!(this.elementTypeApplier instanceof PrimitiveTypeApplier) && !(this.elementTypeApplier instanceof EnumTypeApplier)) {
            this.applicator.appendLogMsg("Unable to process underlying type for Bitfield: " + type.getName());
            return null;
        }
        DataType baseDataType = this.elementTypeApplier.getDataType();
        Pdb2BitField bitFieldDataType = null;
        try {
            bitFieldDataType = new Pdb2BitField(baseDataType.clone(this.applicator.getDataTypeManager()), type.getBitLength(), type.getBitPosition());
        }
        catch (InvalidDataTypeException e) {
            this.applicator.appendLogMsg("Problem creating PdbBitField for " + type.getName() + ", error: " + e.toString());
            return null;
        }
        return bitFieldDataType;
    }

    @Override
    void resolve() {
    }

    private class Pdb2BitField
    extends PdbBitField {
        private Pdb2BitField(DataType baseDataType, int bitSize, int bitOffsetWithinBaseType) throws InvalidDataTypeException {
            super(baseDataType, bitSize, bitOffsetWithinBaseType);
        }
    }
}

