/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import java.util.Objects;

public abstract class AbstractMethodRecordMs
extends AbstractParsableItem {
    protected AbstractPdb pdb;
    protected ClassFieldMsAttributes attributes;
    protected RecordNumber procedureRecordNumber;
    protected long optionalOffset;

    public AbstractMethodRecordMs(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append("<");
        builder.append(this.attributes);
        builder.append(": ");
        builder.append(this.pdb.getTypeRecord(this.procedureRecordNumber));
        if (this.attributes.getProperty() == ClassFieldMsAttributes.Property.INTRO) {
            builder.append(",");
            builder.append(this.optionalOffset);
        }
        builder.append(">");
    }
}

