/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class ProcedureFlags
extends AbstractParsableItem {
    private int flagByte;
    private boolean framePointerPresent;
    private boolean interruptReturn;
    private boolean farReturn;
    private boolean doesNotReturn;
    private boolean labelNotReached;
    private boolean customCallingConvention;
    private boolean markedAsNoInline;
    private boolean hasDebugInformationForOptimizedCode;

    public ProcedureFlags(PdbByteReader reader) throws PdbException {
        this.flagByte = reader.parseUnsignedByteVal();
        this.processFlags(this.flagByte);
    }

    @Override
    public void emit(StringBuilder builder) {
        DelimiterState ds = new DelimiterState("", ", ");
        builder.append("Flags: ");
        builder.append(ds.out(this.framePointerPresent, "Frame Ptr Present"));
        builder.append(ds.out(this.interruptReturn, "Interrupt"));
        builder.append(ds.out(this.farReturn, "FAR"));
        builder.append(ds.out(this.doesNotReturn, "Never Return"));
        builder.append(ds.out(this.labelNotReached, "Not Reached"));
        builder.append(ds.out(this.customCallingConvention, "Custom Calling Convention"));
        builder.append(ds.out(this.markedAsNoInline, "Do Not Inline"));
        builder.append(ds.out(this.hasDebugInformationForOptimizedCode, "Optimized Debug Info"));
    }

    private void processFlags(int val) {
        this.framePointerPresent = (val & 1) == 1;
        this.interruptReturn = ((val >>= 1) & 1) == 1;
        this.farReturn = ((val >>= 1) & 1) == 1;
        this.doesNotReturn = ((val >>= 1) & 1) == 1;
        this.labelNotReached = ((val >>= 1) & 1) == 1;
        this.customCallingConvention = ((val >>= 1) & 1) == 1;
        this.markedAsNoInline = ((val >>= 1) & 1) == 1;
        this.hasDebugInformationForOptimizedCode = ((val >>= 1) & 1) == 1;
    }
}

