/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import java.io.IOException;
import java.io.RandomAccessFile;

class MsfFileReader
implements AutoCloseable {
    private RandomAccessFile file;
    private AbstractMsf msf;

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    MsfFileReader(AbstractMsf msf, RandomAccessFile file) {
        this.msf = msf;
        this.file = file;
    }

    void readPage(int page, byte[] bytes) throws IOException {
        this.read(page, 0, this.msf.getPageSize(), bytes, 0);
    }

    void read(int page, int offset, int numToRead, byte[] bytes, int bytesOffset) throws IOException {
        if (numToRead < 1) {
            throw new IOException("Must request at least one byte in MSF read");
        }
        if (offset < 0 || offset >= this.msf.getPageSize()) {
            throw new IOException(String.format("Offset must be in range [0, %d) in for MSF read", this.msf.getPageSize()));
        }
        long fileOffset = (long)offset + (long)page * (long)this.msf.getPageSize();
        if (AbstractMsf.floorDivisionWithLog2Divisor(offset + numToRead, this.msf.getLog2PageSize()) > this.msf.getNumPages()) {
            throw new IOException("Invalid MSF configuration");
        }
        int numBytesRead = 0;
        this.file.seek(fileOffset);
        numBytesRead = this.file.read(bytes, bytesOffset, numToRead);
        if (numBytesRead != numToRead) {
            throw new IOException("Could not read required bytes from MSF");
        }
    }
}

