/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbNewDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbOldDebugInfo;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class PdbDebugInfoParser {
    private static final int DATABASE_INTERFACE_STREAM_NUMBER = 3;
    public static final int DBIHDR700_SIG = -1;
    public static final int DBI41_ID = 930803;
    public static final int DBI50_ID = 19960307;
    public static final int DBI60_ID = 19970606;
    public static final int DBI70_ID = 19990903;
    public static final int DBI110_ID = 20091201;
    private PdbByteReader debugReader;

    public PdbDebugInfo parse(AbstractPdb pdb) throws IOException, PdbException {
        PdbDebugInfo debugInfo;
        block7: {
            try {
                int streamNumber = this.getStreamNumber();
                PdbByteReader reader = pdb.getReaderForStreamNumber(streamNumber, 0, 8, TaskMonitor.DUMMY);
                if (reader.getLimit() == 0) {
                    return null;
                }
                this.debugReader = reader;
                PdbLog.message(this::debugDump);
                int headerSignature = reader.parseInt();
                int versionNumber = reader.parseInt();
                if (headerSignature == -1) {
                    switch (versionNumber) {
                        case 930803: 
                        case 19960307: 
                        case 19970606: 
                        case 19990903: 
                        case 20091201: {
                            debugInfo = new PdbNewDebugInfo(pdb, streamNumber);
                            break block7;
                        }
                        default: {
                            throw new PdbException("Unknown DBI Version");
                        }
                    }
                }
                debugInfo = new PdbOldDebugInfo(pdb, streamNumber);
            }
            catch (CancelledException e) {
                throw new AssertException();
            }
        }
        return debugInfo;
    }

    private String debugDump() {
        return "DebugInfoParser data on stream " + this.getStreamNumber() + ":\n" + this.debugReader.dump() + "\n";
    }

    protected int getStreamNumber() {
        return 3;
    }
}

