/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.FramePointerOmissionRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageFileMachine;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageFunctionEntry;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageSectionHeader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbNewDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.RvaVaDebugHeader;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class DebugData {
    private AbstractPdb pdb;
    private List<Integer> debugStreams = new ArrayList<Integer>();
    private List<FramePointerOmissionRecord> framePointerOmissionData;
    private SortedMap<Long, Long> omapFromSource;
    private List<ImageSectionHeader> imageSectionHeaders;
    private List<ImageSectionHeader> imageSectionHeadersOrig;
    private List<ImageFunctionEntry> pData;
    private RvaVaDebugHeader xDataHeader;
    private PdbByteReader xDataReader;

    public DebugData(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public List<FramePointerOmissionRecord> getFramePointerOmissionData() {
        return this.framePointerOmissionData;
    }

    public SortedMap<Long, Long> getOmapFromSource() {
        return this.omapFromSource;
    }

    public List<ImageSectionHeader> getImageSectionHeaders() {
        return this.imageSectionHeaders;
    }

    public List<ImageSectionHeader> getImageSectionHeadersOrig() {
        return this.imageSectionHeadersOrig;
    }

    public void deserializeHeader(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
        while (reader.hasMore()) {
            monitor.checkCanceled();
            int debugStreamNumber = reader.parseUnsignedShortVal();
            this.debugStreams.add(debugStreamNumber);
        }
        if (this.debugStreams.size() != DebugType.values().length) {
            // empty if block
        }
    }

    public void deserialize(TaskMonitor monitor) throws PdbException, CancelledException, IOException {
        if (this.debugStreams.isEmpty()) {
            throw new PdbException("DebugData Header had not been deserialized at the appropriate time");
        }
        block13: for (DebugType dbg : DebugType.values()) {
            int streamNum = this.debugStreams.get(dbg.getValue());
            if (streamNum == 65535) continue;
            switch (dbg) {
                case FRAME_POINTER_OMISSION: {
                    this.deserializeFramePointerOmissionData(streamNum, monitor);
                    continue block13;
                }
                case EXCEPTION: {
                    continue block13;
                }
                case FIXUP: {
                    continue block13;
                }
                case OMAP_TO_SOURCE: {
                    continue block13;
                }
                case OMAP_FROM_SOURCE: {
                    this.omapFromSource = this.deserializeOMap(streamNum, monitor);
                    continue block13;
                }
                case SECTION_HEADER: {
                    this.imageSectionHeaders = this.deserializeSectionHeaders(streamNum, monitor);
                    continue block13;
                }
                case TOKEN_RID_MAP: {
                    continue block13;
                }
                case X_DATA: {
                    this.deserializeXData(streamNum, monitor);
                    continue block13;
                }
                case P_DATA: {
                    this.deserializePData(streamNum, monitor);
                    continue block13;
                }
                case NEW_FRAME_POINTER_OMISSION: {
                    continue block13;
                }
                case SECTION_HEADER_ORIG: {
                    this.imageSectionHeadersOrig = this.deserializeSectionHeaders(streamNum, monitor);
                }
            }
        }
    }

    private void deserializeFramePointerOmissionData(int streamNum, TaskMonitor monitor) throws PdbException, CancelledException, IOException {
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum, monitor);
        this.framePointerOmissionData = new ArrayList<FramePointerOmissionRecord>();
        while (reader.hasMore()) {
            monitor.checkCanceled();
            FramePointerOmissionRecord framePointerOmissionRecord = new FramePointerOmissionRecord();
            framePointerOmissionRecord.parse(reader);
            this.framePointerOmissionData.add(framePointerOmissionRecord);
        }
    }

    private SortedMap<Long, Long> deserializeOMap(int streamNum, TaskMonitor monitor) throws PdbException, CancelledException, IOException {
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum, monitor);
        TreeMap<Long, Long> omap = new TreeMap<Long, Long>();
        while (reader.hasMore()) {
            monitor.checkCanceled();
            long v1 = reader.parseUnsignedIntVal();
            long v2 = reader.parseUnsignedIntVal();
            omap.put(v1, v2);
        }
        return omap;
    }

    private List<ImageSectionHeader> deserializeSectionHeaders(int streamNum, TaskMonitor monitor) throws PdbException, CancelledException, IOException {
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum, monitor);
        ArrayList<ImageSectionHeader> sectionHeaders = new ArrayList<ImageSectionHeader>();
        while (reader.hasMore()) {
            monitor.checkCanceled();
            ImageSectionHeader imageSectionHeader = new ImageSectionHeader(this.pdb);
            imageSectionHeader.parse(reader);
            sectionHeaders.add(imageSectionHeader);
        }
        return sectionHeaders;
    }

    private void deserializeXData(int streamNum, TaskMonitor monitor) throws PdbException, CancelledException, IOException {
        long dataLength;
        RvaVaDebugHeader header;
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum, monitor);
        int streamLength = reader.getLimit();
        this.xDataHeader = header = new RvaVaDebugHeader();
        header.deserialize(reader);
        if (header.getHeaderVersion() != 1L) {
            return;
        }
        long headerLength = header.getHeaderLength();
        if (headerLength + (dataLength = header.getDataLength()) > (long)streamLength) {
            throw new PdbException("Problem parsing Debug XData");
        }
        reader.setIndex((int)headerLength);
        this.xDataReader = reader.getSubPdbByteReader(reader.numRemaining());
    }

    private void deserializePData(int streamNum, TaskMonitor monitor) throws PdbException, CancelledException, IOException {
        long dataLength;
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum, monitor);
        this.pData = new ArrayList<ImageFunctionEntry>();
        int streamLength = reader.getLimit();
        RvaVaDebugHeader header = new RvaVaDebugHeader();
        header.deserialize(reader);
        if (header.getHeaderVersion() != 1L) {
            return;
        }
        long headerLength = header.getHeaderLength();
        if (headerLength + (dataLength = header.getDataLength()) > (long)streamLength) {
            throw new PdbException("Problem parsing Debug PData");
        }
        reader.setIndex((int)headerLength);
        if (this.pdb.getDebugInfo() instanceof PdbNewDebugInfo) {
            PdbNewDebugInfo dbi = (PdbNewDebugInfo)this.pdb.getDebugInfo();
            ImageFileMachine machine = dbi.getMachineType();
            switch (machine) {
                case IA64: {
                    break;
                }
                case AMD64: {
                    break;
                }
            }
        }
    }

    void dump(Writer writer) throws IOException {
        writer.write("DebugData---------------------------------------------------\n");
        this.dumpDebugStreamList(writer);
        writer.write("FramePointerOmissionData------------------------------------\n");
        if (this.framePointerOmissionData != null) {
            for (FramePointerOmissionRecord framePointerOmissionRecord : this.framePointerOmissionData) {
                framePointerOmissionRecord.dump(writer);
            }
        }
        writer.write("End FramePointerOmissionData--------------------------------\n");
        writer.write("OmapFromSource----------------------------------------------\n");
        if (this.omapFromSource != null) {
            int num = 0;
            for (Map.Entry<Long, Long> entry : this.omapFromSource.entrySet()) {
                writer.write(String.format("0X%08X: 0X%012X,  0X%012X\n", num++, entry.getKey(), entry.getValue()));
            }
        }
        writer.write("End OmapFromSource------------------------------------------\n");
        writer.write("ImageSectionHeaders-----------------------------------------\n");
        if (this.imageSectionHeaders != null) {
            int sectionNum = 0;
            for (ImageSectionHeader imageSectionHeader : this.imageSectionHeaders) {
                imageSectionHeader.dump(writer, sectionNum++);
            }
        }
        writer.write("End ImageSectionHeaders-------------------------------------\n");
        writer.write("ImageSectionHeadersOrig-------------------------------------\n");
        if (this.imageSectionHeadersOrig != null) {
            int sectionNum = 0;
            for (ImageSectionHeader imageSectionHeader : this.imageSectionHeadersOrig) {
                imageSectionHeader.dump(writer, sectionNum++);
            }
        }
        writer.write("End ImageSectionHeadersOrig---------------------------------\n");
        writer.write("PData-------------------------------------------------------\n");
        if (this.pData != null) {
            for (ImageFunctionEntry imageFunctionEntry : this.pData) {
                writer.append(imageFunctionEntry.toString());
            }
        }
        writer.write("End PData---------------------------------------------------\n");
        writer.write("End DebugData-----------------------------------------------\n");
    }

    private void dumpDebugStreamList(Writer writer) throws IOException {
        writer.write("StreamList--------------------------------------------------\n");
        int i = 0;
        for (int strmNumber : this.debugStreams) {
            writer.write(String.format("StrmNumber[%02d]: %04x\n", i++, strmNumber));
        }
        writer.write("End StreamList----------------------------------------------\n");
    }

    public static enum DebugType {
        FRAME_POINTER_OMISSION(0),
        EXCEPTION(1),
        FIXUP(2),
        OMAP_TO_SOURCE(3),
        OMAP_FROM_SOURCE(4),
        SECTION_HEADER(5),
        TOKEN_RID_MAP(6),
        X_DATA(7),
        P_DATA(8),
        NEW_FRAME_POINTER_OMISSION(9),
        SECTION_HEADER_ORIG(10);

        private final int value;

        private DebugType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

