/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.PdbAnalyzerCommon;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class PdbUniversalAnalyzer
extends AbstractAnalyzer {
    private static final boolean developerMode = false;
    static final String NAME = "PDB Universal";
    static final boolean DEFAULT_ENABLEMENT = true;
    private static final String DESCRIPTION = "Platform-independent PDB analyzer (No XML support).\nNOTE: still undergoing development, so options may change.\nPDB Symbol Server searching is configured in Edit -> Symbol Server Config.\n";
    private static final String OPTION_NAME_DO_FORCELOAD = "Do Force-Load";
    private static final String OPTION_DESCRIPTION_DO_FORCELOAD = "If checked, uses the 'Force Load' file without validation.";
    private boolean doForceLoad = false;
    private static final String OPTION_NAME_FORCELOAD_FILE = "Force-Load FilePath";
    private static final String OPTION_DESCRIPTION_FORCELOAD_FILE = "This file is force-loaded if the 'Do Force-Load' option is checked";
    private static final File DEFAULT_SYMBOLS_DIR = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? new File("C:\\Symbols") : new File(new File(System.getProperty("user.home")), "Symbols");
    private File DEFAULT_FORCE_LOAD_FILE = new File(DEFAULT_SYMBOLS_DIR, "sample.pdb");
    private File forceLoadFile;
    private boolean searchRemoteLocations = false;
    private PdbReaderOptions pdbReaderOptions;
    private PdbApplicatorOptions pdbApplicatorOptions;
    private long lastTransactionId = -1L;

    public PdbUniversalAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
        this.pdbReaderOptions = new PdbReaderOptions();
        this.pdbApplicatorOptions = new PdbApplicatorOptions();
    }

    static boolean isEnabled(Program program) {
        Options analysisOptions = program.getOptions("Analyzers");
        return analysisOptions.getBoolean(NAME, true);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        long txId = program.getCurrentTransaction().getID();
        if (txId == this.lastTransactionId) {
            return false;
        }
        this.lastTransactionId = txId;
        if (!set.contains((AddressSetView)program.getMemory())) {
            return false;
        }
        PdbProgramAttributes programAttributes = new PdbProgramAttributes(program);
        if (programAttributes.isPdbLoaded()) {
            Msg.info((Object)((Object)this), (Object)"Skipping PDB analysis since it has previously run.");
            Msg.info((Object)((Object)this), (Object)">> Clear 'PDB Loaded' program property or use Load PDB action if additional PDB processing required.");
            return true;
        }
        File pdbFile = null;
        if (this.doForceLoad && this.forceLoadFile != null) {
            if (!this.forceLoadFile.isFile()) {
                this.logFailure("Force-load PDB file does not exist: " + this.forceLoadFile, log);
                return false;
            }
            pdbFile = this.forceLoadFile;
        } else {
            pdbFile = PdbAnalyzerCommon.findPdb((Analyzer)this, program, this.searchRemoteLocations, monitor);
        }
        if (pdbFile == null) {
            return false;
        }
        PdbLog.message("================================================================================");
        PdbLog.message(new Date(System.currentTimeMillis()).toString() + "\n");
        PdbLog.message("Ghidra Version: " + Application.getApplicationVersion());
        PdbLog.message(NAME);
        PdbLog.message(DESCRIPTION);
        PdbLog.message("PDB Filename: " + pdbFile + "\n");
        try (AbstractPdb pdb = PdbParser.parse(pdbFile.getPath(), this.pdbReaderOptions, monitor);){
            monitor.setMessage("PDB: Parsing " + pdbFile + "...");
            pdb.deserialize(monitor);
            PdbApplicator applicator = new PdbApplicator(pdbFile.getPath(), pdb);
            applicator.applyTo(program, (DataTypeManager)program.getDataTypeManager(), program.getImageBase(), this.pdbApplicatorOptions, monitor, log);
        }
        catch (PdbException | IOException e) {
            log.appendMsg(this.getName(), "Issue processing PDB file:  " + pdbFile + ":\n   " + e.toString());
            return false;
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        return PdbAnalyzerCommon.canAnalyzeProgram(program);
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption("Search remote symbol servers", (Object)this.searchRemoteLocations, null, "If checked, allow searching remote symbol servers for PDB files.");
        this.pdbReaderOptions.registerOptions(options);
        this.pdbApplicatorOptions.registerAnalyzerOptions(options);
        this.pdbReaderOptions.loadOptions(options);
        this.pdbApplicatorOptions.loadAnalyzerOptions(options);
    }

    public void optionsChanged(Options options, Program program) {
        this.searchRemoteLocations = options.getBoolean("Search remote symbol servers", this.searchRemoteLocations);
        this.pdbReaderOptions.loadOptions(options);
        this.pdbApplicatorOptions.loadAnalyzerOptions(options);
    }

    private void logFailure(String msg, MessageLog log) {
        log.appendMsg(this.getName(), msg);
        log.appendMsg(this.getName(), "Skipping PDB processing");
        log.setStatus(msg);
    }

    public static void setPdbFileOption(Program program, File pdbFile) {
        PdbAnalyzerCommon.setPdbFileOption(NAME, program, pdbFile);
    }

    public static void setAllowRemoteOption(Program program, boolean allowRemote) {
        PdbAnalyzerCommon.setAllowRemoteOption(NAME, program, allowRemote);
    }
}

