/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.widgets.checkbox.GCheckBox;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.api.main.VTProgramCorrelatorAddressRestrictionPreference;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;

public class AddressSetOptionsPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private JCheckBox excludeCheckbox;
    private JCheckBox showAddressSetPanelsCheckbox;

    public AddressSetOptionsPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(40, 40, 0, 0));
        this.excludeCheckbox = new GCheckBox("Exclude accepted matches", false);
        String excludeAcceptedTooltip = "This option will cause the correlator algorithm to <b>not</b> consider any functions or data that have already been accepted. Using this option can greatly speed up the processing time of the correlator algorithm; however, this options should only be used when you trust that your accepted matches are correct.";
        this.excludeCheckbox.setToolTipText(HTMLUtilities.toWrappedHTML((String)excludeAcceptedTooltip));
        this.showAddressSetPanelsCheckbox = new GCheckBox("Limit source and destination address sets");
        String manuallyLimitTooltip = "Selecting this checkbox will trigger additional wizard  panels allowing you to customize the address sets used  by the selected algorithm.  When not selected, the entire address space is used.";
        this.showAddressSetPanelsCheckbox.setToolTipText(HTMLUtilities.toWrappedHTML((String)manuallyLimitTooltip));
        this.add(this.excludeCheckbox);
        this.add(this.showAddressSetPanelsCheckbox);
        this.setLayout((LayoutManager)new VerticalLayout(20));
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
    }

    public void dispose() {
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        List list = (List)state.get((Object)VTWizardStateKey.PROGRAM_CORRELATOR_FACTORY_LIST);
        Boolean value = (Boolean)state.get((Object)VTWizardStateKey.EXCLUDE_ACCEPTED_MATCHES);
        if (value != null) {
            this.excludeCheckbox.setSelected(value);
        }
        if ((value = (Boolean)state.get((Object)VTWizardStateKey.SHOW_ADDRESS_SET_PANELS)) != null) {
            this.showAddressSetPanelsCheckbox.setSelected(value);
        } else {
            AddressSetView sourceSelection = (AddressSetView)state.get((Object)VTWizardStateKey.SOURCE_SELECTION);
            AddressSetView destinationSelection = (AddressSetView)state.get((Object)VTWizardStateKey.DESTINATION_SELECTION);
            boolean somethingSelected = sourceSelection != null && !sourceSelection.isEmpty() || destinationSelection != null && !destinationSelection.isEmpty();
            this.showAddressSetPanelsCheckbox.setSelected(somethingSelected);
        }
        if (this.allowRestrictions(list)) {
            this.excludeCheckbox.setEnabled(true);
        } else {
            this.excludeCheckbox.setSelected(false);
            this.excludeCheckbox.setEnabled(false);
        }
    }

    private boolean allowRestrictions(List<VTProgramCorrelatorFactory> list) {
        for (VTProgramCorrelatorFactory factory : list) {
            if (factory.getAddressRestrictionPreference() == VTProgramCorrelatorAddressRestrictionPreference.RESTRICTION_NOT_ALLOWED) continue;
            return true;
        }
        return false;
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        return WizardPanelDisplayability.CAN_BE_DISPLAYED;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        state.put((Object)VTWizardStateKey.EXCLUDE_ACCEPTED_MATCHES, (Object)this.excludeCheckbox.isSelected());
        state.put((Object)VTWizardStateKey.SHOW_ADDRESS_SET_PANELS, (Object)this.showAddressSetPanelsCheckbox.isSelected());
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "Address_Set_Panel");
    }

    public String getTitle() {
        return "Address Set Options";
    }

    public void initialize() {
    }

    public boolean isValidInformation() {
        return true;
    }
}

