/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable.deprecated;

import ghidra.feature.vt.api.stringable.deprecated.LocalVariableStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MultipleLocalVariableStringable
extends Stringable {
    public static final String SHORT_NAME = "MULTI_LOCAL";
    private static final String CUSTOM_DELIMITER = "\n";
    private List<Stringable> localVariableStringables = new ArrayList<Stringable>();

    public MultipleLocalVariableStringable() {
        this((List<LocalVariableStringable>)null);
    }

    public MultipleLocalVariableStringable(List<LocalVariableStringable> localVariableStringables) {
        super(SHORT_NAME);
        this.localVariableStringables = localVariableStringables == null ? new ArrayList<Stringable>() : new ArrayList<LocalVariableStringable>(localVariableStringables);
    }

    @Override
    protected String doConvertToString(Program program) {
        StringBuffer buffy = new StringBuffer();
        for (Stringable stringable : this.localVariableStringables) {
            buffy.append(Stringable.getString(stringable, program)).append(CUSTOM_DELIMITER);
        }
        return buffy.toString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        if (string == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(string, CUSTOM_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Stringable stringable = Stringable.getStringable(token, program);
            this.localVariableStringables.add(stringable);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * (this.localVariableStringables == null ? 0 : this.localVariableStringables.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipleLocalVariableStringable other = (MultipleLocalVariableStringable)obj;
        return !(this.localVariableStringables == null ? other.localVariableStringables != null : !this.localVariableStringables.equals(other.localVariableStringables));
    }

    @Override
    public String getDisplayString() {
        StringBuffer buffy = new StringBuffer();
        for (Stringable stringable : this.localVariableStringables) {
            buffy.append(stringable.getDisplayString()).append('\n');
        }
        return buffy.toString();
    }
}

