/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.attributes.Attribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StringAttribute<T extends KeyedObject>
extends Attribute<T> {
    private Map<Long, String> values = new HashMap<Long, String>();
    private static String attributeType = "STRING_TYPE";

    public StringAttribute(String name, KeyIndexableSet<T> set) {
        super(name, set);
    }

    public boolean setValue(T o, String value) {
        if (value == null) {
            return false;
        }
        if (this.owningSet().contains(o)) {
            this.values.put(o.key(), value);
            this.update();
            return true;
        }
        return false;
    }

    public String getValue(KeyedObject o) {
        return this.values.get(o.key());
    }

    public KeyedObject[] toSortedArray() {
        KeyedObject[] keyedObjects = this.owningSet().toArray();
        Arrays.sort(keyedObjects, new StringComparator());
        return keyedObjects;
    }

    public KeyedObject[] toSortedArray(KeyedObject[] keyedObjects) {
        KeyedObject[] clone = (KeyedObject[])keyedObjects.clone();
        Arrays.sort(clone, new StringComparator());
        return clone;
    }

    @Override
    public String attributeType() {
        return attributeType;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public String getValueAsString(KeyedObject o) {
        return this.getValue(o);
    }

    class StringComparator
    implements Comparator<KeyedObject> {
        StringComparator() {
        }

        @Override
        public int compare(KeyedObject object1, KeyedObject object2) {
            KeyedObject ko1 = object1;
            KeyedObject ko2 = object2;
            int returnValue = 0;
            String value1 = null;
            String value2 = null;
            value1 = StringAttribute.this.getValue(ko1);
            value2 = StringAttribute.this.getValue(ko2);
            if (value1 != null) {
                if (value2 != null) {
                    returnValue = value1.compareTo(value2);
                    if (returnValue != 0) {
                        return returnValue;
                    }
                    if (ko1.key() - ko2.key() < 0L) {
                        return -1;
                    }
                    if (ko1.key() - ko2.key() > 0L) {
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            if (value2 != null) {
                return 1;
            }
            if (ko1.key() - ko2.key() < 0L) {
                return -1;
            }
            if (ko1.key() - ko2.key() > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

