/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import ghidra.util.Conv;

public class UnsignedDataUtils {
    private static final int LESS_THAN = 0;
    private static final int LESS_THAN_OR_EQUAL = 1;
    private static final int GREATER_THAN = 2;
    private static final int GREATER_THAN_OR_EQUAL = 3;

    private UnsignedDataUtils() {
    }

    public static void main(String[] args) {
        System.out.println(false);
        System.out.println(UnsignedDataUtils.unsignedLessThan((byte)5, (byte)-6));
        System.out.println(false);
        System.out.println(UnsignedDataUtils.unsignedLessThan(5, -2023406815));
    }

    private static boolean comp(int type, byte i, byte j) {
        return UnsignedDataUtils.comp(type, Conv.byteToLong(i), Conv.byteToLong(j));
    }

    private static boolean comp(int type, short i, short j) {
        return UnsignedDataUtils.comp(type, Conv.shortToLong(i), Conv.shortToLong(j));
    }

    private static boolean comp(int type, int i, int j) {
        return UnsignedDataUtils.comp(type, Conv.intToLong(i), Conv.intToLong(j));
    }

    private static boolean comp(int type, long i, long j) {
        boolean isHiBitSetJ;
        boolean isHiBitSetI = i < 0L;
        boolean bl = isHiBitSetJ = j < 0L;
        if (isHiBitSetI == isHiBitSetJ) {
            switch (type) {
                case 0: {
                    return i < j;
                }
                case 1: {
                    return i <= j;
                }
                case 2: {
                    return i > j;
                }
                case 3: {
                    return i >= j;
                }
            }
        } else if (isHiBitSetI) {
            switch (type) {
                case 0: 
                case 1: {
                    return false;
                }
                case 2: 
                case 3: {
                    return true;
                }
            }
        } else {
            switch (type) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: 
                case 3: {
                    return false;
                }
            }
        }
        throw new RuntimeException("BAD COMP TYPE!");
    }

    public static boolean unsignedLessThan(byte i, byte j) {
        return UnsignedDataUtils.comp(0, i, j);
    }

    public static boolean unsignedLessThanOrEqual(byte i, byte j) {
        return UnsignedDataUtils.comp(1, i, j);
    }

    public static boolean unsignedGreaterThan(byte i, byte j) {
        return UnsignedDataUtils.comp(2, i, j);
    }

    public static boolean unsignedGreaterThanOrEqual(byte i, byte j) {
        return UnsignedDataUtils.comp(3, i, j);
    }

    public static boolean unsignedLessThan(short i, short j) {
        return UnsignedDataUtils.comp(0, i, j);
    }

    public static boolean unsignedLessThanOrEqual(short i, short j) {
        return UnsignedDataUtils.comp(1, i, j);
    }

    public static boolean unsignedGreaterThan(short i, short j) {
        return UnsignedDataUtils.comp(2, i, j);
    }

    public static boolean unsignedGreaterThanOrEqual(short i, short j) {
        return UnsignedDataUtils.comp(3, i, j);
    }

    public static boolean unsignedLessThan(int i, int j) {
        return UnsignedDataUtils.comp(0, i, j);
    }

    public static boolean unsignedLessThanOrEqual(int i, int j) {
        return UnsignedDataUtils.comp(1, i, j);
    }

    public static boolean unsignedGreaterThan(int i, int j) {
        return UnsignedDataUtils.comp(2, i, j);
    }

    public static boolean unsignedGreaterThanOrEqual(int i, int j) {
        return UnsignedDataUtils.comp(3, i, j);
    }

    public static boolean unsignedLessThan(long i, long j) {
        return UnsignedDataUtils.comp(0, i, j);
    }

    public static boolean unsignedLessThanOrEqual(long i, long j) {
        return UnsignedDataUtils.comp(1, i, j);
    }

    public static boolean unsignedGreaterThan(long i, long j) {
        return UnsignedDataUtils.comp(2, i, j);
    }

    public static boolean unsignedGreaterThanOrEqual(long i, long j) {
        return UnsignedDataUtils.comp(3, i, j);
    }
}

