/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.jar.ResourceFile;
import generic.test.AbstractGTest;
import generic.test.ConcurrentTestExceptionHandler;
import generic.test.ConcurrentTestExceptionStatement;
import generic.test.TestReportingException;
import generic.test.TestThread;
import generic.test.TestUtils;
import generic.util.WindowUtilities;
import ghidra.GhidraTestApplicationLayout;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.TaskUtilities;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.AbstractSwingUpdateManager;
import ghidra.util.task.SwingUpdateManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import sun.awt.AppContext;
import utilities.util.FileUtilities;
import utilities.util.reflection.ReflectionUtilities;
import utility.application.ApplicationLayout;
import utility.function.ExceptionalCallback;

public abstract class AbstractGenericTest
extends AbstractGTest {
    private static final String GHIDRA_TEST_PROPERTY_REPORT_DIR = "ghidra.test.property.report.dir";
    private static File debugDirectory;
    public static final String TESTDATA_DIRECTORY_NAME = "testdata";
    public static final String DEFAULT_TOOL_NAME = "CodeBrowser";
    public static final String DEFAULT_TEST_TOOL_NAME = "TestCodeBrowser";
    private static boolean initialized;
    private static boolean printedApplicationConflictWaring;
    private static ApplicationLayout loadedApplicationLayout;
    private static ApplicationConfiguration loadedApplicationConfiguration;
    private volatile boolean hasFailed;
    public TestWatcher watchman = new TestWatcher(){

        protected void starting(Description description) {
            AbstractGenericTest.this.hasFailed = false;
            AbstractGenericTest.this.debugBatch(new Date() + "\n***** STARTING Test: " + AbstractGenericTest.this.getClass().getSimpleName() + " - " + AbstractGenericTest.this.testName.getMethodName() + " *****");
        }

        protected void failed(Throwable e, Description description) {
            AbstractGenericTest.this.hasFailed = true;
            AbstractGenericTest.this.testFailed(e);
            AbstractGenericTest.this.debugBatch("\t\u2716 FAILED Test: " + AbstractGenericTest.this.getClass().getSimpleName() + " - " + AbstractGenericTest.this.testName.getMethodName() + " \u2716\t");
        }

        protected void succeeded(Description description) {
            AbstractGenericTest.this.debugBatch("\t\u2713 PASSED Test: " + AbstractGenericTest.this.getClass().getSimpleName() + " - " + AbstractGenericTest.this.testName.getMethodName() + " \u2713\t");
        }
    };
    @Rule
    public TestRule concurrentTestExceptionRule = (base, description) -> new ConcurrentTestExceptionStatement(base);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testName).around((TestRule)this.watchman);

    private void debugBatch(String message) {
        if (BATCH_MODE) {
            Msg.debug(AbstractGenericTest.class, (Object)message);
        }
    }

    private synchronized void initialize(AbstractGenericTest test) {
        this.initializeSystemProperties();
        ApplicationLayout layout = test.createApplicationLayout();
        this.initializeLayout(layout);
        ApplicationConfiguration configuration = test.createApplicationConfiguration();
        if (initialized) {
            this.printWarningIfConflictingInitializationConfigs(layout, configuration);
            return;
        }
        if (configuration == null) {
            return;
        }
        initialized = true;
        loadedApplicationLayout = layout;
        loadedApplicationConfiguration = configuration;
        Application.initializeApplication(layout, configuration);
    }

    protected void initializeSystemProperties() {
        System.setProperty("SystemUtilities.isTesting", "true");
    }

    protected void initializeLayout(ApplicationLayout layout) {
        File testDir = new File(AbstractGenericTest.getTestDirectoryPath());
        AbstractGenericTest.setInstanceField("userCacheDir", layout, testDir);
    }

    private void printWarningIfConflictingInitializationConfigs(ApplicationLayout layout, ApplicationConfiguration configuration) {
        if (loadedApplicationLayout.getClass().equals(layout.getClass()) && loadedApplicationConfiguration.getClass().equals(configuration.getClass())) {
            return;
        }
        if (printedApplicationConflictWaring) {
            return;
        }
        printedApplicationConflictWaring = true;
        Msg.error((Object)this, (Object)("\n\n\n\n\t\t\tWARNING!!\n\nAttempted to run multiple tests with different configurations.\nThis prevents the proper initialization of tests\nLoaded configurations, in order: " + loadedApplicationConfiguration.getClass().getSimpleName() + " and " + configuration.getClass().getSimpleName() + "\n"), (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
    }

    public AbstractGenericTest() {
        this.initialize(this);
    }

    protected ApplicationLayout createApplicationLayout() {
        try {
            return new GhidraTestApplicationLayout(new File(AbstractGenericTest.getTestDirectoryPath()));
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }

    protected ApplicationConfiguration createApplicationConfiguration() {
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return configuration;
    }

    protected boolean hasTestFailed() {
        return this.hasFailed;
    }

    protected void testFailed(Throwable e) {
    }

    public static Window windowForComponent(Component c) {
        return WindowUtilities.windowForComponent(c);
    }

    public static Set<Window> getAllWindows() {
        Window[] windows;
        HashSet<Window> set = new HashSet<Window>();
        Frame sharedOwnerFrame = (Frame)AppContext.getAppContext().get(new StringBuffer("SwingUtilities.sharedOwnerFrame"));
        if (sharedOwnerFrame != null) {
            set.addAll(AbstractGenericTest.getAllWindows(sharedOwnerFrame));
        }
        for (Frame frame : Frame.getFrames()) {
            set.addAll(AbstractGenericTest.getAllWindows(frame));
        }
        for (Window window : windows = Window.getWindows()) {
            set.add(window);
        }
        return set;
    }

    private static List<Window> getAllWindows(Window parent) {
        ArrayList<Window> list = new ArrayList<Window>();
        list.add(parent);
        for (Window w : parent.getOwnedWindows()) {
            list.add(w);
        }
        return list;
    }

    public File getLocalResourceFile(String relativePath) {
        URL resource = this.getClass().getResource(relativePath);
        try {
            URI uri = resource.toURI();
            return new File(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> loadTextResource(Class<?> cls, String name) throws IOException {
        InputStream is = cls.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Could not find resource: " + name);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> text = AbstractGenericTest.readText(br);
        br.close();
        return text;
    }

    private static ArrayList<String> readText(BufferedReader br) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String line = "";
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            list.add(line);
        }
        return list;
    }

    public static ArrayList<String> loadTextResource(String name) throws IOException {
        File file = AbstractGenericTest.getTestDataFile(name);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> text = AbstractGenericTest.readText(reader);
        reader.close();
        return text;
    }

    public static File getTestDataFile(String path) throws FileNotFoundException {
        ResourceFile resourceFile = Application.getModuleDataFile("TestResources", path);
        return resourceFile.getFile(false);
    }

    public static File getTestDataDir(String relativePath) throws FileNotFoundException, IOException {
        ResourceFile resourceFile = Application.getModuleDataSubDirectory("TestResources", relativePath);
        return resourceFile.getFile(false);
    }

    public static File findTestDataFile(String path) {
        try {
            ResourceFile resourceFile = Application.getModuleDataFile("TestResources", path);
            return resourceFile.getFile(false);
        }
        catch (FileNotFoundException e) {
            Msg.warn(AbstractGenericTest.class, (Object)("Test data file not found: " + path));
            return null;
        }
    }

    public static File getTestDataDirectory() {
        try {
            return Application.getModuleSubDirectory("TestResources", "data").getFile(false);
        }
        catch (IOException e) {
            throw new AssertException("Unable to find test resources directory 'data' directory");
        }
    }

    public static void printMemory() {
        AbstractGenericTest.yieldToSwing();
        System.gc();
        AbstractGenericTest.yieldToSwing();
        System.gc();
        AbstractGenericTest.yieldToSwing();
        System.gc();
        Runtime runTime = Runtime.getRuntime();
        System.out.println("----------------------");
        System.out.printf("Max:   %,10dK\n", runTime.maxMemory() / 1000L);
        System.out.printf("Total: %,10dK\n", runTime.totalMemory() / 1000L);
        System.out.printf("Free:  %,10dK\n", runTime.freeMemory() / 1000L);
        System.out.printf("Used:  %,10dK\n", (runTime.totalMemory() - runTime.freeMemory()) / 1000L);
    }

    public static void waitForTasks() {
        AbstractGenericTest.doWaitForTasks(PRIVATE_LONG_WAIT_TIMEOUT);
    }

    private static void doWaitForTasks(long timeout) {
        AbstractGenericTest.waitForSwing();
        long time = 0L;
        while (TaskUtilities.isExecutingTasks()) {
            if ((time += AbstractGenericTest.sleep(DEFAULT_WAIT_DELAY)) < timeout) continue;
            Msg.error(AbstractGenericTest.class, (Object)AbstractGenericTest.createStackTraceForAllThreads());
            throw new AssertionFailedError("Time expired waiting for tasks to complete.");
        }
        AbstractGenericTest.waitForSwing();
    }

    public static void waitForPostedSwingRunnables() {
        AbstractGenericTest.waitForSwing();
    }

    public static <T extends Component> T findComponent(Container parent, Class<T> desiredClass) {
        return AbstractGenericTest.findComponent(parent, desiredClass, false);
    }

    public static <T extends Component> T findComponent(Container parent, Class<T> desiredClass, boolean checkOwnedWindows) {
        Component[] comps;
        for (Component element : comps = parent.getComponents()) {
            T c;
            if (element == null) continue;
            if (desiredClass.isAssignableFrom(element.getClass())) {
                return (T)((Component)desiredClass.cast(element));
            }
            if (!(element instanceof Container) || (c = AbstractGenericTest.findComponent((Container)element, desiredClass, checkOwnedWindows)) == null) continue;
            return (T)((Component)desiredClass.cast(c));
        }
        if (checkOwnedWindows && parent instanceof Window) {
            Window[] windows = ((Window)parent).getOwnedWindows();
            for (int i = windows.length - 1; i >= 0; --i) {
                T c = AbstractGenericTest.findComponent(windows[i], desiredClass, checkOwnedWindows);
                if (c == null) continue;
                return (T)((Component)desiredClass.cast(c));
            }
        }
        return null;
    }

    public static <T> T getInstanceFieldByClassType(Class<T> classType, Object ownerInstance) {
        return TestUtils.getInstanceFieldByClassType(classType, ownerInstance);
    }

    public static void setInstanceField(String fieldName, Object ownerInstance, Object value) throws RuntimeException {
        TestUtils.setInstanceField(fieldName, ownerInstance, value);
    }

    public static Object getInstanceField(String fieldName, Object ownerInstance) throws RuntimeException {
        return TestUtils.getInstanceField(fieldName, ownerInstance);
    }

    public static Object invokeConstructor(Class<?> containingClass, Class<?>[] parameterTypes, Object[] args) throws RuntimeException {
        return TestUtils.invokeConstructor(containingClass, parameterTypes, args);
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance, Class<?>[] parameterTypes, Object[] args) throws RuntimeException {
        return TestUtils.invokeInstanceMethod(methodName, ownerInstance, parameterTypes, args);
    }

    public static Object invokeInstanceMethod(String methodName, Object ownerInstance) throws RuntimeException {
        return AbstractGenericTest.invokeInstanceMethod(methodName, ownerInstance, null, null);
    }

    public static void findOwnedWindows(Window win, Set<Window> winList) {
        Window[] children;
        for (Window element : children = win.getOwnedWindows()) {
            winList.add(element);
            AbstractGenericTest.findOwnedWindows(element, winList);
        }
    }

    public static void pressButtonByText(Container container, String buttonText) {
        AbstractGenericTest.pressButtonByText(container, buttonText, true);
    }

    public static void pressButtonByText(Container container, String buttonText, boolean waitForCompletion) {
        AbstractButton button = AbstractGenericTest.findAbstractButtonByText(container, buttonText);
        if (button == null) {
            throw new AssertionError((Object)("Couldn't find button " + buttonText + "."));
        }
        if (!AbstractGenericTest.runSwing(() -> button.isShowing()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonText + " is not showing."));
        }
        if (!AbstractGenericTest.runSwing(() -> button.isEnabled()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonText + " is not enabled."));
        }
        AbstractGenericTest.pressButton(button, waitForCompletion);
    }

    public static void pressButtonByName(Container container, String buttonName) {
        AbstractGenericTest.pressButtonByName(container, buttonName, true);
    }

    public static void pressButtonByName(Container container, String buttonName, boolean waitForCompletion) {
        AbstractButton button = (AbstractButton)AbstractGenericTest.findComponentByName(container, buttonName);
        if (button == null) {
            throw new AssertionError((Object)("Couldn't find button " + buttonName + "."));
        }
        if (!AbstractGenericTest.runSwing(() -> button.isShowing()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonName + " is not showing."));
        }
        if (!AbstractGenericTest.runSwing(() -> button.isEnabled()).booleanValue()) {
            throw new AssertionError((Object)("Button " + buttonName + " is not enabled."));
        }
        AbstractGenericTest.pressButton(button, waitForCompletion);
    }

    public static void pressButton(AbstractButton button) {
        if (!button.isEnabled()) {
            throw new AssertException("Attempted to press a disabled button");
        }
        AbstractGenericTest.pressButton(button, true);
    }

    public static void pressButton(AbstractButton button, boolean waitForCompletion) {
        Runnable r = () -> button.doClick(0);
        AbstractGenericTest.runSwing(r, waitForCompletion);
    }

    public static Component findComponentByName(Container container, String componentName) {
        return AbstractGenericTest.findComponentByName(container, componentName, false);
    }

    public static Component findComponentByName(Container container, String componentName, boolean checkOwnedWindows) {
        Component[] comps;
        String containerName = container.getName();
        if (containerName != null && container.getName().equals(componentName)) {
            return container;
        }
        for (Component element : comps = container.getComponents()) {
            Component comp;
            if (element == null) continue;
            String name = element.getName();
            if (name != null && name.equals(componentName)) {
                return element;
            }
            if (!(element instanceof Container) || (comp = AbstractGenericTest.findComponentByName((Container)element, componentName, checkOwnedWindows)) == null) continue;
            return comp;
        }
        if (checkOwnedWindows && container instanceof Window) {
            Window[] windows = ((Window)container).getOwnedWindows();
            for (int i = windows.length - 1; i >= 0; --i) {
                Component c = AbstractGenericTest.findComponentByName(windows[i], componentName, checkOwnedWindows);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public static List<Component> findComponentsByName(Container container, String componentName, boolean checkOwnedWindows) {
        Component[] components;
        ArrayList<Component> retList = new ArrayList<Component>();
        for (Component component : components = container.getComponents()) {
            if (component == null) continue;
            String name = component.getName();
            if (name != null && name.equals(componentName)) {
                retList.add(component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            retList.addAll(AbstractGenericTest.findComponentsByName((Container)component, componentName, checkOwnedWindows));
        }
        return retList;
    }

    public static JButton findButtonByIcon(Container container, Icon icon) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            JButton button;
            Icon buttonIcon;
            if (!(element instanceof JButton ? icon.equals(buttonIcon = (button = (JButton)element).getIcon()) : element instanceof Container && (button = AbstractGenericTest.findButtonByIcon((Container)element, icon)) != null)) continue;
            return button;
        }
        return null;
    }

    public static JButton findButtonByText(Container container, String text) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            JButton button;
            if (!(element instanceof JButton ? (button = (JButton)element).getText() != null && button.getText().equals(text) : element instanceof Container && (button = AbstractGenericTest.findButtonByText((Container)element, text)) != null)) continue;
            return button;
        }
        return null;
    }

    public static AbstractButton findAbstractButtonByText(Container container, String text) {
        Component[] comp;
        for (Component element : comp = container.getComponents()) {
            AbstractButton b;
            if (element instanceof AbstractButton && text.equals(((AbstractButton)element).getText())) {
                return (AbstractButton)element;
            }
            if (!(element instanceof Container) || (b = AbstractGenericTest.findAbstractButtonByText((Container)element, text)) == null) continue;
            return b;
        }
        return null;
    }

    public static AbstractButton findAbstractButtonByName(Container container, String name) {
        Component[] comp;
        for (Component element : comp = container.getComponents()) {
            AbstractButton b;
            if (element instanceof AbstractButton && name.equals(((AbstractButton)element).getName())) {
                return (AbstractButton)element;
            }
            if (!(element instanceof Container) || (b = AbstractGenericTest.findAbstractButtonByName((Container)element, name)) == null) continue;
            return b;
        }
        return null;
    }

    public static void leftClick(JComponent comp, int x, int y) {
        AbstractGenericTest.clickMouse(comp, 1, x, y, 1, 0);
    }

    public static void middleClick(JComponent comp, int x, int y) {
        AbstractGenericTest.clickMouse(comp, 2, x, y, 1, 0);
    }

    public static void rightClick(JComponent comp, int x, int y) {
        AbstractGenericTest.clickMouse(comp, 3, x, y, 1, 0, true);
    }

    public static void doubleClick(JComponent comp, int x, int y) {
        AbstractGenericTest.clickMouse(comp, 1, x, y, 2, 0);
    }

    public static void clickMouse(Component comp, int button, int x, int y, int clickCount, int modifiers, boolean popupTrigger) {
        int updatedModifiers = AbstractGenericTest.convertToExtendedModifiers(modifiers, button);
        for (int cnt = 1; cnt <= clickCount; ++cnt) {
            AbstractGenericTest.postEvent(new MouseEvent(comp, 501, System.currentTimeMillis(), updatedModifiers, x, y, cnt, false, button));
            AbstractGenericTest.postEvent(new MouseEvent(comp, 500, System.currentTimeMillis(), updatedModifiers, x, y, cnt, false, button));
            AbstractGenericTest.postEvent(new MouseEvent(comp, 502, System.currentTimeMillis(), updatedModifiers, x, y, cnt, popupTrigger, button));
        }
    }

    public static void clickMouse(Component comp, int button, int x, int y, int clickCount, int modifiers) {
        AbstractGenericTest.clickMouse(comp, button, x, y, clickCount, modifiers, false);
    }

    public static void dragMouse(Component comp, int button, int startX, int startY, int endX, int endY, int modifiers) {
        int updateModifiers = AbstractGenericTest.convertToExtendedModifiers(modifiers, button);
        AbstractGenericTest.postEvent(new MouseEvent(comp, 501, System.currentTimeMillis(), updateModifiers, startX, startY, 1, false, button));
        AbstractGenericTest.postEvent(new MouseEvent(comp, 506, System.currentTimeMillis(), updateModifiers, endX, endY, 1, false, button));
        AbstractGenericTest.postEvent(new MouseEvent(comp, 502, System.currentTimeMillis(), updateModifiers, endX, endY, 1, false, button));
    }

    public static void moveMouse(Component comp, int x, int y) {
        AbstractGenericTest.postEvent(new MouseEvent(comp, 503, System.currentTimeMillis(), 0, x, y, 0, false));
    }

    private static int convertToExtendedModifiers(int modifiers, int button) {
        int controlMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        if ((modifiers & 0x80) == 128) {
            modifiers ^= 0x80;
            modifiers |= controlMask;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= controlMask;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= controlMask;
        }
        if ((modifiers & 1) == 1) {
            modifiers ^= 1;
            modifiers |= 0x40;
        }
        if ((modifiers & 8) == 8) {
            modifiers ^= 8;
            modifiers |= 0x200;
        }
        if ((modifiers & 4) == 4) {
            modifiers ^= 4;
            modifiers |= 0x100;
        }
        switch (button) {
            case 1: {
                modifiers |= 0x400;
                break;
            }
            case 2: {
                modifiers |= 0x800;
                break;
            }
            case 3: {
                modifiers |= 0x1000;
            }
        }
        return modifiers;
    }

    public static void postEvent(AWTEvent ev) {
        AbstractGenericTest.runSwing(() -> {
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(ev);
        });
        AbstractGenericTest.waitForSwing();
    }

    public static <T> T runSwing(Supplier<T> s) {
        AtomicReference ref = new AtomicReference();
        AbstractGenericTest.runSwing(() -> ref.set(s.get()));
        return (T)ref.get();
    }

    public static void runSwing(Runnable r) {
        AbstractGenericTest.runSwing(r, true);
    }

    public void runSwingLater(Runnable r) {
        AbstractGenericTest.runSwing(r, false);
    }

    public static <E extends Exception> void runSwingWithException(ExceptionalCallback<E> callback) throws Exception {
        if (Swing.isSwingThread()) {
            throw new AssertException("Unexpectedly called from the Swing thread");
        }
        ExceptionHandlingRunner exceptionHandlingRunner = new ExceptionHandlingRunner(callback);
        Throwable throwable = exceptionHandlingRunner.getException();
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw new AssertException(throwable);
    }

    public static void runSwing(Runnable runnable, boolean wait) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        if (wait) {
            AbstractGenericTest.runSwingAndWait(runnable);
            return;
        }
        Runnable swingExceptionCatcher = () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                ConcurrentTestExceptionHandler.handle(Thread.currentThread(), t);
            }
        };
        SwingUtilities.invokeLater(swingExceptionCatcher);
    }

    private static void runSwingAndWait(Runnable runnable) {
        ExceptionHandlingRunner exceptionHandlingRunner = new ExceptionHandlingRunner(runnable);
        Throwable throwable = exceptionHandlingRunner.getException();
        if (throwable == null) {
            return;
        }
        if (!TestThread.isTestThread()) {
            ConcurrentTestExceptionHandler.handle(Thread.currentThread(), throwable);
            return;
        }
        String message = "Exception in Swing thread via runSwingAndWait():";
        if (!BATCH_MODE) {
            TestReportingException exception = TestReportingException.fromSwingThread(message, throwable);
            throw exception;
        }
        String string = TestReportingException.getSwingThreadTraceString(throwable);
        Assert.fail((String)(message + "\n" + string + "\nTest Thread stack at that time:"));
    }

    public static void executeOnSwingWithoutBlocking(final Runnable runnable) {
        final AtomicBoolean didRun = new AtomicBoolean();
        new Thread(){

            @Override
            public void run() {
                didRun.set(true);
                AbstractGenericTest.runSwing(runnable);
            }
        }.start();
        AbstractGenericTest.waitForSwing();
        AbstractGenericTest.waitForCondition(() -> didRun.get());
        AbstractGenericTest.sleep(DEFAULT_WAIT_DELAY);
        AbstractGenericTest.waitForSwing();
    }

    public static void clickTableCell(JTable table, int row, int col, int clickCount) {
        AbstractGenericTest.runSwing(() -> table.setRowSelectionInterval(row, row));
        AbstractGenericTest.waitForSwing();
        Rectangle rect = table.getCellRect(row, col, true);
        AbstractGenericTest.clickMouse(table, 1, rect.x + 10, rect.y + 10, clickCount, 0);
        AbstractGenericTest.waitForSwing();
    }

    public static void clickListRange(JList<?> list, int row, int count) {
        AbstractGenericTest.waitForSwing();
        for (int i = row; i < row + count; ++i) {
            Rectangle rect = list.getCellBounds(i, i);
            AbstractGenericTest.clickMouse(list, 1, rect.x + 10, rect.y + 10, 1, 64);
        }
        AbstractGenericTest.waitForSwing();
    }

    public static void clickTableRange(JTable table, int row, int count) {
        AbstractGenericTest.waitForSwing();
        for (int i = row; i < row + count; ++i) {
            Rectangle rect = table.getCellRect(i, 0, true);
            AbstractGenericTest.clickMouse(table, 1, rect.x + 10, rect.y + 10, 1, 64);
        }
        AbstractGenericTest.waitForSwing();
    }

    public static TableCellEditor editCell(JTable table, int row, int col) {
        AbstractGenericTest.waitForSwing();
        AbstractGenericTest.runSwing(() -> table.setRowSelectionInterval(row, row));
        AbstractGenericTest.runSwing(() -> table.editCellAt(row, col));
        AbstractGenericTest.waitForSwing();
        TableCellEditor editor = table.getCellEditor(row, col);
        Assert.assertNotNull((String)("Unable to edit table cell at " + row + ", " + col), (Object)editor);
        return editor;
    }

    public static String getRenderedTableCellValue(JTable table, int row, int column) {
        return AbstractGenericTest.runSwing(() -> {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            if (renderer == null) {
                throw new IllegalArgumentException("No renderer registered for row/col: " + row + "/" + column);
            }
            Component component = table.prepareRenderer(renderer, row, column);
            if (!(component instanceof JLabel)) {
                throw new IllegalArgumentException("Do not know how to get text from a renderer that is not a JLabel");
            }
            return ((JLabel)component).getText();
        });
    }

    public static <T> void setComboBoxSelection(JComboBox<T> comboField, T selection) {
        AbstractGenericTest.runSwing(() -> comboField.setSelectedItem(selection));
        AbstractGenericTest.waitForSwing();
    }

    public static void setText(JTextComponent field, String text) {
        AbstractGenericTest.runSwing(() -> field.setText(text));
        AbstractGenericTest.waitForSwing();
    }

    public static String getText(JTextComponent field) {
        return AbstractGenericTest.runSwing(() -> field.getText());
    }

    public static TreePath findTreePathToText(JTree tree, String text) {
        TreeModel tm = tree.getModel();
        TreeNode rootNode = (TreeNode)tm.getRoot();
        TreePath rootPath = new TreePath(rootNode);
        return AbstractGenericTest.findPathToText(tree, rootPath, text);
    }

    protected static TreePath findPathToText(JTree tree, TreePath startTreePath, String text) {
        if (text.equals(startTreePath.getLastPathComponent().toString())) {
            return startTreePath;
        }
        tree.expandPath(startTreePath);
        int len = startTreePath.getPathCount();
        Object[] tpObjects = new Object[len + 1];
        System.arraycopy(startTreePath.getPath(), 0, tpObjects, 0, len);
        TreeNode treeNode = (TreeNode)startTreePath.getLastPathComponent();
        int num = treeNode.getChildCount();
        for (int i = 0; i < num; ++i) {
            TreeNode childNode = treeNode.getChildAt(i);
            tpObjects[len] = childNode;
            TreePath childPath = new TreePath(tpObjects);
            TreePath treePath = AbstractGenericTest.findPathToText(tree, childPath, text);
            if (treePath == null) continue;
            return treePath;
        }
        return null;
    }

    public static String createStackTraceForAllThreads() {
        return TestUtils.createStackTraceForAllThreads();
    }

    public static String toString(Collection<?> collection) {
        StringBuffer buffer = new StringBuffer();
        TypeVariable<Class<?>>[] typeParameters = collection.getClass().getTypeParameters();
        buffer.append("Collection<");
        for (TypeVariable<Class<?>> typeVariable : typeParameters) {
            buffer.append(typeVariable.getName()).append(", ");
        }
        if (typeParameters.length > 0) {
            int length = buffer.length();
            buffer.delete(length - 2, length);
        }
        buffer.append(">: ");
        for (Object object : collection) {
            buffer.append(object).append(", ");
        }
        return buffer.toString();
    }

    public static void fixupGUI() throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        });
        Font f = new Font("Monospaced", 0, 12);
        UIManager.put("PasswordField.font", f);
        UIManager.put("TextArea.font", f);
    }

    public static FontMetrics getFontMetrics(Font font) {
        BufferedImage image = new BufferedImage(1, 1, 3);
        Graphics g = image.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        g.dispose();
        return fm;
    }

    public static void setErrorsExpected(boolean expected) {
        if (expected) {
            Msg.error(AbstractGenericTest.class, (Object)">>>>>>>>>>>>>>>> Expected Exception");
            ConcurrentTestExceptionHandler.disable();
        } else {
            Msg.error(AbstractGenericTest.class, (Object)"<<<<<<<<<<<<<<<< End Expected Exception");
            ConcurrentTestExceptionHandler.enable();
        }
    }

    public static boolean waitForSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Can't wait for swing from within the swing thread!");
        }
        HashSet<AbstractSwingUpdateManager> set = new HashSet<AbstractSwingUpdateManager>();
        AbstractGenericTest.runSwing(() -> {
            WeakSet s = (WeakSet)AbstractGenericTest.getInstanceField("instances", SwingUpdateManager.class);
            for (AbstractSwingUpdateManager manager : s) {
                set.add(manager);
            }
        });
        boolean wasEverBusy = AbstractGenericTest.waitForSwing(set, true);
        return wasEverBusy;
    }

    private static boolean waitForSwing(Set<AbstractSwingUpdateManager> managers, boolean flush) {
        int MAX_SWING_TIMEOUT = 15000;
        int totalTime = 0;
        AbstractGenericTest.flushAllManagers(managers, flush);
        boolean wasEverBusy = false;
        boolean keepGoing = true;
        while (keepGoing) {
            AbstractGenericTest.yieldToSwing();
            keepGoing = false;
            for (AbstractSwingUpdateManager manager : managers) {
                if (!manager.isBusy()) continue;
                AbstractGenericTest.doFlush(flush, manager);
                boolean isBusy = true;
                while (isBusy) {
                    keepGoing = true;
                    wasEverBusy = true;
                    if ((totalTime = (int)((long)totalTime + AbstractGenericTest.sleep(DEFAULT_WAIT_DELAY))) >= MAX_SWING_TIMEOUT) {
                        Msg.debug(AbstractGenericTest.class, (Object)("Timed-out waitinig for Swing after " + totalTime + " ms.  The currently waited SwingUpdateManager:\n" + manager.toStringDebug()));
                        return true;
                    }
                    isBusy = manager.isBusy();
                }
            }
            AbstractGenericTest.yieldToSwing();
        }
        return wasEverBusy;
    }

    private static void flushAllManagers(Set<AbstractSwingUpdateManager> managers, boolean flush) {
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (AbstractSwingUpdateManager manager : managers) {
                AbstractGenericTest.doFlush(flush, manager);
            }
        }
    }

    private static void doFlush(boolean doFlush, AbstractSwingUpdateManager manager) {
        if (!doFlush) {
            return;
        }
        AbstractGenericTest.runSwing(() -> manager.flush(), false);
        AbstractGenericTest.yieldToSwing();
    }

    @Deprecated
    public static void privateWaitForPostedSwingRunnables_SwingSafe() {
        AbstractGenericTest.yieldToSwing();
    }

    protected static void yieldToSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            Msg.error(AbstractGenericTest.class, (Object)"Incorrectly called yieldToSwing() from the Swing thread");
            return;
        }
        Runnable empty = () -> {};
        for (int i = 0; i < 3; ++i) {
            try {
                SwingUtilities.invokeAndWait(empty);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static File getDebugFileDirectory() {
        if (debugDirectory != null) {
            return debugDirectory;
        }
        String dirPath = System.getProperty(GHIDRA_TEST_PROPERTY_REPORT_DIR);
        if (dirPath != null) {
            debugDirectory = new File(dirPath);
        } else {
            ResourceFile moduleDir = Application.getMyModuleRootDirectory();
            ResourceFile binDir = new ResourceFile(moduleDir, "bin");
            debugDirectory = binDir.getFile(false);
        }
        return debugDirectory;
    }

    public static File createTempDirectory(String name) throws IOException {
        String tempTestRootDirname = "generic.test.temp.dir";
        AbstractGenericTest.deleteSimilarTempFiles(tempTestRootDirname);
        String testTempDir = AbstractGenericTest.getTestDirectoryPath();
        Path tempDirPath = Paths.get(testTempDir, new String[0]);
        Path tempRootDirPath = Files.createTempDirectory(tempDirPath, tempTestRootDirname, new FileAttribute[0]);
        File tempRootDir = tempRootDirPath.toFile();
        tempRootDir.deleteOnExit();
        FileUtilities.deleteDir((File)tempRootDir);
        Path userDir = tempRootDirPath.resolve(name);
        Files.createDirectories(userDir, new FileAttribute[0]);
        File file = userDir.toFile();
        file.deleteOnExit();
        return file;
    }

    public String createTempFilePath(String name) throws IOException {
        String path = this.createTempFilePath(name, ".tmp");
        return path;
    }

    public String createTempFilePath(String name, String extension) throws IOException {
        File file = this.createTempFile(name, extension);
        file.delete();
        return file.getAbsolutePath();
    }

    public File createTempFileForTest() throws IOException {
        return this.createTempFile(this.getName());
    }

    public File createTempFileForTest(String suffix) throws IOException {
        return this.createTempFile(this.getName(), suffix);
    }

    public File createTempFile(String name) throws IOException {
        File file = this.createTempFile(name, ".tmp");
        return file;
    }

    public File createTempFile(String name, String suffix) throws IOException {
        String testMethodName = this.testName.getMethodName();
        String prefixName = name != null ? name : "null";
        String suffixName = suffix != null ? suffix : ".tmp";
        AbstractGenericTest.deleteMatchingTempFiles(prefixName + ".*" + suffixName);
        String testTempDir = AbstractGenericTest.getTestDirectoryPath();
        File dir = new File(testTempDir);
        String filename = prefixName + "." + testMethodName + ".";
        File tempFile = File.createTempFile(filename, suffixName, dir);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void deleteSimilarTempFiles(String nameText) {
        String literalNamePattern = Pattern.quote(nameText);
        String contains = ".*" + literalNamePattern + ".*";
        AbstractGenericTest.deleteMatchingTempFiles(contains);
    }

    public static void deleteMatchingTempFiles(String namePattern) {
        File[] oldFiles;
        Pattern pattern = Pattern.compile(namePattern);
        String tempPath = AbstractGenericTest.getTestDirectoryPath();
        File testTempDir = new File(tempPath);
        for (File file : oldFiles = testTempDir.listFiles((dir, filename) -> {
            boolean matches = pattern.matcher(filename).matches();
            return matches;
        })) {
            FileUtilities.deleteDir((File)file);
        }
    }

    static {
        initialized = false;
        printedApplicationConflictWaring = false;
    }

    protected static class ExceptionHandlingRunner {
        private final ExceptionalCallback<? extends Exception> delegateCallback;
        private Throwable exception;

        ExceptionHandlingRunner(Runnable delegateRunnable) {
            this.delegateCallback = () -> delegateRunnable.run();
            this.run();
        }

        ExceptionHandlingRunner(ExceptionalCallback<? extends Exception> delegateCallback) {
            this.delegateCallback = delegateCallback;
            this.run();
        }

        Throwable getException() {
            return this.exception;
        }

        String getExceptionMessage() {
            Throwable throwable = this.getException();
            String message = throwable.getMessage();
            if (message != null) {
                return message;
            }
            return this.getCauseExceptionMessage(throwable);
        }

        protected String getCauseExceptionMessage(Throwable t) {
            if (t == null) {
                return "<No Exception Message>";
            }
            if (t instanceof AssertionError) {
                return t.getMessage();
            }
            String message = t.getMessage();
            if (message != null) {
                return message;
            }
            return this.getCauseExceptionMessage(t.getCause());
        }

        private void run() {
            Runnable swingExceptionCatcher = () -> {
                try {
                    this.delegateCallback.call();
                }
                catch (Throwable t) {
                    this.exception = t;
                }
            };
            try {
                this.doRun(swingExceptionCatcher);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }

        private void doRun(Runnable runnable) throws InvocationTargetException, InterruptedException {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
    }
}

