/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import com.google.common.collect.ImmutableMap;
import ghidra.util.ObjectStorage;
import ghidra.util.Saveable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

@Deprecated
public abstract class AnnotatedSaveable
implements Saveable {
    protected static ImmutableMap.Builder<Class<?>, FieldAccessorFactory> accessorFactoriesBuilder = ImmutableMap.builder();
    protected static Map<Class<?>, FieldAccessorFactory> accessorFactories = accessorFactoriesBuilder.put(Boolean.TYPE, BoolFieldAccessor::new).put(Boolean.class, BoolFieldAccessor::new).put(Byte.TYPE, ByteFieldAccessor::new).put(Byte.class, ByteFieldAccessor::new).put(byte[].class, ByteArrayFieldAccessor::new).put(Double.TYPE, DoubleFieldAccessor::new).put(Double.class, DoubleFieldAccessor::new).put(double[].class, DoubleArrayFieldAccessor::new).put(Float.TYPE, FloatFieldAccessor::new).put(Float.class, FloatFieldAccessor::new).put(float[].class, FloatArrayFieldAccessor::new).put(Integer.TYPE, IntFieldAccessor::new).put(Integer.class, IntFieldAccessor::new).put(int[].class, IntArrayFieldAccessor::new).put(Long.TYPE, LongFieldAccessor::new).put(Long.class, LongFieldAccessor::new).put(long[].class, LongArrayFieldAccessor::new).put(Short.TYPE, ShortFieldAccessor::new).put(Short.class, ShortFieldAccessor::new).put(short[].class, ShortArrayFieldAccessor::new).put(String.class, StringFieldAccessor::new).put(String[].class, StringArrayFieldAccessor::new).build();
    protected final FieldAccessor[] fields;
    protected final Class<?>[] fieldClasses;

    public AnnotatedSaveable() {
        ArrayList<Field> fields = new ArrayList<Field>();
        AnnotatedSaveable.collectAnnotatedFields(fields, this.getClass());
        fields.sort((f1, f2) -> {
            int result = f1.getClass().getName().compareTo(f2.getClass().getName());
            if (result != 0) {
                return result;
            }
            result = f1.getName().compareTo(f2.getName());
            if (result != 0) {
                return result;
            }
            return 0;
        });
        this.fields = new FieldAccessor[fields.size()];
        this.fieldClasses = new Class[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field f = (Field)fields.get(i);
            FieldAccessorFactory factory = accessorFactories.get(f.getType());
            if (factory == null) {
                throw new AnnotatedSaveableException("Cannot type for field " + f);
            }
            this.fields[i] = (FieldAccessor)factory.apply(f);
            this.fieldClasses[i] = f.getType();
        }
    }

    static void collectAnnotatedFields(List<Field> fields, Class<? extends AnnotatedSaveable> cls) {
        if (cls.equals(AnnotatedSaveable.class)) {
            return;
        }
        AnnotatedSaveable.collectAnnotatedFields(fields, cls.getSuperclass());
        for (Field f : cls.getDeclaredFields()) {
            SaveableField annot = f.getAnnotation(SaveableField.class);
            if (annot == null) continue;
            f.setAccessible(true);
            fields.add(f);
        }
    }

    public Class<?>[] getObjectStorageFields() {
        return this.fieldClasses;
    }

    public void save(ObjectStorage objStorage) {
        for (FieldAccessor fa : this.fields) {
            fa.save(this, objStorage);
        }
    }

    public void restore(ObjectStorage objStorage) {
        for (FieldAccessor fa : this.fields) {
            fa.restore(this, objStorage);
        }
    }

    public boolean isUpgradeable(int oldSchemaVersion) {
        return false;
    }

    public boolean upgrade(ObjectStorage oldObjStorage, int oldSchemaVersion, ObjectStorage currentObjStorage) {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public static class AnnotatedSaveableException
    extends AssertionError {
        public AnnotatedSaveableException(String message) {
            super((Object)message);
        }
    }

    public static interface FieldAccessorFactory
    extends Function<Field, FieldAccessor> {
    }

    public static class StringArrayFieldAccessor
    extends AbstractFieldAccessor<String[]> {
        public StringArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getStrings, ObjectStorage::putStrings);
        }
    }

    public static class StringFieldAccessor
    extends AbstractFieldAccessor<String> {
        public StringFieldAccessor(Field field) {
            super(field, ObjectStorage::getString, ObjectStorage::putString);
        }
    }

    public static class ShortArrayFieldAccessor
    extends AbstractFieldAccessor<short[]> {
        public ShortArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getShorts, ObjectStorage::putShorts);
        }
    }

    public static class ShortFieldAccessor
    extends AbstractFieldAccessor<Short> {
        public ShortFieldAccessor(Field field) {
            super(field, ObjectStorage::getShort, ObjectStorage::putShort);
        }
    }

    public static class LongArrayFieldAccessor
    extends AbstractFieldAccessor<long[]> {
        public LongArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getLongs, ObjectStorage::putLongs);
        }
    }

    public static class LongFieldAccessor
    extends AbstractFieldAccessor<Long> {
        public LongFieldAccessor(Field field) {
            super(field, ObjectStorage::getLong, ObjectStorage::putLong);
        }
    }

    public static class IntArrayFieldAccessor
    extends AbstractFieldAccessor<int[]> {
        public IntArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getInts, ObjectStorage::putInts);
        }
    }

    public static class IntFieldAccessor
    extends AbstractFieldAccessor<Integer> {
        public IntFieldAccessor(Field field) {
            super(field, ObjectStorage::getInt, ObjectStorage::putInt);
        }
    }

    public static class FloatArrayFieldAccessor
    extends AbstractFieldAccessor<float[]> {
        public FloatArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getFloats, ObjectStorage::putFloats);
        }
    }

    public static class FloatFieldAccessor
    extends AbstractFieldAccessor<Float> {
        public FloatFieldAccessor(Field field) {
            super(field, ObjectStorage::getFloat, ObjectStorage::putFloat);
        }
    }

    public static class DoubleArrayFieldAccessor
    extends AbstractFieldAccessor<double[]> {
        public DoubleArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getDoubles, ObjectStorage::putDoubles);
        }
    }

    public static class DoubleFieldAccessor
    extends AbstractFieldAccessor<Double> {
        public DoubleFieldAccessor(Field field) {
            super(field, ObjectStorage::getDouble, ObjectStorage::putDouble);
        }
    }

    public static class ByteArrayFieldAccessor
    extends AbstractFieldAccessor<byte[]> {
        public ByteArrayFieldAccessor(Field field) {
            super(field, ObjectStorage::getBytes, ObjectStorage::putBytes);
        }
    }

    public static class ByteFieldAccessor
    extends AbstractFieldAccessor<Byte> {
        public ByteFieldAccessor(Field field) {
            super(field, ObjectStorage::getByte, ObjectStorage::putByte);
        }
    }

    public static class BoolFieldAccessor
    extends AbstractFieldAccessor<Boolean> {
        public BoolFieldAccessor(Field field) {
            super(field, ObjectStorage::getBoolean, ObjectStorage::putBoolean);
        }
    }

    public static abstract class AbstractFieldAccessor<T>
    implements FieldAccessor {
        protected final Field field;
        protected final Function<ObjectStorage, T> objGetter;
        protected final BiConsumer<ObjectStorage, T> objPutter;

        public AbstractFieldAccessor(Field field, Function<ObjectStorage, T> objGetter, BiConsumer<ObjectStorage, T> objPutter) {
            this.field = field;
            this.objGetter = objGetter;
            this.objPutter = objPutter;
        }

        @Override
        public void save(AnnotatedSaveable saveable, ObjectStorage objStorage) {
            try {
                this.objPutter.accept(objStorage, (ObjectStorage)this.field.get(saveable));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void restore(AnnotatedSaveable saveable, ObjectStorage objStorage) {
            try {
                this.field.set(saveable, this.objGetter.apply(objStorage));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static interface FieldAccessor {
        public void save(AnnotatedSaveable var1, ObjectStorage var2);

        public void restore(AnnotatedSaveable var1, ObjectStorage var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SaveableField {
    }
}

