/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.database.listing.DBTraceDataAdapter;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.Trace;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceLabelSymbol
extends AbstractDBTraceSymbol
implements TraceLabelSymbol,
DBTraceSpaceKey,
DBTraceOverlaySpaceAdapter.DecodesAddresses {
    static final String TABLE_NAME = "Labels";
    private static final byte PRIMARY_MASK = 16;
    private static final int PRIMARY_CLEAR = -17;
    static final String ADDRESS_COLUMN_NAME = "Address";
    static final String THREAD_COLUMN_NAME = "Thread";
    static final String START_SNAP_COLUMN_NAME = "Start";
    static final String END_SNAP_COLUMN_NAME = "End";
    @DBAnnotatedColumn(value="Address")
    static DBObjectColumn ADDRESS_COLUMN;
    @DBAnnotatedColumn(value="Thread")
    static DBObjectColumn THREAD_COLUMN;
    @DBAnnotatedColumn(value="Start")
    static DBObjectColumn START_SNAP_COLUMN;
    @DBAnnotatedColumn(value="End")
    static DBObjectColumn END_SNAP_COLUMN;
    @DBAnnotatedField(column="Address", codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
    protected Address address;
    @DBAnnotatedField(column="Thread")
    protected long threadKey;
    @DBAnnotatedField(column="Start")
    protected long startSnap;
    @DBAnnotatedField(column="End")
    protected long endSnap;
    protected DBTraceThread thread;
    protected Range<Long> lifespan;

    public DBTraceLabelSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(manager, store, record);
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.thread = this.manager.threadManager.getThread(this.threadKey);
        this.lifespan = DBTraceUtils.toRange(this.startSnap, this.endSnap);
    }

    protected void set(Range<Long> lifespan, DBTraceThread thread, Address address, String name, DBTraceNamespaceSymbol parent, SourceType source) {
        this.name = name;
        this.parentID = parent.getID();
        this.doSetSource(source);
        this.address = address;
        this.threadKey = thread == null ? -1L : thread.getKey();
        this.startSnap = DBTraceUtils.lowerEndpoint(lifespan);
        this.endSnap = DBTraceUtils.upperEndpoint(lifespan);
        this.update(new DBObjectColumn[]{NAME_COLUMN, PARENT_COLUMN, START_SNAP_COLUMN, END_SNAP_COLUMN, FLAGS_COLUMN, ADDRESS_COLUMN, THREAD_COLUMN});
        this.parent = parent;
        this.thread = thread;
        this.lifespan = lifespan;
    }

    @Override
    public Range<Long> getLifespan() {
        return this.lifespan;
    }

    @Override
    public long getStartSnap() {
        return this.startSnap;
    }

    @Override
    public void setEndSnap(long endSnap) {
        if (this.endSnap == endSnap) {
            return;
        }
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            Range<Long> newLifespan = DBTraceUtils.toRange(this.startSnap, endSnap);
            this.endSnap = endSnap;
            this.update(END_SNAP_COLUMN);
            Range<Long> oldLifespan = this.lifespan;
            this.lifespan = newLifespan;
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceLabelSymbol, Range<Long>>(Trace.TraceSymbolChangeType.LIFESPAN_CHANGED, this.getSpace(), this, oldLifespan, newLifespan));
        }
    }

    @Override
    public long getEndSnap() {
        return this.endSnap;
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.address.getAddressSpace();
    }

    @Override
    public DBTraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return 0;
    }

    @Override
    protected TraceAddressSpace getSpace() {
        return this;
    }

    public SymbolType getSymbolType() {
        return SymbolType.LABEL;
    }

    @Override
    protected void validateNameAndParent(String newName, DBTraceNamespaceSymbol newParent) throws DuplicateNameException {
        this.manager.assertNotDuplicate(this, this.lifespan, this.thread, this.address, newName, newParent);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public DBTraceCodeUnitAdapter getCodeUnit() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DBTraceCodeSpace code = (DBTraceCodeSpace)this.manager.trace.getCodeManager().get(this, false);
            if (code == null) {
                UndefinedDBTraceData undefinedDBTraceData = this.manager.trace.getCodeManager().doCreateUndefinedUnit(this.startSnap, this.address, this.thread, this.getFrameLevel());
                return undefinedDBTraceData;
            }
            TraceCodeUnit cu = code.codeUnits().getContaining(this.startSnap, this.address);
            if (cu == null) {
                TraceCodeUnit traceCodeUnit = cu;
                return traceCodeUnit;
            }
            if (this.address.equals((Object)cu.getMinAddress())) {
                TraceCodeUnit traceCodeUnit = cu;
                return traceCodeUnit;
            }
            if (cu instanceof DBTraceDataAdapter) {
                int offset = (int)this.address.subtract(cu.getMinAddress());
                DBTraceDataAdapter data = ((DBTraceDataAdapter)cu).getPrimitiveAt(offset);
                TraceCodeUnit traceCodeUnit = data == null ? cu : data;
                return traceCodeUnit;
            }
            DBTraceCodeUnitAdapter dBTraceCodeUnitAdapter = null;
            return dBTraceCodeUnitAdapter;
        }
    }

    public Object getObject() {
        return this.getCodeUnit();
    }

    protected boolean doSetPrimary(boolean primary) {
        boolean old = this.isPrimary();
        if (primary == old) {
            return false;
        }
        this.flags = primary ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        return true;
    }

    public boolean setPrimary() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            AddressRangeImpl range = new AddressRangeImpl(this.address, this.address);
            if (!this.manager.functions.getIntersecting(this.lifespan, this.thread, (AddressRange)range, false, true).isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean result = this.doSetPrimary(true);
            if (!result) {
                boolean bl = false;
                return bl;
            }
            boolean firedEvent = false;
            this.update(FLAGS_COLUMN);
            for (DBTraceLabelSymbol other : this.manager.labels.getIntersecting(this.lifespan, this.thread, (AddressRange)range, false, true)) {
                if (!other.doSetPrimary(false)) continue;
                other.update(AbstractDBTraceSymbol.FLAGS_COLUMN);
                this.manager.trace.setChanged(new TraceChangeRecord<DBTraceLabelSymbol, DBTraceLabelSymbol>(Trace.TraceSymbolChangeType.SET_AS_PRIMARY, this.getSpace(), this, other, this));
                firedEvent = true;
            }
            if (!firedEvent) {
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.SET_AS_PRIMARY, this.getSpace(), this));
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean isPrimary() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = (this.flags & 0x10) != 0;
            return bl;
        }
    }
}

