/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import com.google.common.cache.CacheBuilder;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.program.AbstractDBTraceProgramViewMemory;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewMemoryRegionBlock;
import ghidra.trace.database.program.DBTraceProgramViewMemorySpaceBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class DBTraceProgramViewMemory
extends AbstractDBTraceProgramViewMemory {
    private final Map<DBTraceMemoryRegion, DBTraceProgramViewMemoryRegionBlock> regionBlocks = CacheBuilder.newBuilder().removalListener(this::regionBlockRemoved).weakValues().build().asMap();
    private final Map<AddressSpace, DBTraceProgramViewMemorySpaceBlock> spaceBlocks = CacheBuilder.newBuilder().removalListener(this::spaceBlockRemoved).weakValues().build().asMap();

    public DBTraceProgramViewMemory(DBTraceProgramView program) {
        super(program);
    }

    protected DBTraceMemoryRegion getTopRegion(Function<Long, DBTraceMemoryRegion> regFunc) {
        return this.program.viewport.getTop(s -> {
            DBTraceMemoryRegion reg = (DBTraceMemoryRegion)regFunc.apply((Long)s);
            if (reg != null && this.program.isRegionVisible(reg)) {
                return reg;
            }
            return null;
        });
    }

    protected void forVisibleRegions(Consumer<? super DBTraceMemoryRegion> action) {
        for (long s : this.program.viewport.getOrderedSnaps()) {
            for (DBTraceMemoryRegion dBTraceMemoryRegion : this.memoryManager.getRegionsAtSnap(s)) {
                if (!this.program.isRegionVisible(dBTraceMemoryRegion)) continue;
                action.accept(dBTraceMemoryRegion);
            }
        }
    }

    @Override
    protected void recomputeAddressSet() {
        AddressSet temp = new AddressSet();
        this.forVisibleRegions(reg -> temp.add(reg.getRange()));
        this.addressSet = temp;
    }

    protected MemoryBlock getRegionBlock(DBTraceMemoryRegion region) {
        return this.regionBlocks.computeIfAbsent(region, r -> new DBTraceProgramViewMemoryRegionBlock(this.program, region));
    }

    protected MemoryBlock getSpaceBlock(AddressSpace space) {
        return this.spaceBlocks.computeIfAbsent(space, s -> new DBTraceProgramViewMemorySpaceBlock(this.program, space));
    }

    public MemoryBlock getBlock(Address addr) {
        if (this.forceFullView) {
            return this.getSpaceBlock(addr.getAddressSpace());
        }
        DBTraceMemoryRegion region = this.getTopRegion(s -> this.memoryManager.getRegionContaining((long)s, addr));
        return region == null ? null : this.getRegionBlock(region);
    }

    public MemoryBlock getBlock(String blockName) {
        if (this.forceFullView) {
            AddressSpace space = this.program.getAddressFactory().getAddressSpace(blockName);
            return space == null ? null : this.getSpaceBlock(space);
        }
        DBTraceMemoryRegion region = this.getTopRegion(s -> this.memoryManager.getLiveRegionByPath((long)s, blockName));
        return region == null ? null : this.getRegionBlock(region);
    }

    public MemoryBlock[] getBlocks() {
        ArrayList result = new ArrayList();
        if (this.forceFullView) {
            this.forPhysicalSpaces(space -> result.add(this.getSpaceBlock((AddressSpace)space)));
        } else {
            this.forVisibleRegions(reg -> result.add(this.getRegionBlock((DBTraceMemoryRegion)reg)));
        }
        Collections.sort(result, Comparator.comparing(b -> b.getStart()));
        return result.toArray(new MemoryBlock[result.size()]);
    }

    public void updateAddRegionBlock(DBTraceMemoryRegion region) {
        this.addRange(region.getRange());
    }

    public void updateChangeRegionBlockName(DBTraceMemoryRegion region) {
    }

    public void updateChangeRegionBlockFlags(DBTraceMemoryRegion region) {
    }

    public void updateChangeRegionBlockRange(DBTraceMemoryRegion region, AddressRange oldRange, AddressRange newRange) {
        this.changeRange(oldRange, newRange);
    }

    public void updateDeleteRegionBlock(DBTraceMemoryRegion region) {
        this.regionBlocks.remove(region);
        this.removeRange(region.getRange());
    }

    public void updateAddSpaceBlock(AddressSpace space) {
    }

    public void updateDeleteSpaceBlock(AddressSpace space) {
        this.spaceBlocks.remove(space);
    }

    public void updateRefreshBlocks() {
        this.regionBlocks.clear();
        this.spaceBlocks.clear();
        this.recomputeAddressSet();
    }
}

