/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.database.listing.AbstractDBTraceDataComponent;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.listing.DBTraceDataAdapter;
import ghidra.trace.database.listing.DBTraceDataArrayElementComponent;
import ghidra.trace.database.listing.DBTraceDataCompositeFieldComponent;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;

public interface DBTraceDefinedDataAdapter
extends DBTraceDataAdapter {
    default public boolean isDefined() {
        return true;
    }

    public AbstractDBTraceDataComponent[] doGetComponentCache();

    /*
     * Loose catch block
     */
    default public int getNumComponents() {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().readLock());){
            if (this.getLength() < this.getDataType().getLength()) {
                int n = -1;
                return n;
            }
            DataType baseDataType = this.getBaseDataType();
            if (baseDataType instanceof Composite) {
                int n = ((Composite)baseDataType).getNumComponents();
                return n;
            }
            if (baseDataType instanceof Array) {
                int n = ((Array)baseDataType).getNumElements();
                return n;
            }
            if (baseDataType instanceof DynamicDataType) {
                try {
                    int n = ((DynamicDataType)baseDataType).getNumComponents((MemBuffer)this);
                    return n;
                }
                catch (Exception e) {
                    int n;
                    block17: {
                        n = 0;
                        if (hold == null) break block17;
                        hold.close();
                    }
                    return n;
                }
            }
            int n = 0;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public DBTraceData getRoot();

    public DBTraceDefinedDataAdapter getParent();

    public StringBuilder getPathName(StringBuilder var1, boolean var2);

    @Override
    default public DBTraceDefinedDataAdapter getComponent(int index) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            if (index < 0 || index >= this.getNumComponents()) {
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = null;
                return dBTraceDefinedDataAdapter;
            }
            AbstractDBTraceDataComponent[] cache = this.doGetComponentCache();
            if (cache[index] != null) {
                AbstractDBTraceDataComponent abstractDBTraceDataComponent = cache[index];
                return abstractDBTraceDataComponent;
            }
            DataType baseDataType = this.getBaseDataType();
            if (baseDataType instanceof Array) {
                Array array = (Array)baseDataType;
                int elementLength = array.getElementLength();
                Address componentAddress = this.getAddress().add((long)(index * elementLength));
                cache[index] = new DBTraceDataArrayElementComponent(this.getRoot(), this, index, componentAddress, array.getDataType(), elementLength);
                DBTraceDataArrayElementComponent dBTraceDataArrayElementComponent = cache[index];
                return dBTraceDataArrayElementComponent;
            }
            if (baseDataType instanceof Composite) {
                Composite composite = (Composite)baseDataType;
                DataTypeComponent dtc = composite.getComponent(index);
                Address componentAddress = this.getAddress().add((long)dtc.getOffset());
                cache[index] = new DBTraceDataCompositeFieldComponent(this.getRoot(), this, componentAddress, dtc);
                DBTraceDataCompositeFieldComponent dBTraceDataCompositeFieldComponent = cache[index];
                return dBTraceDataCompositeFieldComponent;
            }
            if (baseDataType instanceof DynamicDataType) {
                DynamicDataType dynamic = (DynamicDataType)baseDataType;
                DataTypeComponent dtc = dynamic.getComponent(index, (MemBuffer)this);
                Address componentAddress = this.getAddress().add((long)dtc.getOffset());
                cache[index] = new DBTraceDataCompositeFieldComponent(this.getRoot(), this, componentAddress, dtc);
                DBTraceDataCompositeFieldComponent dBTraceDataCompositeFieldComponent = cache[index];
                return dBTraceDataCompositeFieldComponent;
            }
            Msg.error((Object)this, (Object)("Unsupported composite data type class: " + baseDataType.getClass().getName()));
            DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = null;
            return dBTraceDefinedDataAdapter;
        }
    }

    @Override
    @Deprecated
    default public DBTraceDefinedDataAdapter getComponentAt(int offset) {
        return this.getComponentContaining(offset);
    }

    default public DBTraceDefinedDataAdapter getComponentContaining(int offset) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            if (offset < 0 || offset >= this.getLength()) {
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = null;
                return dBTraceDefinedDataAdapter;
            }
            DataType baseDataType = this.getBaseDataType();
            if (baseDataType instanceof Array) {
                Array array = (Array)baseDataType;
                int elementLength = array.getElementLength();
                int index = offset / elementLength;
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = this.getComponent(index);
                return dBTraceDefinedDataAdapter;
            }
            if (baseDataType instanceof Structure) {
                Structure structure = (Structure)baseDataType;
                DataTypeComponent dtc = structure.getComponentContaining(offset);
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = dtc == null ? null : this.getComponent(dtc.getOrdinal());
                return dBTraceDefinedDataAdapter;
            }
            if (baseDataType instanceof Union) {
                DBTraceDefinedDataAdapter structure = null;
                return structure;
            }
            if (baseDataType instanceof DynamicDataType) {
                DynamicDataType dynamic = (DynamicDataType)baseDataType;
                DataTypeComponent dtc = dynamic.getComponentAt(offset, (MemBuffer)this);
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = dtc == null ? null : this.getComponent(dtc.getOrdinal());
                return dBTraceDefinedDataAdapter;
            }
            DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = null;
            return dBTraceDefinedDataAdapter;
        }
    }

    default public List<Data> getComponentsContaining(int offset) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            if (offset < 0 || offset >= this.getLength()) {
                List<Data> list = null;
                return list;
            }
            DataType baseDataType = this.getBaseDataType();
            if (baseDataType instanceof Array) {
                Array array = (Array)baseDataType;
                int elementLength = array.getElementLength();
                int n = offset / elementLength;
                List<Data> list = Collections.singletonList(this.getComponent(n));
                return list;
            }
            if (baseDataType instanceof Structure) {
                Structure struct = (Structure)baseDataType;
                ArrayList<Data> result = new ArrayList<Data>();
                for (DataTypeComponent dtc : struct.getComponentsContaining(offset)) {
                    result.add(this.getComponent(dtc.getOrdinal()));
                }
                ArrayList<Data> arrayList = result;
                return arrayList;
            }
            if (baseDataType instanceof DynamicDataType) {
                DynamicDataType ddt = (DynamicDataType)baseDataType;
                DataTypeComponent dtc = ddt.getComponentAt(offset, (MemBuffer)this);
                ArrayList<Data> object = new ArrayList<Data>();
                while (dtc != null && offset >= dtc.getOffset() && offset < dtc.getOffset() + dtc.getLength()) {
                    int ordinal = dtc.getOrdinal();
                    object.add(this.getComponent(ordinal++));
                    dtc = ordinal < ddt.getNumComponents((MemBuffer)this) ? ddt.getComponent(ordinal, (MemBuffer)this) : null;
                }
                ArrayList<Data> arrayList = object;
                return arrayList;
            }
            if (baseDataType instanceof Union) {
                Union union = (Union)baseDataType;
                ArrayList<Data> result = new ArrayList<Data>();
                for (DataTypeComponent dtc : union.getComponents()) {
                    if (offset >= dtc.getLength()) continue;
                    result.add(this.getComponent(dtc.getOrdinal()));
                }
                ArrayList<Data> arrayList = result;
                return arrayList;
            }
            List<Data> list = Collections.emptyList();
            return list;
        }
    }

    @Override
    default public DBTraceDefinedDataAdapter getPrimitiveAt(int offset) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            if (offset < 0 || offset >= this.getLength()) {
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = null;
                return dBTraceDefinedDataAdapter;
            }
            DBTraceDefinedDataAdapter component = this.getComponentAt(offset);
            if (component == null || component == this) {
                DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = this;
                return dBTraceDefinedDataAdapter;
            }
            DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = component.getPrimitiveAt(offset - component.getParentOffset());
            return dBTraceDefinedDataAdapter;
        }
    }

    default public DBTraceDefinedDataAdapter doGetComponent(int[] componentPath, int level) {
        if (componentPath == null || level >= componentPath.length) {
            return this;
        }
        DBTraceDefinedDataAdapter next = this.getComponent(componentPath[level]);
        return next == null ? null : next.doGetComponent(componentPath, level + 1);
    }

    @Override
    default public DBTraceDefinedDataAdapter getComponent(int[] componentPath) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            DBTraceDefinedDataAdapter dBTraceDefinedDataAdapter = this.doGetComponent(componentPath, 0);
            return dBTraceDefinedDataAdapter;
        }
    }
}

