/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.language;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.app.util.PseudoInstruction;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.language.DBTraceGuestLanguageMappedMemory;
import ghidra.trace.database.language.DBTraceGuestLanguageMappedRange;
import ghidra.trace.database.language.DBTraceLanguageManager;
import ghidra.trace.model.language.TraceGuestLanguage;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceGuestLanguage
extends DBAnnotatedObject
implements TraceGuestLanguage {
    public static final String TABLE_NAME = "Languages";
    static final String LANGID_COLUMN_NAME = "ID";
    static final String VERSION_COLUMN_NAME = "Version";
    static final String MINOR_VERSION_COLUMN_NAME = "MinorVersion";
    @DBAnnotatedColumn(value="ID")
    static DBObjectColumn LANGID_COLUMN;
    @DBAnnotatedColumn(value="Version")
    static DBObjectColumn VERSION_COLUMN;
    @DBAnnotatedColumn(value="MinorVersion")
    static DBObjectColumn MINOR_VERSION_COLUMN;
    @DBAnnotatedField(column="ID", codec=DBTraceUtils.LanguageIDDBFieldCodec.class)
    private LanguageID langID;
    @DBAnnotatedField(column="Version")
    private int version;
    @DBAnnotatedField(column="MinorVersion")
    private int minorVersion;
    private final DBTraceLanguageManager manager;
    private Language guestLanguage;
    protected final NavigableMap<Address, DBTraceGuestLanguageMappedRange> rangesByHostAddress = new TreeMap<Address, DBTraceGuestLanguageMappedRange>();
    protected final AddressSet hostAddressSet = new AddressSet();
    protected final NavigableMap<Address, DBTraceGuestLanguageMappedRange> rangesByGuestAddress = new TreeMap<Address, DBTraceGuestLanguageMappedRange>();
    protected final AddressSet guestAddressSet = new AddressSet();

    public DBTraceGuestLanguage(DBTraceLanguageManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    void setLanguage(Language language) {
        this.guestLanguage = language;
        this.langID = language.getLanguageID();
        this.version = language.getVersion();
        this.minorVersion = language.getMinorVersion();
        this.update(LANGID_COLUMN, VERSION_COLUMN, MINOR_VERSION_COLUMN);
    }

    protected void deleteMappedRange(DBTraceGuestLanguageMappedRange range, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.manager.trace.getCodeManager().clearLanguage((Range<Long>)Range.all(), range.getHostRange(), (int)this.getKey(), monitor);
            this.manager.rangeMappingStore.delete((DBAnnotatedObject)range);
            AddressRange hostRange = range.getHostRange();
            AddressRange guestRange = range.getGuestRange();
            this.rangesByHostAddress.remove(hostRange.getMinAddress());
            this.rangesByGuestAddress.remove(guestRange.getMinAddress());
            this.hostAddressSet.delete(hostRange);
            this.guestAddressSet.delete(guestRange);
        }
    }

    protected void doGetLanguage(LanguageService langServ) throws LanguageNotFoundException, VersionException {
        this.guestLanguage = langServ.getLanguage(this.langID);
        if (this.version != this.guestLanguage.getVersion() || this.minorVersion != this.guestLanguage.getMinorVersion()) {
            throw new VersionException();
        }
    }

    @Override
    public Language getLanguage() {
        return this.guestLanguage;
    }

    @Override
    public void delete(TaskMonitor monitor) throws CancelledException {
        this.manager.deleteGuestLanguage(this, monitor);
    }

    @Override
    public DBTraceGuestLanguageMappedRange addMappedRange(Address hostStart, Address guestStart, long length) throws AddressOverflowException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            Address hostEnd = hostStart.addNoWrap(length - 1L);
            if (this.hostAddressSet.intersects(hostStart, hostEnd)) {
                throw new IllegalArgumentException("Range overlaps existing host mapped range(s) for this guest language");
            }
            Address guestEnd = guestStart.addNoWrap(length - 1L);
            if (this.guestAddressSet.intersects(guestStart, guestEnd)) {
                throw new IllegalArgumentException("Range overlaps existing guest mapped range(s)");
            }
            DBTraceGuestLanguageMappedRange mappedRange = (DBTraceGuestLanguageMappedRange)this.manager.rangeMappingStore.create();
            mappedRange.set(hostStart, this.guestLanguage, guestStart, length);
            this.rangesByHostAddress.put(hostStart, mappedRange);
            this.rangesByGuestAddress.put(guestStart, mappedRange);
            this.hostAddressSet.add(mappedRange.getHostRange());
            this.guestAddressSet.add(mappedRange.getGuestRange());
            DBTraceGuestLanguageMappedRange dBTraceGuestLanguageMappedRange = mappedRange;
            return dBTraceGuestLanguageMappedRange;
        }
    }

    @Override
    public AddressSetView getHostAddressSet() {
        return new AddressSet((AddressSetView)this.hostAddressSet);
    }

    @Override
    public AddressSetView getGuestAddressSet() {
        return new AddressSet((AddressSetView)this.guestAddressSet);
    }

    @Override
    public Address mapHostToGuest(Address hostAddress) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestLanguageMappedRange> floorEntry = this.rangesByHostAddress.floorEntry(hostAddress);
            if (floorEntry == null) {
                Address address = null;
                return address;
            }
            Address address = floorEntry.getValue().mapHostToGuest(hostAddress);
            return address;
        }
    }

    @Override
    public Address mapGuestToHost(Address guestAddress) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestLanguageMappedRange> floorEntry = this.rangesByGuestAddress.floorEntry(guestAddress);
            if (floorEntry == null) {
                Address address = null;
                return address;
            }
            Address address = floorEntry.getValue().mapGuestToHost(guestAddress);
            return address;
        }
    }

    public Address mapGuestToHost(Address guestMin, Address guestMax) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Map.Entry<Address, DBTraceGuestLanguageMappedRange> floorEntry = this.rangesByGuestAddress.floorEntry(guestMin);
            if (floorEntry == null) {
                Address address = null;
                return address;
            }
            DBTraceGuestLanguageMappedRange range = floorEntry.getValue();
            if (!range.getGuestRange().contains(guestMax)) {
                Address address = null;
                return address;
            }
            Address address = range.mapGuestToHost(guestMin);
            return address;
        }
    }

    @Override
    public MemBuffer getMappedMemBuffer(long snap, Address guestAddress) {
        return new DumbMemBufferImpl((Memory)new DBTraceGuestLanguageMappedMemory(this.manager.trace.getMemoryManager(), this, snap), guestAddress);
    }

    @Override
    public InstructionSet mapGuestInstructionAddressesToHost(InstructionSet instructionSet) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            HashMap<Address, InstructionBlock> blocksByNext = new HashMap<Address, InstructionBlock>();
            InstructionSet mappedSet = new InstructionSet(this.guestLanguage.getAddressFactory());
            for (InstructionBlock block : instructionSet) {
                for (Instruction instruction : block) {
                    PseudoInstruction mappedIntruction;
                    Address hostAddr = this.mapGuestToHost(instruction.getAddress(), instruction.getMaxAddress());
                    if (hostAddr == null) continue;
                    try {
                        mappedIntruction = new PseudoInstruction(hostAddr, instruction.getPrototype(), (MemBuffer)instruction, (ProcessorContext)instruction);
                    }
                    catch (AddressOverflowException e) {
                        throw new AssertionError((Object)e);
                    }
                    InstructionBlock addTo = (InstructionBlock)blocksByNext.remove(hostAddr);
                    if (addTo == null) {
                        addTo = new InstructionBlock(hostAddr);
                    }
                    addTo.addInstruction((Instruction)mappedIntruction);
                    Address next = addTo.getMaxAddress().next();
                    if (next == null) continue;
                    blocksByNext.put(next, addTo);
                }
            }
            blocksByNext.values().forEach(arg_0 -> ((InstructionSet)mappedSet).addBlock(arg_0));
            Iterator iterator = mappedSet;
            return iterator;
        }
    }
}

