/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.AbstractPcodeEmulator;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.pcode.exec.trace.TraceCachedWriteBytesPcodeExecutorState;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;

public class TracePcodeEmulator
extends AbstractPcodeEmulator {
    protected final Trace trace;
    protected final long snap;

    private static SleighLanguage assertSleigh(Language language) {
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Emulation requires a sleigh language");
        }
        return (SleighLanguage)language;
    }

    public TracePcodeEmulator(Trace trace, long snap, SleighUseropLibrary<byte[]> library) {
        super(TracePcodeEmulator.assertSleigh(trace.getBaseLanguage()), library);
        this.trace = trace;
        this.snap = snap;
    }

    public TracePcodeEmulator(Trace trace, long snap) {
        this(trace, snap, (SleighUseropLibrary<byte[]>)SleighUseropLibrary.nil());
    }

    protected PcodeExecutorState<byte[]> newState(TraceThread thread) {
        return new TraceCachedWriteBytesPcodeExecutorState(this.trace, this.snap, thread, 0);
    }

    protected PcodeExecutorState<byte[]> createSharedState() {
        return this.newState(null);
    }

    protected PcodeExecutorState<byte[]> createLocalState(PcodeThread<byte[]> emuThread) {
        return this.newState(this.trace.getThreadManager().getLiveThreadByPath(this.snap, emuThread.getName()));
    }

    public void writeDown(Trace trace, long destSnap, long threadsSnap, boolean synthesizeStacks) {
        TraceCachedWriteBytesPcodeExecutorState ss = (TraceCachedWriteBytesPcodeExecutorState)this.getSharedState();
        ss.writeCacheDown(trace, destSnap, null, 0);
        TraceThreadManager threadManager = trace.getThreadManager();
        for (PcodeThread emuThread : this.threads.values()) {
            TraceCachedWriteBytesPcodeExecutorState ls = (TraceCachedWriteBytesPcodeExecutorState)emuThread.getState().getLocalState();
            TraceThread traceThread = threadManager.getLiveThreadByPath(threadsSnap, emuThread.getName());
            if (traceThread == null) {
                throw new IllegalArgumentException("Given trace does not have thread with name/path '" + emuThread.getName() + "' at snap " + destSnap);
            }
            ls.writeCacheDown(trace, destSnap, traceThread, 0);
            if (!synthesizeStacks) continue;
            TraceStack stack = trace.getStackManager().getStack(traceThread, destSnap, true);
            stack.getFrame(0, true).setProgramCounter(emuThread.getCounter());
        }
    }
}

