/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.DefaultTraceTimeViewport;
import java.util.Map;

public class TraceMemoryStatePcodeExecutorStatePiece
extends AbstractLongOffsetPcodeExecutorStatePiece<byte[], TraceMemoryState, TraceMemorySpace> {
    private final RangeMap<UnsignedLong, TraceMemoryState> unique = TreeRangeMap.create();
    private final Trace trace;
    private long snap;
    private TraceThread thread;
    private int frame;
    private final DefaultTraceTimeViewport viewport;

    public TraceMemoryStatePcodeExecutorStatePiece(Trace trace, long snap, TraceThread thread, int frame) {
        super(trace.getBaseLanguage(), (PcodeArithmetic)TraceMemoryStatePcodeArithmetic.INSTANCE);
        this.trace = trace;
        this.snap = snap;
        this.thread = thread;
        this.frame = frame;
        this.viewport = new DefaultTraceTimeViewport(trace);
        this.viewport.setSnap(snap);
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setSnap(long snap) {
        this.snap = snap;
        this.viewport.setSnap(snap);
    }

    public long getSnap() {
        return this.snap;
    }

    public void setThread(TraceThread thread) {
        if (thread != null & thread.getTrace() != this.trace) {
            throw new IllegalArgumentException("Thread, if given, must be part of the same trace");
        }
        this.thread = thread;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public int getFrame() {
        return this.frame;
    }

    protected Range<UnsignedLong> range(long offset, int size) {
        return Range.closedOpen((Comparable)UnsignedLong.fromLongBits((long)offset), (Comparable)UnsignedLong.fromLongBits((long)(offset + (long)size)));
    }

    protected AddressRange range(AddressSpace space, long offset, int size) {
        try {
            return new AddressRangeImpl(space.getAddress(offset), (long)size);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected long offsetToLong(byte[] offset) {
        return Utils.bytesToLong((byte[])offset, (int)offset.length, (boolean)this.language.isBigEndian());
    }

    public byte[] longToOffset(AddressSpace space, long l) {
        return Utils.longToBytes((long)l, (int)space.getPointerSize(), (boolean)this.language.isBigEndian());
    }

    protected void setUnique(long offset, int size, TraceMemoryState val) {
        this.unique.put(this.range(offset, size), (Object)val);
    }

    protected TraceMemoryState getUnique(long offset, int size) {
        TreeRangeSet remains = TreeRangeSet.create();
        Range<UnsignedLong> range = this.range(offset, size);
        remains.add(range);
        for (Map.Entry ent : this.unique.subRangeMap(range).asMapOfRanges().entrySet()) {
            if (ent.getValue() != TraceMemoryState.KNOWN) {
                return TraceMemoryState.UNKNOWN;
            }
            remains.remove((Range)ent.getKey());
        }
        return remains.isEmpty() ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    protected TraceMemorySpace getForSpace(AddressSpace space, boolean toWrite) {
        return TraceSleighUtils.getSpaceForExecution(space, this.trace, this.thread, this.frame, toWrite);
    }

    protected void setInSpace(TraceMemorySpace space, long offset, int size, TraceMemoryState val) {
        space.setState((long)size, space.getAddressSpace().getAddress(offset), val);
    }

    protected TraceMemoryState getFromSpace(TraceMemorySpace space, long offset, int size) {
        AddressSet set = new AddressSet(this.range(space.getAddressSpace(), offset, size));
        for (long snap : this.viewport.getOrderedSnaps()) {
            set.delete(space.getAddressesWithState(snap, (AddressSetView)set, state -> state == TraceMemoryState.KNOWN));
        }
        return set.isEmpty() ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    protected TraceMemoryState getFromNullSpace(int size) {
        return TraceMemoryState.UNKNOWN;
    }

    public MemBuffer getConcreteBuffer(Address address) {
        throw new AssertionError((Object)"Cannot make TraceMemoryState into a concrete buffer");
    }
}

