/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Stack;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GraphLayers;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSimplex<V, E> {
    private static final Logger log = LoggerFactory.getLogger(NetworkSimplex.class);
    private static final Random random = new Random();
    protected List<LV<V>> leaves = new ArrayList<LV<V>>();
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected Function<LE<V, E>, Integer> weightFunction;
    protected Function<LE<V, E>, Integer> separationFunction;
    protected Map<LV<V>, Integer> layers = new HashMap<LV<V>, Integer>();
    protected Map<LE<V, E>, Integer> cutValues = new HashMap<LE<V, E>, Integer>();
    protected Map<LE<V, E>, Integer> cutMap = new HashMap<LE<V, E>, Integer>();
    protected List<List<LV<V>>> layerList;
    protected Map<LV<V>, Integer> lim = new HashMap<LV<V>, Integer>();
    protected Map<LV<V>, Integer> low = new HashMap<LV<V>, Integer>();
    protected Map<LV<V>, LE<V, E>> parent = new HashMap<LV<V>, LE<V, E>>();
    protected List<LV<V>> treeVertices = new ArrayList<LV<V>>();
    protected Map<LV<V>, Boolean> vertexInTreeMap = new HashMap<LV<V>, Boolean>();
    protected Map<LE<V, E>, Boolean> edgeInTreeMap = new HashMap<LE<V, E>, Boolean>();
    protected Comparator<LE<V, E>> edgeComparator;

    public static <V, E> Builder<V, E, ?, ?> builder(Graph<LV<V>, LE<V, E>> svGraph) {
        return new Builder(svGraph);
    }

    protected NetworkSimplex(Builder<V, E, ?, ?> builder) {
        this.svGraph = builder.svGraph;
        this.weightFunction = builder.weightFunction;
        this.separationFunction = builder.separationFunction;
        this.edgeComparator = builder.edgeComparator;
    }

    public void run() {
        Pair<LE<V, E>> leaveEnter;
        if (this.svGraph.edgeSet().size() == 0 && this.svGraph.vertexSet().size() == 0) {
            this.layers = new HashMap<LV<V>, Integer>();
        }
        this.svGraph.edgeSet().forEach(e -> this.cutMap.put((LE<Integer, E>)e, Integer.MAX_VALUE));
        this.feasibleTree();
        while ((leaveEnter = this.getLeaveEnterEdge()) != null) {
            this.exchange((LE)leaveEnter.first, (LE)leaveEnter.second);
        }
        this.shiftLayerToZero();
        for (int i = 0; i < this.layerList.size(); ++i) {
            List<LV<V>> layer = this.layerList.get(i);
            for (int j = 0; j < layer.size(); ++j) {
                LV<V> v = layer.get(j);
                v.setRank(i);
                v.setIndex(j);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("layersArray are {}", this.layerList);
            log.trace("layers are {}", this.layers);
            log.trace("vinTreeMap: {}", this.vertexInTreeMap);
            log.trace("einTreeMap: {}", this.edgeInTreeMap);
            for (Map.Entry<LE<V, E>, Boolean> entry : this.edgeInTreeMap.entrySet()) {
                log.trace("{}", entry);
            }
        }
    }

    private void feasibleTree() {
        LE<V, E> e;
        this.layerList = GraphLayers.longestPathReverse(this.svGraph, this.edgeComparator);
        this.svGraph.vertexSet().forEach(v -> this.layers.put((LV<Integer>)v, v.getRank()));
        while (this.tightTree() < this.svGraph.vertexSet().size() && (e = this.getNonTreeEdgeIncidentToTheTreeWithMinimalAmountOfSlack()) != null) {
            int slack = this.slack(e);
            if (slack == 0) {
                throw new IllegalArgumentException();
            }
            if (this.vertexInTreeMap.get(e.getSource()).booleanValue()) {
                slack = -slack;
            }
            for (LV<V> v2 : this.treeVertices) {
                int newRank = this.layers.get(v2) + slack;
                v2.setRank(newRank);
                this.layers.put(v2, newRank);
            }
        }
        this.initCutValues();
    }

    private int tightTree() {
        this.treeVertices.clear();
        for (LE ie : this.svGraph.edgeSet()) {
            this.edgeInTreeMap.put(ie, false);
        }
        for (LV v : this.svGraph.vertexSet()) {
            this.vertexInTreeMap.put(v, false);
        }
        LV v0 = (LV)this.svGraph.vertexSet().stream().findFirst().get();
        this.vertexInTreeMap.put(v0, true);
        this.treeVertices.add(v0);
        Stack queue = new Stack();
        queue.push(v0);
        while (queue.size() > 0) {
            LV v = (LV)queue.pop();
            for (LE e : this.svGraph.outgoingEdgesOf((Object)v)) {
                if (this.vertexInTreeMap.get(e.getTarget()).booleanValue() || e.getSource().getRank() - e.getTarget().getRank() != this.separationFunction.apply(e)) continue;
                queue.push(e.getTarget());
                this.vertexInTreeMap.put(e.getTarget(), true);
                this.treeVertices.add(e.getTarget());
                this.edgeInTreeMap.put(e, true);
            }
            for (LE e : this.svGraph.incomingEdgesOf((Object)v)) {
                if (this.vertexInTreeMap.get(e.getSource()).booleanValue() || e.getSource().getRank() - e.getTarget().getRank() != this.separationFunction.apply(e)) continue;
                queue.push(e.getSource());
                this.vertexInTreeMap.put(e.getSource(), true);
                this.treeVertices.add(e.getSource());
                this.edgeInTreeMap.put(e, true);
            }
        }
        return this.treeVertices.size();
    }

    public List<List<LV<V>>> getLayerList() {
        return this.layerList;
    }

    private int slack(LE<V, E> edge) {
        return edge.getSource().getRank() - edge.getTarget().getRank() - this.separationFunction.apply(edge);
    }

    public List<LV<V>> getTreeVertices() {
        return this.treeVertices;
    }

    public Map<LV<V>, Boolean> getVertexInTreeMap() {
        return this.vertexInTreeMap;
    }

    public Map<LE<V, E>, Boolean> getEdgeInTreeMap() {
        return this.edgeInTreeMap;
    }

    private Pair<LE<V, E>> getLeaveEnterEdge() {
        LE leavingEdge = null;
        LE enteringEdge = null;
        int minCut = 0;
        for (LE e : this.svGraph.edgeSet()) {
            if (!this.edgeInTreeMap.get(e).booleanValue() || this.cutValues.getOrDefault(e, 0) >= minCut) continue;
            minCut = this.cutValues.get(e);
            leavingEdge = e;
        }
        if (leavingEdge == null) {
            return null;
        }
        int minSlack = Integer.MAX_VALUE;
        for (LE f : this.svGraph.edgeSet()) {
            boolean continuation;
            int slack = this.slack(f);
            boolean bl = continuation = random.nextInt(2) == 1;
            if (this.edgeInTreeMap.get(f).booleanValue() || this.edgeSourceTargetVal(f, leavingEdge) != -1 || slack >= minSlack && (slack != minSlack || !continuation)) continue;
            minSlack = slack;
            enteringEdge = f;
            if (minSlack != 0 || continuation) continue;
            break;
        }
        if (enteringEdge == null) {
            throw new RuntimeException();
        }
        return Pair.of(leavingEdge, enteringEdge);
    }

    private void initLimLowAndParent() {
        this.svGraph.vertexSet().forEach(v -> {
            this.lim.put((LV<Integer>)v, 0);
            this.low.put((LV<Integer>)v, 0);
            this.parent.put((LV<Object>)v, (LE<Object, E>)null);
        });
        int currentLimit = 1;
        LV v2 = (LV)this.svGraph.vertexSet().stream().findFirst().get();
        this.initLimLowParentAndLeavesOnSubtree(currentLimit, v2);
    }

    private void initCutValues() {
        this.initLimLowAndParent();
        Stack<LV<V>> front = new Stack<LV<V>>();
        for (LV<V> leaf : this.leaves) {
            front.push(leaf);
        }
        Stack<LV<V>> newFront = new Stack<LV<V>>();
        while (front.size() > 0) {
            while (front.size() > 0) {
                LV w = (LV)front.pop();
                LE<V, E> cutEdge = this.parent.get(w);
                if (cutEdge == null) continue;
                int cut = 0;
                for (LE e : this.svGraph.edgesOf((Object)w)) {
                    if (!this.edgeInTreeMap.get(e).booleanValue()) {
                        int e0Val = this.edgeSourceTargetVal(e, cutEdge);
                        if (e0Val == 0) continue;
                        cut += e0Val * this.weightFunction.apply(e);
                        continue;
                    }
                    if (e == cutEdge) {
                        cut += this.weightFunction.apply(e).intValue();
                        continue;
                    }
                    int impact = cutEdge.getSource() == e.getTarget() || cutEdge.getTarget() == e.getSource() ? 1 : -1;
                    int edgeContribution = this.edgeContribution(e, w);
                    cut += edgeContribution * impact;
                }
                this.cutMap.put(cutEdge, cut);
                LV<V> v = cutEdge.getSource() == w ? cutEdge.getTarget() : cutEdge.getSource();
                if (!this.allLowCutsHaveBeenDone(v)) continue;
                newFront.push(v);
            }
            Stack<LV<V>> t = front;
            front = newFront;
            newFront = t;
        }
    }

    private void initLimLowParentAndLeavesOnSubtree(int curLim, LV<V> v) {
        Stack stack = new Stack();
        Iterator outEdges = this.svGraph.outgoingEdgesOf(v).iterator();
        Iterator inEdges = this.svGraph.incomingEdgesOf(v).iterator();
        stack.push(Incidence.of(v, outEdges, inEdges));
        this.low.put(v, curLim);
        while (stack.size() > 0) {
            boolean done;
            Incidence ss = (Incidence)stack.pop();
            v = ss.v;
            outEdges = ss.outEdges;
            inEdges = ss.inEdges;
            block1: do {
                LE e;
                done = true;
                while (outEdges.hasNext()) {
                    e = outEdges.next();
                    if (!this.edgeInTreeMap.get(e).booleanValue() || this.low.get(e.getTarget()) > 0) continue;
                    stack.push(Incidence.of(v, outEdges, inEdges));
                    v = e.getTarget();
                    this.parent.put(v, e);
                    this.low.put(v, curLim);
                    outEdges = this.svGraph.outgoingEdgesOf(v).iterator();
                    inEdges = this.svGraph.incomingEdgesOf(v).iterator();
                }
                while (inEdges.hasNext()) {
                    e = inEdges.next();
                    if (!this.edgeInTreeMap.get(e).booleanValue() || this.low.get(e.getSource()) > 0) continue;
                    stack.push(Incidence.of(v, outEdges, inEdges));
                    v = e.getSource();
                    this.low.put(v, curLim);
                    this.parent.put(v, e);
                    outEdges = this.svGraph.outgoingEdgesOf(v).iterator();
                    inEdges = this.svGraph.incomingEdgesOf(v).iterator();
                    done = false;
                    continue block1;
                }
            } while (!done);
            this.lim.put(v, curLim++);
            if (!Objects.equals(this.lim.get(v), this.low.get(v))) continue;
            this.leaves.add(v);
        }
    }

    private void updateLayersUnderNode(LV<V> l) {
        Stack front = new Stack();
        front.push(l);
        for (LV v : this.svGraph.vertexSet()) {
            if (this.low.get(l) > this.lim.get(v) || this.lim.get(v) > this.lim.get(l) || v == l) continue;
            v.setRank(Integer.MAX_VALUE);
        }
        while (front.size() > 0) {
            LV u = (LV)front.pop();
            for (LE oe : this.svGraph.outgoingEdgesOf((Object)u)) {
                if (!this.edgeInTreeMap.get(oe).booleanValue() || oe.getTarget().getRank() != Integer.MAX_VALUE) continue;
                oe.getTarget().setRank(u.getRank() - this.separationFunction.apply(oe));
                front.push(oe.getTarget());
            }
            for (LE ie : this.svGraph.incomingEdgesOf((Object)u)) {
                if (!this.edgeInTreeMap.get(ie).booleanValue() || ie.getSource().getRank() != Integer.MAX_VALUE) continue;
                ie.getSource().setRank(u.getRank() + 1);
                front.push(ie.getSource());
            }
        }
    }

    private void updateCuts(LE<V, E> e) {
        Stack<LV<V>> front = new Stack<LV<V>>();
        Stack<LV<V>> newFront = new Stack<LV<V>>();
        front.push(e.getSource());
        front.push(e.getTarget());
        while (front.size() > 0) {
            while (front.size() > 0) {
                LV w = (LV)front.pop();
                LE<V, E> cutEdge = this.parent.get(w);
                if (cutEdge == null || this.cutMap.get(cutEdge) != Integer.MAX_VALUE) continue;
                int cut = 0;
                for (LE ce : this.svGraph.edgesOf((Object)w)) {
                    if (!this.edgeInTreeMap.get(ce).booleanValue()) {
                        int e0val = this.edgeSourceTargetVal(ce, cutEdge);
                        if (e0val == 0) continue;
                        cut += e0val * this.weightFunction.apply(ce);
                        continue;
                    }
                    if (ce == cutEdge) {
                        cut += this.weightFunction.apply(ce).intValue();
                        continue;
                    }
                    int impact = cutEdge.getSource() == ce.getTarget() || cutEdge.getTarget() == ce.getSource() ? 1 : -1;
                    int edgeContribution = this.edgeContribution(ce, w);
                    cut += edgeContribution * impact;
                }
                this.cutMap.put(cutEdge, cut);
                LV<V> u = cutEdge.getSource() == w ? cutEdge.getTarget() : cutEdge.getSource();
                if (!this.allLowCutsHaveBeenDone(u)) continue;
                newFront.push(u);
            }
            Stack<LV<V>> t = front;
            front = newFront;
            newFront = t;
        }
    }

    private boolean allLowCutsHaveBeenDone(LV<V> v) {
        for (LE ie : this.svGraph.edgesOf(v)) {
            if (!this.edgeInTreeMap.get(ie).booleanValue() || this.cutMap.getOrDefault(ie, 0) != Integer.MAX_VALUE || ie == this.parent.get(v)) continue;
            return false;
        }
        return true;
    }

    private int edgeSourceTargetVal(LE<V, E> e, LE<V, E> treeEdge) {
        if (this.edgeInTreeMap.get(e).booleanValue() || !this.edgeInTreeMap.get(treeEdge).booleanValue()) {
            throw new RuntimeException("Wrong parameters");
        }
        return this.vertexSourceTargetVal(e.getSource(), treeEdge) - this.vertexSourceTargetVal(e.getTarget(), treeEdge);
    }

    private int vertexSourceTargetVal(LV<V> v, LE<V, E> treeEdge) {
        if (!this.edgeInTreeMap.get(treeEdge).booleanValue()) {
            throw new RuntimeException("wrong params for VertexSourceTargetVal");
        }
        LV<V> s = treeEdge.getSource();
        LV<V> t = treeEdge.getTarget();
        if (this.lim.get(s) > this.lim.get(t)) {
            if (this.lim.get(v) <= this.lim.get(t) && this.low.get(t) <= this.lim.get(v)) {
                return 0;
            }
            return 1;
        }
        if (this.lim.get(v) <= this.lim.get(s) && this.low.get(s) <= this.lim.get(v)) {
            return 1;
        }
        return 0;
    }

    private LE<V, E> getNonTreeEdgeIncidentToTheTreeWithMinimalAmountOfSlack() {
        LE edge = null;
        int minSlack = Integer.MAX_VALUE;
        for (LV<V> v : this.treeVertices) {
            int slack;
            for (LE e : this.svGraph.outgoingEdgesOf(v)) {
                if (this.vertexInTreeMap.get(e.getSource()).booleanValue() && this.vertexInTreeMap.get(e.getTarget()).booleanValue() || (slack = this.slack(e)) >= minSlack) continue;
                edge = e;
                minSlack = slack;
                if (slack != 1) continue;
                return e;
            }
            for (LE e : this.svGraph.incomingEdgesOf(v)) {
                if (this.vertexInTreeMap.get(e.getSource()).booleanValue() && this.vertexInTreeMap.get(e.getTarget()).booleanValue() || (slack = this.slack(e)) >= minSlack) continue;
                edge = e;
                minSlack = slack;
                if (slack != 1) continue;
                return e;
            }
        }
        return edge;
    }

    private int edgeContribution(LE<V, E> e, LV<V> w) {
        int edgeContribution = this.cutMap.get(e) - this.weightFunction.apply(e);
        for (LE ie : this.svGraph.edgesOf(w)) {
            if (this.edgeInTreeMap.get(ie).booleanValue()) continue;
            int sign = this.edgeSourceTargetVal(ie, e);
            if (sign == -1) {
                edgeContribution += this.weightFunction.apply(ie).intValue();
                continue;
            }
            if (sign != 1) continue;
            edgeContribution -= this.weightFunction.apply(ie).intValue();
        }
        return edgeContribution;
    }

    private void shiftLayerToZero() {
        int minLayer = Integer.MAX_VALUE;
        for (LV<Object> v : this.layers.keySet()) {
            if (this.layers.get(v) >= minLayer) continue;
            minLayer = this.layers.get(v);
        }
        for (LV<Object> v : this.svGraph.vertexSet()) {
            int newRank = this.layers.get(v) - minLayer;
            v.setRank(newRank);
            this.layers.put(v, newRank);
        }
    }

    private void exchange(LE<V, E> e, LE<V, E> f) {
        LV<V> node = this.commonPredecessorOfSourceAndTargetOfF(f);
        this.createPathForCutUpdates(e, f, node);
        this.updateLimLowLeavesAndParentsUnderNode(node);
        this.updateCuts(e);
        this.updateLayersUnderNode(node);
    }

    private void updateLimLowLeavesAndParentsUnderNode(LV<V> node) {
        int llow = this.low.get(node);
        int llim = this.lim.get(node);
        this.leaves.clear();
        for (LV v : this.svGraph.vertexSet()) {
            if (llow <= this.lim.get(v) && this.lim.get(v) <= llim) {
                this.low.put(v, 0);
                continue;
            }
            if (!Objects.equals(this.low.get(v), this.lim.get(v))) continue;
            this.leaves.add(v);
        }
        this.initLowLimParentAndLeavesOnSubtree(llow, node);
    }

    private void initLowLimParentAndLeavesOnSubtree(int curLim, LV<V> v) {
        Stack stack = new Stack();
        Iterator outEnum = this.svGraph.outgoingEdgesOf(v).iterator();
        Iterator inEnum = this.svGraph.incomingEdgesOf(v).iterator();
        stack.push(new Incidence(v, outEnum, inEnum));
        this.low.put(v, curLim);
        while (stack.size() > 0) {
            boolean done;
            Incidence ss = (Incidence)stack.pop();
            v = ss.v;
            outEnum = ss.outEdges;
            inEnum = ss.inEdges;
            block1: do {
                LE e;
                done = true;
                while (outEnum.hasNext()) {
                    e = outEnum.next();
                    if (!this.edgeInTreeMap.get(e).booleanValue() || this.low.get(e.getTarget()) > 0) continue;
                    stack.push(new Incidence(v, outEnum, inEnum));
                    v = e.getTarget();
                    this.parent.put(v, e);
                    this.low.put(v, curLim);
                    outEnum = this.svGraph.outgoingEdgesOf(v).iterator();
                    inEnum = this.svGraph.incomingEdgesOf(v).iterator();
                }
                while (inEnum.hasNext()) {
                    e = inEnum.next();
                    if (!this.edgeInTreeMap.get(e).booleanValue() || this.low.get(e.getSource()) > 0) continue;
                    stack.push(new Incidence(v, outEnum, inEnum));
                    v = e.getSource();
                    this.low.put(v, curLim);
                    this.parent.put(v, e);
                    outEnum = this.svGraph.outgoingEdgesOf(v).iterator();
                    inEnum = this.svGraph.incomingEdgesOf(v).iterator();
                    done = false;
                    continue block1;
                }
            } while (!done);
            this.lim.put(v, curLim++);
            if (!Objects.equals(this.lim.get(v), this.low.get(v))) continue;
            this.leaves.add(v);
        }
    }

    private void createPathForCutUpdates(LE<V, E> e, LE<V, E> f, LV<V> l) {
        LV<V> v = f.getTarget();
        while (v != l) {
            LE<V, E> p = this.parent.get(v);
            this.cutMap.put(p, Integer.MAX_VALUE);
            v = p.getSource() == v ? p.getTarget() : p.getSource();
        }
        this.cutMap.put(f, Integer.MAX_VALUE);
        this.edgeInTreeMap.put(e, false);
        this.edgeInTreeMap.put(f, true);
    }

    private LV<V> commonPredecessorOfSourceAndTargetOfF(LE<V, E> f) {
        int fmax;
        int fMin;
        if (this.lim.get(f.getSource()) < this.lim.get(f.getTarget())) {
            fMin = this.lim.get(f.getSource());
            fmax = this.lim.get(f.getTarget());
        } else {
            fMin = this.lim.get(f.getTarget());
            fmax = this.lim.get(f.getSource());
        }
        LV<V> l = f.getSource();
        while (this.low.get(l) > fMin || fmax > this.lim.get(l)) {
            LE<V, E> p = this.parent.get(l);
            this.cutMap.put(p, Integer.MAX_VALUE);
            l = p.getSource() == l ? p.getTarget() : p.getSource();
        }
        return l;
    }

    private static class Incidence<V, E> {
        final LV<V> v;
        final Iterator<LE<V, E>> outEdges;
        final Iterator<LE<V, E>> inEdges;

        static <V, E> Incidence<V, E> of(LV<V> v, Iterator<LE<V, E>> outEdges, Iterator<LE<V, E>> inEdges) {
            return new Incidence<V, E>(v, outEdges, inEdges);
        }

        private Incidence(LV<V> v, Iterator<LE<V, E>> outEdges, Iterator<LE<V, E>> inEdges) {
            this.v = v;
            this.outEdges = outEdges;
            this.inEdges = inEdges;
        }
    }

    public static class Builder<V, E, T extends NetworkSimplex<V, E>, B extends Builder<V, E, T, B>> {
        protected Graph<LV<V>, LE<V, E>> svGraph;
        protected Function<LE<V, E>, Integer> weightFunction = e -> 1;
        protected Function<LE<V, E>, Integer> separationFunction = e -> 1;
        Comparator<LE<V, E>> edgeComparator = Layered.noopComparator;

        protected Builder(Graph<LV<V>, LE<V, E>> svGraph) {
            this.svGraph = svGraph;
        }

        protected B self() {
            return (B)this;
        }

        public B weightFunction(Function<LE<V, E>, Integer> weightFunction) {
            this.weightFunction = weightFunction;
            return this.self();
        }

        public B separationFunction(Function<LE<V, E>, Integer> separationFunction) {
            this.separationFunction = separationFunction;
            return this.self();
        }

        public B edgeComparator(Comparator<LE<V, E>> edgeComparator) {
            this.edgeComparator = edgeComparator;
            return this.self();
        }

        public T build() {
            return (T)new NetworkSimplex(this);
        }
    }
}

