/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.BigIntegerPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.lang.Language;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;

public class AsyncWrappedPcodeArithmetic<T>
implements PcodeArithmetic<CompletableFuture<T>> {
    public static final AsyncWrappedPcodeArithmetic<byte[]> BYTES_BE = new AsyncWrappedPcodeArithmetic(BytesPcodeArithmetic.BIG_ENDIAN);
    public static final AsyncWrappedPcodeArithmetic<byte[]> BYTES_LE = new AsyncWrappedPcodeArithmetic(BytesPcodeArithmetic.LITTLE_ENDIAN);
    @Deprecated(forRemoval=true)
    public static final AsyncWrappedPcodeArithmetic<BigInteger> BIGINT = new AsyncWrappedPcodeArithmetic(BigIntegerPcodeArithmetic.INSTANCE);
    private final PcodeArithmetic<T> arithmetic;

    public static AsyncWrappedPcodeArithmetic<byte[]> forEndian(boolean isBigEndian) {
        return isBigEndian ? BYTES_BE : BYTES_LE;
    }

    public static AsyncWrappedPcodeArithmetic<byte[]> forLanguage(Language language) {
        return AsyncWrappedPcodeArithmetic.forEndian(language.isBigEndian());
    }

    public AsyncWrappedPcodeArithmetic(PcodeArithmetic<T> arithmetic) {
        this.arithmetic = arithmetic;
    }

    public CompletableFuture<T> unaryOp(UnaryOpBehavior op, int sizeout, int sizein1, CompletableFuture<T> in1) {
        return in1.thenApply(t1 -> this.arithmetic.unaryOp(op, sizeout, sizein1, t1));
    }

    public CompletableFuture<T> binaryOp(BinaryOpBehavior op, int sizeout, int sizein1, CompletableFuture<T> in1, int sizein2, CompletableFuture<T> in2) {
        return in1.thenCombine(in2, (t1, t2) -> this.arithmetic.binaryOp(op, sizeout, sizein1, t1, sizein2, t2));
    }

    public CompletableFuture<T> fromConst(long value, int size) {
        return CompletableFuture.completedFuture(this.arithmetic.fromConst(value, size));
    }

    public CompletableFuture<T> fromConst(BigInteger value, int size, boolean isContextreg) {
        return CompletableFuture.completedFuture(this.arithmetic.fromConst(value, size, isContextreg));
    }

    public boolean isTrue(CompletableFuture<T> cond) {
        if (!cond.isDone()) {
            throw new AssertionError((Object)"You need a better 8-ball");
        }
        return this.arithmetic.isTrue(cond.getNow(null));
    }

    public BigInteger toConcrete(CompletableFuture<T> cond, boolean isContextreg) {
        if (!cond.isDone()) {
            throw new AssertionError((Object)"You need a better 8-ball");
        }
        return this.arithmetic.toConcrete(cond.getNow(null), isContextreg);
    }
}

