/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.TraceObjectManager;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.DebuggerCallbackReorderer;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import ghidra.util.datastruct.PrivatelyQueuedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class TraceObjectListener
implements DebuggerModelListener {
    private TraceObjectManager objectManager;
    private TargetObject target;
    protected boolean disposed = false;
    protected final NavigableMap<List<String>, TargetObject> initialized = new TreeMap<List<String>, TargetObject>((Comparator<List<String>>)PathUtils.PathComparator.KEYED);
    protected final DebuggerCallbackReorderer reorderer = new DebuggerCallbackReorderer((DebuggerModelListener)this);
    protected final PrivatelyQueuedListener<DebuggerModelListener> queue;

    public TraceObjectListener(TraceObjectManager manager) {
        this.objectManager = manager;
        this.target = this.objectManager.getTarget();
        DefaultTraceRecorder recorder = this.objectManager.getRecorder();
        this.queue = new PrivatelyQueuedListener(DebuggerModelListener.class, recorder.privateQueue, (Object)this.reorderer);
    }

    public CompletableFuture<Void> init() {
        return this.findInitialObjects(this.target).thenAccept(adds -> {
            for (TargetObject added : adds) {
                this.processInit(added);
            }
            DebuggerObjectModel model = this.target.getModel();
            model.addModelListener((DebuggerModelListener)this.queue.in, true);
        });
    }

    boolean matchesTarget(TargetObject object) {
        for (TargetObject proc = object; proc != null; proc = proc.getParent()) {
            if (proc == this.target) {
                return true;
            }
            if (!proc.getClass().equals(this.target.getClass())) continue;
            return false;
        }
        return true;
    }

    protected void processCreate(TargetObject added) {
        if (!this.objectManager.hasObject(added) && this.matchesTarget(added)) {
            this.objectManager.addObject(added);
            this.objectManager.createObject(added);
        }
    }

    protected void processInit(TargetObject added) {
        if (this.objectManager.hasObject(added) && !this.initialized.containsKey(added.getPath())) {
            this.initialized.put(added.getPath(), added);
            this.objectManager.initObject(added);
        }
    }

    protected void processRemove(TargetObject removed) {
        if (this.objectManager.hasObject(removed)) {
            this.objectManager.removeObject(removed);
            this.objectManager.removeObject(removed.getPath());
        }
    }

    protected void processAttributesChanged(TargetObject changed, Map<String, ?> added) {
        if (this.objectManager.hasObject(changed)) {
            this.objectManager.attributesChanged(changed, added);
        }
    }

    protected void processElementsChanged(TargetObject changed, Map<String, ?> added) {
        if (this.objectManager.hasObject(changed)) {
            this.objectManager.elementsChanged(changed, added);
        }
    }

    public void created(TargetObject object) {
        this.processCreate(object);
    }

    public void invalidated(TargetObject object, TargetObject branch, String reason) {
        this.processRemove(object);
    }

    public void attributesChanged(TargetObject parent, Collection<String> removed, Map<String, ?> added) {
        if (parent.isValid()) {
            this.processInit(parent);
            this.processAttributesChanged(parent, added);
        }
    }

    public void elementsChanged(TargetObject parent, Collection<String> removed, Map<String, ? extends TargetObject> added) {
        if (parent.isValid()) {
            this.processElementsChanged(parent, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetBreakpointLocation> collectBreakpoints(TargetThread thread) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objectManager.objects;
        synchronized (navigableMap) {
            return this.objectManager.collectBreakpoints(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProcessBreakpointContainers(Consumer<? super TargetBreakpointSpecContainer> action) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objectManager.objects;
        synchronized (navigableMap) {
            this.objectManager.onProcessBreakpointContainers(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onThreadBreakpointContainers(TargetThread thread, Consumer<? super TargetBreakpointSpecContainer> action) {
        NavigableMap<List<String>, TargetObject> navigableMap = this.objectManager.objects;
        synchronized (navigableMap) {
            this.objectManager.onThreadBreakpointContainers(thread, action);
        }
    }

    private CompletableFuture<List<TargetObject>> findInitialObjects(TargetObject target) {
        ArrayList<TargetObject> result = new ArrayList<TargetObject>();
        result.add(target);
        AsyncFence fence = new AsyncFence();
        CompletableFuture futureEvents = DebugModelConventions.findSuitable(TargetEventScope.class, (TargetObject)target);
        fence.include((CompletableFuture)((CompletableFuture)futureEvents.thenAccept(events -> {
            if (events != null) {
                result.add((TargetObject)events);
            }
        })).exceptionally(e -> {
            Msg.warn((Object)this, (Object)"Could not search for event scope", (Throwable)e);
            return null;
        }));
        CompletableFuture futureFocus = DebugModelConventions.findSuitable(TargetFocusScope.class, (TargetObject)target);
        fence.include((CompletableFuture)((CompletableFuture)futureFocus.thenAccept(focus -> {
            if (focus != null) {
                result.add((TargetObject)focus);
            }
        })).exceptionally(e -> {
            Msg.error((Object)this, (Object)"Could not search for focus scope", (Throwable)e);
            return null;
        }));
        return fence.ready().thenApply(__ -> result);
    }

    public void dispose() {
        this.target.getModel().removeModelListener((DebuggerModelListener)this.reorderer);
        this.reorderer.dispose();
    }
}

