/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import com.google.common.collect.Collections2;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.DebuggerLogicalBreakpointServicePlugin;
import ghidra.app.plugin.core.debug.service.breakpoint.PlaceBreakpointActionItem;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import utilities.util.IDHashed;

public interface LogicalBreakpointInternal
extends LogicalBreakpoint {
    public void setTraceAddress(TraceRecorder var1, Address var2);

    public boolean canMerge(Program var1, Bookmark var2);

    public boolean canMerge(TraceBreakpoint var1);

    public boolean trackBreakpoint(Bookmark var1);

    public boolean trackBreakpoint(TraceBreakpoint var1);

    public boolean untrackBreakpoint(TraceBreakpoint var1);

    public boolean untrackBreakpoint(Program var1, Bookmark var2);

    public void planEnable(BreakpointActionSet var1, Trace var2);

    public void planDisable(BreakpointActionSet var1, Trace var2);

    public void planDelete(BreakpointActionSet var1, Trace var2);

    public static class TraceBreakpointSet {
        private final TraceRecorder recorder;
        private final Trace trace;
        private final Address address;
        private Set<IDHashed<TraceBreakpoint>> breakpoints = new HashSet<IDHashed<TraceBreakpoint>>();

        public TraceBreakpointSet(TraceRecorder recorder, Address address) {
            this.recorder = recorder;
            this.trace = recorder.getTrace();
            this.address = address;
        }

        public String toString() {
            return String.format("<at %s in %s: %s>", this.address, this.trace.getName(), this.breakpoints);
        }

        public Trace getTrace() {
            return this.trace;
        }

        public Address getAddress() {
            return this.address;
        }

        public Address computeTargetAddress() {
            return this.recorder.getMemoryMapper().traceToTarget(this.address);
        }

        public LogicalBreakpoint.TraceEnablement computeEnablement() {
            LogicalBreakpoint.TraceEnablement en = LogicalBreakpoint.TraceEnablement.MISSING;
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                if ((en = en.combine(LogicalBreakpoint.TraceEnablement.fromBool(((TraceBreakpoint)bpt.obj).isEnabled()))) != LogicalBreakpoint.TraceEnablement.MIXED) continue;
                return en;
            }
            return en;
        }

        public boolean isEmpty() {
            return this.breakpoints.isEmpty();
        }

        public Collection<TraceBreakpoint> getBreakpoints() {
            return Collections2.transform(this.breakpoints, e -> (TraceBreakpoint)e.obj);
        }

        public boolean add(TraceBreakpoint bpt) {
            return this.breakpoints.add((IDHashed<TraceBreakpoint>)new IDHashed((Object)bpt));
        }

        public boolean canMerge(TraceBreakpoint bpt) {
            if (this.trace != bpt.getTrace()) {
                return false;
            }
            return this.address.equals((Object)bpt.getMinAddress());
        }

        public boolean remove(TraceBreakpoint bpt) {
            return this.breakpoints.remove(new IDHashed((Object)bpt));
        }

        public void planEnable(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
            if (this.breakpoints.isEmpty()) {
                Set<TargetBreakpointSpec.TargetBreakpointKind> tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
                for (TargetBreakpointSpecContainer cont : this.recorder.collectBreakpointContainers(null)) {
                    LinkedHashSet<TargetBreakpointSpec.TargetBreakpointKind> supKinds = new LinkedHashSet<TargetBreakpointSpec.TargetBreakpointKind>(tKinds);
                    supKinds.retainAll((Collection<?>)cont.getSupportedBreakpointKinds());
                    actions.add(new PlaceBreakpointActionItem(cont, this.computeTargetAddress(), length, supKinds));
                }
                return;
            }
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                TargetBreakpointLocation loc = this.recorder.getTargetBreakpoint((TraceBreakpoint)bpt.obj);
                if (loc == null) continue;
                actions.planEnable(loc);
            }
        }

        public void planDisable(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
            Set<TargetBreakpointSpec.TargetBreakpointKind> tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
            Address targetAddr = this.computeTargetAddress();
            for (TargetBreakpointLocation loc : this.recorder.collectBreakpoints(null)) {
                TargetBreakpointSpec spec;
                if (!targetAddr.equals((Object)loc.getAddress()) || length != loc.getLength().longValue() || !Objects.equals((spec = loc.getSpecification()).getKinds(), tKinds)) continue;
                actions.planDisable(loc);
            }
        }

        public void planDelete(BreakpointActionSet actions, long length, Set<TraceBreakpointKind> kinds) {
            Set<TargetBreakpointSpec.TargetBreakpointKind> tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
            Address targetAddr = this.computeTargetAddress();
            for (TargetBreakpointLocation loc : this.recorder.collectBreakpoints(null)) {
                TargetBreakpointSpec spec;
                if (!targetAddr.equals((Object)loc.getAddress()) || length != loc.getLength().longValue() || !Objects.equals((spec = loc.getSpecification()).getKinds(), tKinds)) continue;
                actions.planDelete(loc);
            }
        }
    }

    public static class ProgramBreakpoint {
        private final Program program;
        private final Address address;
        private final ProgramLocation location;
        private final long length;
        private final Set<TraceBreakpointKind> kinds;
        private Bookmark eBookmark;
        private Bookmark dBookmark;

        public static Set<TraceBreakpointKind> kindsFromBookmark(Bookmark mark) {
            String[] parts = mark.getCategory().split(";");
            TraceBreakpointKind.TraceBreakpointKindSet result = TraceBreakpointKind.TraceBreakpointKindSet.decode((String)parts[0], (boolean)false);
            if (result.isEmpty()) {
                Msg.warn(TraceBreakpointKind.class, (Object)"Decoded empty set of kinds from bookmark. Assuming SW_EXECUTE");
                return Set.of(TraceBreakpointKind.SW_EXECUTE);
            }
            return result;
        }

        public static long lengthFromBookmark(Bookmark mark) {
            String[] parts = mark.getCategory().split(";");
            if (parts.length < 2) {
                Msg.warn(DebuggerLogicalBreakpointServicePlugin.class, (Object)"No length for bookmark breakpoint. Assuming 1.");
                return 1L;
            }
            try {
                long length = Long.parseLong(parts[1]);
                if (length <= 0L) {
                    Msg.warn(DebuggerLogicalBreakpointServicePlugin.class, (Object)"Non-positive length for bookmark breakpoint? Using 1.");
                    return 1L;
                }
                return length;
            }
            catch (NumberFormatException e) {
                Msg.warn(DebuggerLogicalBreakpointServicePlugin.class, (Object)("Ill-formatted bookmark breakpoint length: " + e + ". Using 1."));
                return 1L;
            }
        }

        public ProgramBreakpoint(Program program, Address address, long length, Set<TraceBreakpointKind> kinds) {
            this.program = program;
            this.address = address;
            this.location = new ProgramLocation(program, address);
            this.length = length;
            this.kinds = kinds;
        }

        public String toString() {
            if (this.eBookmark != null) {
                return String.format("<enabled %s(%s) at %s in %s>", this.eBookmark.getTypeString(), this.eBookmark.getCategory(), this.eBookmark.getAddress(), this.program.getName());
            }
            if (this.dBookmark != null) {
                return String.format("<disabled %s(%s) at %s in %s>", this.dBookmark.getTypeString(), this.dBookmark.getCategory(), this.dBookmark.getAddress(), this.program.getName());
            }
            return String.format("<absent at %s in %s>", this.address, this.program.getName());
        }

        public ProgramLocation getLocation() {
            return this.location;
        }

        public LogicalBreakpoint.ProgramEnablement computeEnablement() {
            if (this.eBookmark != null) {
                return LogicalBreakpoint.ProgramEnablement.ENABLED;
            }
            if (this.dBookmark != null) {
                return LogicalBreakpoint.ProgramEnablement.DISABLED;
            }
            return LogicalBreakpoint.ProgramEnablement.MISSING;
        }

        public boolean isEmpty() {
            return this.eBookmark == null && this.dBookmark == null;
        }

        public void deleteFromProgram() {
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.program, (String)"Clear breakpoint", (boolean)false);){
                BookmarkManager bookmarkManager = this.program.getBookmarkManager();
                if (this.eBookmark != null) {
                    bookmarkManager.removeBookmark(this.eBookmark);
                }
                if (this.dBookmark != null) {
                    bookmarkManager.removeBookmark(this.dBookmark);
                }
                tid.commit();
            }
        }

        public boolean canMerge(Program candProgram, Bookmark candBookmark) {
            if (this.program != candProgram) {
                return false;
            }
            if (!this.address.equals((Object)candBookmark.getAddress())) {
                return false;
            }
            if (this.length != ProgramBreakpoint.lengthFromBookmark(candBookmark)) {
                return false;
            }
            return Objects.equals(this.kinds, ProgramBreakpoint.kindsFromBookmark(candBookmark));
        }

        public Program getProgram() {
            return this.program;
        }

        public boolean add(Bookmark bookmark) {
            if ("BreakpointEnabled".equals(bookmark.getTypeString())) {
                if (this.eBookmark == bookmark) {
                    return false;
                }
                this.eBookmark = bookmark;
                return true;
            }
            if ("BreakpointDisabled".equals(bookmark.getTypeString())) {
                if (this.dBookmark == bookmark) {
                    return false;
                }
                this.dBookmark = bookmark;
                return true;
            }
            return false;
        }

        public boolean remove(Bookmark bookmark) {
            if (this.eBookmark == bookmark) {
                this.eBookmark = null;
                return true;
            }
            if (this.dBookmark == bookmark) {
                this.dBookmark = null;
                return true;
            }
            return false;
        }

        public Bookmark getBookmark() {
            if (this.eBookmark != null) {
                return this.eBookmark;
            }
            return this.dBookmark;
        }

        public boolean isEnabled() {
            return this.computeEnablement() == LogicalBreakpoint.ProgramEnablement.ENABLED;
        }

        public boolean isDisabled() {
            return this.computeEnablement() == LogicalBreakpoint.ProgramEnablement.DISABLED;
        }

        public String computeCategory() {
            return TraceBreakpointKind.TraceBreakpointKindSet.encode(this.kinds) + ";" + Long.toUnsignedString(this.length);
        }

        public void enable() {
            if (this.isEnabled()) {
                return;
            }
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.program, (String)"Enable breakpoint", (boolean)false);){
                BookmarkManager manager = this.program.getBookmarkManager();
                String catStr = this.computeCategory();
                manager.setBookmark(this.address, "BreakpointEnabled", catStr, "");
                manager.removeBookmarks((AddressSetView)new AddressSet(this.address), "BreakpointDisabled", catStr, TaskMonitor.DUMMY);
                tid.commit();
            }
            catch (CancelledException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void disable() {
            if (this.isDisabled()) {
                return;
            }
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.program, (String)"Disable breakpoint", (boolean)false);){
                BookmarkManager manager = this.program.getBookmarkManager();
                String catStr = this.computeCategory();
                manager.setBookmark(this.address, "BreakpointDisabled", catStr, "");
                manager.removeBookmarks((AddressSetView)new AddressSet(this.address), "BreakpointEnabled", catStr, TaskMonitor.DUMMY);
                tid.commit();
            }
            catch (CancelledException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

