/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.thread.DebuggerThreadsProvider;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger registers manager", description="GUI to view and modify register values", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class, TraceActivatedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class})
public class DebuggerThreadsPlugin
extends AbstractDebuggerPlugin {
    protected DebuggerThreadsProvider provider;

    public DebuggerThreadsPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerThreadsProvider(this);
        super.init();
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        PluginEvent ev;
        super.processEvent(event);
        if (event instanceof TraceOpenedPluginEvent) {
            ev = (TraceOpenedPluginEvent)event;
            this.provider.traceOpened(ev.getTrace());
        }
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.provider.coordinatesActivated(ev.getActiveCoordinates());
        }
        if (event instanceof TraceClosedPluginEvent) {
            ev = (TraceClosedPluginEvent)event;
            this.provider.traceClosed(ev.getTrace());
        }
    }
}

