/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportExportAsAction;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

public class OpenWinDbgTraceAction
extends ImportExportAsAction {
    protected ImageIcon ICON_TRACE = ResourceManager.loadImage((String)"images/text-xml.png");
    private ActionContext context;

    public OpenWinDbgTraceAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("OpenTrace", tool, owner, provider);
        this.fileExt = ".run";
        this.fileMode = GhidraFileChooserMode.FILES_AND_DIRECTORIES;
        this.setMenuBarData(new MenuData(new String[]{this.IMPORT, "from trace"}, (Icon)this.ICON_TRACE, this.GROUP));
        this.setKeyBindingData(new KeyBindingData(84, 512));
        this.setHelpLocation(new HelpLocation(owner, "open_trace"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        this.context = context;
        return this.provider.isInstance(context, TargetLauncher.class);
    }

    @Override
    protected void doAction(ObjectContainer container, final File f) {
        if (f == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] args = new String[]{".opendump", f.getAbsolutePath()};
                AtomicReference launcher = new AtomicReference();
                AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> {
                    TargetObject obj = OpenWinDbgTraceAction.this.provider.getObjectFromContext(OpenWinDbgTraceAction.this.context);
                    DebugModelConventions.findSuitable(TargetLauncher.class, (TargetObject)obj).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1));
                }, launcher).then(seq -> {
                    ((TargetLauncher)launcher.get()).launch(Map.of("args", args)).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1));
                    seq.exit();
                }).finish();
            }
        });
    }
}

