/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import com.google.common.collect.Range;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerBlockChooserDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerMissingModuleActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.ModuleRow;
import ghidra.app.plugin.core.debug.gui.modules.SectionRow;
import ghidra.app.plugin.core.debug.service.modules.MapModulesBackgroundCommand;
import ghidra.app.plugin.core.debug.service.modules.MapSectionsBackgroundCommand;
import ghidra.app.plugin.core.debug.utils.BackgroundUtils;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Project;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceObject;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.database.ObjectKey;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerModulesProvider
extends ComponentProviderAdapter {
    private final DebuggerModulesPlugin plugin;
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    ProgramManager programManager;
    @AutoServiceConsumed
    private GoToService goToService;
    @AutoServiceConsumed
    private FileImporterService importerService;
    private final AutoService.Wiring autoServiceWiring;
    Trace currentTrace;
    private final ModulesListener modulesListener = new ModulesListener();
    private final RecordersChangedListener recordersChangedListener = new RecordersChangedListener();
    protected final ModuleTableModel moduleTableModel = new ModuleTableModel();
    protected GhidraTable moduleTable;
    private GhidraTableFilterPanel<ModuleRow> moduleFilterPanel;
    protected final SectionTableModel sectionTableModel = new SectionTableModel();
    protected GhidraTable sectionTable;
    protected GhidraTableFilterPanel<SectionRow> sectionFilterPanel;
    private final SectionsBySelectedModulesTableFilter filterSectionsBySelectedModules = new SectionsBySelectedModulesTableFilter();
    private final JSplitPane mainPanel = new JSplitPane(0);
    private final DebuggerBlockChooserDialog blockChooserDialog;
    private final DebuggerModuleMapProposalDialog moduleProposalDialog;
    private final DebuggerSectionMapProposalDialog sectionProposalDialog;
    private DataTreeDialog programChooserDialog;
    private ActionContext myActionContext;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    DockingAction actionMapIdentically;
    DockingAction actionMapModules;
    DockingAction actionMapModuleTo;
    DockingAction actionMapSections;
    DockingAction actionMapSectionTo;
    DockingAction actionMapSectionsTo;
    DockingAction actionImportMissingModule;
    DockingAction actionMapMissingModule;
    SelectAddressesAction actionSelectAddresses;
    CaptureTypesAction actionCaptureTypes;
    CaptureSymbolsAction actionCaptureSymbols;
    ImportFromFileSystemAction actionImportFromFileSystem;
    ToggleDockingAction actionFilterSectionsByModules;
    DockingAction actionSelectCurrent;

    protected static ModuleRow getSelectedModuleRow(ActionContext context) {
        if (!(context instanceof DebuggerModuleActionContext)) {
            return null;
        }
        DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
        Set<ModuleRow> modules = ctx.getSelectedModules();
        if (modules.size() != 1) {
            return null;
        }
        return modules.iterator().next();
    }

    protected static SectionRow getSelectedSectionRow(ActionContext context) {
        if (!(context instanceof DebuggerSectionActionContext)) {
            return null;
        }
        DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)context;
        Set<SectionRow> sections = ctx.getSelectedSections();
        if (sections.size() != 1) {
            return null;
        }
        return sections.iterator().next();
    }

    protected static Set<TraceModule> getSelectedModulesFromModuleContext(DebuggerModuleActionContext context) {
        return context.getSelectedModules().stream().map(r -> r.getModule()).collect(Collectors.toSet());
    }

    protected static Set<TraceModule> getSelectedModulesFromSectionContext(DebuggerSectionActionContext context) {
        return context.getSelectedSections().stream().map(r -> r.getModule()).collect(Collectors.toSet());
    }

    protected static Set<TraceSection> getSelectedSectionsFromModuleContext(DebuggerModuleActionContext context) {
        return context.getSelectedModules().stream().flatMap(r -> r.getModule().getSections().stream()).collect(Collectors.toSet());
    }

    protected static Set<TraceSection> getSelectedSectionsFromSectionContext(DebuggerSectionActionContext context) {
        return context.getSelectedSections().stream().map(r -> r.getSection()).collect(Collectors.toSet());
    }

    protected static Set<TraceModule> getSelectedModules(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            return DebuggerModulesProvider.getSelectedModulesFromModuleContext((DebuggerModuleActionContext)context);
        }
        if (context instanceof DebuggerSectionActionContext) {
            return DebuggerModulesProvider.getSelectedModulesFromSectionContext((DebuggerSectionActionContext)context);
        }
        return null;
    }

    protected static Set<TraceSection> getSelectedSections(ActionContext context) {
        if (context instanceof DebuggerModuleActionContext) {
            return DebuggerModulesProvider.getSelectedSectionsFromModuleContext((DebuggerModuleActionContext)context);
        }
        if (context instanceof DebuggerSectionActionContext) {
            return DebuggerModulesProvider.getSelectedSectionsFromSectionContext((DebuggerSectionActionContext)context);
        }
        return null;
    }

    public DebuggerModulesProvider(DebuggerModulesPlugin plugin) {
        super(plugin.getTool(), "Modules", plugin.getName(), null);
        this.plugin = plugin;
        this.setIcon(DebuggerResources.ICON_PROVIDER_MODULES);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MODULES);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.blockChooserDialog = new DebuggerBlockChooserDialog();
        this.moduleProposalDialog = new DebuggerModuleMapProposalDialog(this);
        this.sectionProposalDialog = new DebuggerSectionMapProposalDialog(this);
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.setVisible(true);
        this.createActions();
    }

    private void importModuleFromFileSystem(TraceModule module) {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setSelectedFile(new File(module.getName()));
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        Project activeProject = Objects.requireNonNull(AppInfo.getActiveProject());
        DomainFolder root = activeProject.getProjectData().getRootFolder();
        this.importerService.importFile(root, file);
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeTraceRecordersChangedListener(this.recordersChangedListener);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addTraceRecordersChangedListener(this.recordersChangedListener);
        }
        this.contextChanged();
    }

    @AutoServiceConsumed
    private void setConsoleService(DebuggerConsoleService consoleService) {
        if (consoleService != null) {
            if (this.actionImportMissingModule != null) {
                consoleService.addResolutionAction((DockingActionIf)this.actionImportMissingModule);
            }
            if (this.actionMapMissingModule != null) {
                consoleService.addResolutionAction((DockingActionIf)this.actionMapMissingModule);
            }
        }
    }

    protected void dispose() {
        if (this.consoleService != null) {
            if (this.actionImportMissingModule != null) {
                this.consoleService.removeResolutionAction((DockingActionIf)this.actionImportMissingModule);
            }
            if (this.actionMapMissingModule != null) {
                this.consoleService.removeResolutionAction((DockingActionIf)this.actionMapMissingModule);
            }
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    private void loadModules() {
        this.moduleTableModel.clear();
        this.sectionTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceModuleManager moduleManager = this.currentTrace.getModuleManager();
        this.moduleTableModel.addAllItems(moduleManager.getAllModules());
        this.sectionTableModel.addAllItems(moduleManager.getAllSections());
    }

    protected void buildMainPanel() {
        this.mainPanel.setContinuousLayout(true);
        JPanel modulePanel = new JPanel(new BorderLayout());
        this.moduleTable = new GhidraTable((TableModel)((Object)this.moduleTableModel));
        this.moduleTable.setSelectionMode(2);
        modulePanel.add(new JScrollPane((Component)this.moduleTable));
        this.moduleFilterPanel = new GhidraTableFilterPanel((JTable)this.moduleTable, (RowObjectTableModel)this.moduleTableModel);
        modulePanel.add((Component)this.moduleFilterPanel, "South");
        this.mainPanel.setLeftComponent(modulePanel);
        JPanel sectionPanel = new JPanel(new BorderLayout());
        this.sectionTable = new GhidraTable((TableModel)((Object)this.sectionTableModel));
        this.sectionTable.setSelectionMode(2);
        sectionPanel.add(new JScrollPane((Component)this.sectionTable));
        this.sectionFilterPanel = new GhidraTableFilterPanel((JTable)this.sectionTable, (RowObjectTableModel)this.sectionTableModel);
        sectionPanel.add((Component)this.sectionFilterPanel, "South");
        this.mainPanel.setRightComponent(sectionPanel);
        this.mainPanel.setResizeWeight(0.5);
        this.moduleTable.getSelectionModel().addListSelectionListener(evt -> {
            this.myActionContext = new DebuggerModuleActionContext(this, this.moduleFilterPanel.getSelectedItems(), (GTable)this.moduleTable);
            this.contextChanged();
            if (this.actionFilterSectionsByModules.isSelected()) {
                this.sectionTableModel.fireTableDataChanged();
            }
        });
        this.moduleTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerModulesProvider.this.navigateToSelectedModule();
                }
            }
        });
        this.sectionTable.getSelectionModel().addListSelectionListener(evt -> {
            this.myActionContext = new DebuggerSectionActionContext(this, this.sectionFilterPanel.getSelectedItems(), (GTable)this.sectionTable);
            this.contextChanged();
        });
        this.sectionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerModulesProvider.this.navigateToSelectedSection();
                }
            }
        });
        this.sectionTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerModulesProvider.this.navigateToSelectedSection();
                }
            }
        });
        TableColumnModel modColModel = this.moduleTable.getColumnModel();
        TableColumn baseCol = modColModel.getColumn(ModuleTableColumns.BASE.ordinal());
        baseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn maxCol = modColModel.getColumn(ModuleTableColumns.MAX.ordinal());
        maxCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn mLenCol = modColModel.getColumn(ModuleTableColumns.LENGTH.ordinal());
        mLenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
        TableColumnModel secColModel = this.sectionTable.getColumnModel();
        TableColumn startCol = secColModel.getColumn(SectionTableColumns.START.ordinal());
        startCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn endCol = secColModel.getColumn(SectionTableColumns.END.ordinal());
        endCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn sLenCol = secColModel.getColumn(SectionTableColumns.LENGTH.ordinal());
        sLenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    protected void navigateToSelectedModule() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.listingService != null && (value = this.moduleTable.getValueAt(selectedRow = this.moduleTable.getSelectedRow(), selectedColumn = this.moduleTable.getSelectedColumn())) instanceof Address) {
            this.listingService.goTo((Address)value, true);
        }
    }

    protected void navigateToSelectedSection() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.listingService != null && (value = this.sectionTable.getValueAt(selectedRow = this.sectionTable.getSelectedRow(), selectedColumn = this.sectionTable.getSelectedColumn())) instanceof Address) {
            this.listingService.goTo((Address)value, true);
        }
    }

    protected void createActions() {
        this.actionMapIdentically = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.MapIdenticallyAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.currentTrace != null)).onAction(this::activatedMapIdentically)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapModules = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.MapModulesAction.builder(this.plugin).enabledWhen(this::isContextNonEmpty)).popupWhen(this::isContextNonEmpty)).onAction(this::activatedMapModules)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapModuleTo = (DockingAction)((ActionBuilder)DebuggerResources.MapModuleToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null)).withContext(DebuggerModuleActionContext.class).popupWhen(ctx -> this.currentProgram != null && ctx.getSelectedModules().size() == 1).onAction(this::activatedMapModuleTo).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapSections = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.MapSectionsAction.builder(this.plugin).enabledWhen(this::isContextNonEmpty)).popupWhen(this::isContextNonEmpty)).onAction(this::activatedMapSections)).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapSectionTo = (DockingAction)((ActionBuilder)DebuggerResources.MapSectionToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null)).withContext(DebuggerSectionActionContext.class).popupWhen(ctx -> this.currentProgram != null && ctx.getSelectedSections().size() == 1).onAction(this::activatedMapSectionTo).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapSectionsTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.MapSectionsToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null)).popupWhen(ctx -> this.currentProgram != null && this.isContextSectionsOfOneModule((ActionContext)ctx))).onAction(this::activatedMapSectionsTo)).buildAndInstallLocal((ComponentProvider)this);
        this.actionImportMissingModule = (DockingAction)DebuggerResources.ImportMissingModuleAction.builder(this.plugin).withContext(DebuggerMissingModuleActionContext.class).onAction(this::activatedImportMissingModule).build();
        this.actionMapMissingModule = (DockingAction)DebuggerResources.MapMissingModuleAction.builder(this.plugin).withContext(DebuggerMissingModuleActionContext.class).onAction(this::activatedMapMissingModule).build();
        this.actionSelectAddresses = new SelectAddressesAction();
        this.actionCaptureTypes = new CaptureTypesAction();
        this.actionCaptureSymbols = new CaptureSymbolsAction();
        this.actionImportFromFileSystem = new ImportFromFileSystemAction();
        this.actionFilterSectionsByModules = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.FilterAction.builder(this.plugin).description("Filter sections to those in selected modules")).helpLocation(new HelpLocation(this.plugin.getName(), "filter_by_module"))).onAction(this::toggledFilter)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectCurrent = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).enabledWhen(ctx -> this.currentTrace != null)).description("Select modules and sections by trace selection")).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.contextChanged();
    }

    private boolean isContextNonEmpty(ActionContext ignored) {
        if (this.myActionContext instanceof DebuggerModuleActionContext) {
            DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)this.myActionContext;
            return !ctx.getSelectedModules().isEmpty();
        }
        if (this.myActionContext instanceof DebuggerSectionActionContext) {
            DebuggerSectionActionContext ctx = (DebuggerSectionActionContext)this.myActionContext;
            return !ctx.getSelectedSections().isEmpty();
        }
        return false;
    }

    private boolean isContextSectionsOfOneModule(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        return sel.stream().map(TraceSection::getModule).distinct().count() == 1L;
    }

    private void activatedMapIdentically(ActionContext ignored) {
        if (this.currentProgram == null || this.currentTrace == null) {
            return;
        }
        this.staticMappingService.addIdentityMapping(this.currentTrace, this.currentProgram, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.traceManager.getCurrentSnap())), true);
    }

    private void activatedMapModules(ActionContext ignored) {
        Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapModules(sel);
    }

    private void activatedMapModuleTo(ActionContext ignored) {
        Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(this.myActionContext);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapModuleTo(sel.iterator().next());
    }

    private void activatedMapSections(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapSections(sel);
    }

    private void activatedMapSectionsTo(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapSectionsTo(sel);
    }

    private void activatedMapSectionTo(ActionContext ignored) {
        Set<TraceSection> sel = DebuggerModulesProvider.getSelectedSections(this.myActionContext);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapSectionTo(sel.iterator().next());
    }

    private void activatedImportMissingModule(DebuggerMissingModuleActionContext context) {
        if (this.importerService == null) {
            Msg.error((Object)((Object)this), (Object)"Import service is not present");
        }
        this.importModuleFromFileSystem(context.getModule());
        this.consoleService.removeFromLog(context);
    }

    private void activatedMapMissingModule(DebuggerMissingModuleActionContext context) {
        this.mapModuleTo(context.getModule());
        this.consoleService.removeFromLog(context);
    }

    private void toggledFilter(ActionContext ignored) {
        if (this.actionFilterSectionsByModules.isSelected()) {
            this.sectionFilterPanel.setSecondaryFilter((TableFilter)this.filterSectionsBySelectedModules);
        } else {
            this.sectionFilterPanel.setSecondaryFilter(null);
        }
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        if (this.listingService == null || this.traceManager == null || this.currentTrace == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceModuleManager moduleManager = this.currentTrace.getModuleManager();
        if (progSel != null && !progSel.isEmpty()) {
            long snap = this.traceManager.getCurrentSnap();
            HashSet<TraceModule> modSel = new HashSet<TraceModule>();
            HashSet<TraceSection> sectionSel = new HashSet<TraceSection>();
            for (AddressRange range : progSel) {
                for (TraceModule module : moduleManager.getModulesIntersecting(Range.singleton((Comparable)Long.valueOf(snap)), range)) {
                    if (!module.getSections().isEmpty()) continue;
                    modSel.add(module);
                }
                for (TraceSection section : moduleManager.getSectionsIntersecting(Range.singleton((Comparable)Long.valueOf(snap)), range)) {
                    sectionSel.add(section);
                    modSel.add(section.getModule());
                }
            }
            this.setSelectedModules(modSel);
            this.setSelectedSections(sectionSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null) {
            Address address = progLoc.getAddress();
            Set<TraceSection> sectionsAt = Set.copyOf(moduleManager.getSectionsAt(this.traceManager.getCurrentSnap(), address));
            if (!sectionsAt.isEmpty()) {
                Set<TraceModule> modulesAt = sectionsAt.stream().map(TraceSection::getModule).collect(Collectors.toSet());
                this.setSelectedModules(modulesAt);
                this.setSelectedSections(sectionsAt);
                return;
            }
            TraceModule bestModule = null;
            for (TraceModule module : moduleManager.getLoadedModules(this.traceManager.getCurrentSnap())) {
                Address base = module.getBase();
                if (base == null || base.getAddressSpace() != address.getAddressSpace()) continue;
                if (bestModule == null) {
                    bestModule = module;
                    continue;
                }
                if (base.compareTo((Object)address) > 0 || base.compareTo((Object)bestModule.getBase()) <= 0) continue;
                bestModule = module;
            }
            if (bestModule.getSections().isEmpty()) {
                this.setSelectedModules(Set.of(bestModule));
                return;
            }
        }
    }

    private boolean isCaptureApplicable(ActionContext context) {
        if (this.modelService == null) {
            return false;
        }
        if (!(context instanceof DebuggerModuleActionContext)) {
            return false;
        }
        DebuggerModuleActionContext ctx = (DebuggerModuleActionContext)context;
        if (ctx.getSelectedModules().isEmpty()) {
            return false;
        }
        if (this.currentTrace == null) {
            return false;
        }
        TraceRecorder recorder = this.modelService.getRecorder(this.currentTrace);
        return recorder != null;
    }

    protected void promptModuleProposal(Collection<DebuggerStaticMappingService.ModuleMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Modules", (Object)"Could not formulate a proposal for any selected module. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<DebuggerStaticMappingService.ModuleMapEntry> adjusted = this.moduleProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapModulesBackgroundCommand(this.staticMappingService, adjusted), (UndoableDomainObject)this.currentTrace);
    }

    protected void mapModules(Set<TraceModule> modules) {
        if (this.staticMappingService == null) {
            return;
        }
        Map<TraceModule, DebuggerStaticMappingService.ModuleMapProposal> map = this.staticMappingService.proposeModuleMaps(modules, List.of(this.programManager.getAllOpenPrograms()));
        Collection<DebuggerStaticMappingService.ModuleMapEntry> proposal = DebuggerStaticMappingService.ModuleMapProposal.flatten(map.values());
        this.promptModuleProposal(proposal);
    }

    protected void mapModuleTo(TraceModule module) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        DebuggerStaticMappingService.ModuleMapProposal proposal = this.staticMappingService.proposeModuleMap(module, program);
        Map<TraceModule, DebuggerStaticMappingService.ModuleMapEntry> map = proposal.computeMap();
        this.promptModuleProposal(map.values());
    }

    protected void promptSectionProposal(Collection<DebuggerStaticMappingService.SectionMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Sections", (Object)"Could not formulate a proposal for any selected section. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<DebuggerStaticMappingService.SectionMapEntry> adjusted = this.sectionProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapSectionsBackgroundCommand(this.staticMappingService, adjusted), (UndoableDomainObject)this.currentTrace);
    }

    protected void mapSections(Set<TraceSection> sections) {
        if (this.staticMappingService == null) {
            return;
        }
        Set modules = sections.stream().map(TraceSection::getModule).collect(Collectors.toSet());
        Map<TraceModule, DebuggerStaticMappingService.SectionMapProposal> map = this.staticMappingService.proposeSectionMaps(modules, List.of(this.programManager.getAllOpenPrograms()));
        Collection<DebuggerStaticMappingService.SectionMapEntry> proposal = DebuggerStaticMappingService.SectionMapProposal.flatten(map.values());
        Collection filtered = proposal.stream().filter(e -> sections.contains(e.getSection())).collect(Collectors.toSet());
        this.promptSectionProposal(filtered);
    }

    protected void mapSectionsTo(Set<TraceSection> sections) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        Set modules = sections.stream().map(TraceSection::getModule).collect(Collectors.toSet());
        if (modules.size() != 1) {
            return;
        }
        TraceModule module = (TraceModule)modules.iterator().next();
        DebuggerStaticMappingService.SectionMapProposal map = this.staticMappingService.proposeSectionMap(module, program);
        Collection<DebuggerStaticMappingService.SectionMapEntry> proposal = map.computeMap().values();
        Collection filtered = proposal.stream().filter(e -> sections.contains(e.getSection())).collect(Collectors.toSet());
        this.promptSectionProposal(filtered);
    }

    protected void mapSectionTo(TraceSection section) {
        if (this.staticMappingService == null) {
            return;
        }
        ProgramLocation location = this.currentLocation;
        MemoryBlock block = DebuggerModulesProvider.computeBlock(location);
        if (block == null) {
            return;
        }
        this.promptSectionProposal(List.of(new DebuggerStaticMappingService.SectionMapEntry(section, location.getProgram(), block)));
    }

    protected Set<MemoryBlock> collectBlocksInOpenPrograms() {
        HashSet<MemoryBlock> result = new HashSet<MemoryBlock>();
        for (Program p : this.programManager.getAllOpenPrograms()) {
            if (p instanceof Trace) continue;
            result.addAll(List.of(p.getMemory().getBlocks()));
        }
        return result;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setProgram(Program program) {
        this.currentProgram = program;
        String name = program == null ? "..." : program.getName();
        this.actionMapModuleTo.getPopupMenuData().setMenuItemName("Map Module to " + name);
        this.actionMapSectionsTo.getPopupMenuData().setMenuItemName("Map Sections to " + name);
    }

    public static MemoryBlock computeBlock(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        Program program = location.getProgram();
        if (program == null) {
            return null;
        }
        Address addr = location.getAddress();
        if (addr == null) {
            return null;
        }
        return program.getMemory().getBlock(addr);
    }

    public static String computeBlockName(ProgramLocation location) {
        MemoryBlock block = DebuggerModulesProvider.computeBlock(location);
        if (block == null) {
            return "...";
        }
        return location.getProgram().getName() + ":" + block.getName();
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
        String name = "Map Section to " + DebuggerModulesProvider.computeBlockName(location);
        this.actionMapSectionTo.getPopupMenuData().setMenuItemName(name);
    }

    public void programClosed(Program program) {
        if (this.currentProgram == program) {
            this.currentProgram = null;
        }
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadModules();
        this.contextChanged();
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.modulesListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.modulesListener);
    }

    public void setSelectedModules(Set<TraceModule> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((ModuleTableModel)this.moduleTableModel).getRow(arg_0), (GTable)this.moduleTable, this.moduleTableModel, this.moduleFilterPanel);
    }

    public void setSelectedSections(Set<TraceSection> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((SectionTableModel)this.sectionTableModel).getRow(arg_0), (GTable)this.sectionTable, this.sectionTableModel, this.sectionFilterPanel);
    }

    private DataTreeDialog getProgramChooserDialog() {
        if (this.programChooserDialog != null) {
            return this.programChooserDialog;
        }
        DomainFileFilter filter = df -> Program.class.isAssignableFrom(df.getDomainObjectClass());
        this.programChooserDialog = new DataTreeDialog(null, "Map Module to Program", 0, filter){
            {
                this.dialogShown();
            }
        };
        return this.programChooserDialog;
    }

    public DomainFile askProgram(Program program) {
        this.getProgramChooserDialog();
        if (program != null) {
            this.programChooserDialog.selectDomainFile(program.getDomainFile());
        }
        this.tool.showDialog((DialogComponentProvider)this.programChooserDialog);
        return this.programChooserDialog.getDomainFile();
    }

    public Map.Entry<Program, MemoryBlock> askBlock(TraceSection section, Program program, MemoryBlock block) {
        if (this.programManager == null) {
            Msg.warn((Object)((Object)this), (Object)"No program manager!");
            return null;
        }
        return this.blockChooserDialog.chooseBlock(this.getTool(), section, List.of(this.programManager.getAllOpenPrograms()));
    }

    class SectionsBySelectedModulesTableFilter
    implements TableFilter<SectionRow> {
        SectionsBySelectedModulesTableFilter() {
        }

        public boolean acceptsRow(SectionRow sectionRow) {
            List selModuleRows = DebuggerModulesProvider.this.moduleFilterPanel.getSelectedItems();
            if (selModuleRows == null || selModuleRows.isEmpty()) {
                return true;
            }
            for (ModuleRow moduleRow : selModuleRows) {
                if (moduleRow.getModule() != sectionRow.getModule()) continue;
                return true;
            }
            return false;
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            return false;
        }
    }

    protected class ImportFromFileSystemAction
    extends DebuggerResources.AbstractImportFromFileSystemAction {
        public static final String GROUP = "Dbg1. General";

        public ImportFromFileSystemAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setPopupMenuData(new MenuData(new String[]{"Import From File System"}, GROUP));
            DebuggerModulesProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerModulesProvider.this.importerService == null) {
                return;
            }
            Set<TraceModule> modules = DebuggerModulesProvider.getSelectedModules(DebuggerModulesProvider.this.myActionContext);
            if (modules == null || modules.size() != 1) {
                return;
            }
            TraceModule mod = modules.iterator().next();
            DebuggerModulesProvider.this.importModuleFromFileSystem(mod);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Set<TraceModule> sel = DebuggerModulesProvider.getSelectedModules(DebuggerModulesProvider.this.myActionContext);
            return DebuggerModulesProvider.this.importerService != null && sel != null && sel.size() == 1;
        }
    }

    protected class CaptureSymbolsAction
    extends DebuggerResources.AbstractCaptureSymbolsAction {
        public static final String GROUP = "Dbg8. Maintenance";

        public CaptureSymbolsAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Capture Symbols"}, GROUP));
            DebuggerModulesProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            Set<TraceModule> modules = DebuggerModulesProvider.getSelectedModules(DebuggerModulesProvider.this.myActionContext);
            if (modules == null) {
                return;
            }
            TraceRecorder recorder = DebuggerModulesProvider.this.modelService.getRecorder(DebuggerModulesProvider.this.currentTrace);
            BackgroundUtils.async(DebuggerModulesProvider.this.tool, DebuggerModulesProvider.this.currentTrace, "Capture Symbols", true, true, false, (__, monitor) -> AsyncUtils.each((TypeSpec)TypeSpec.VOID, modules.iterator(), (m, loop) -> {
                if (recorder.getTargetModule((TraceModule)m) == null) {
                    loop.repeatWhile(!monitor.isCancelled());
                } else {
                    ((CompletableFuture)recorder.captureSymbols((TraceModule)m, (TaskMonitor)monitor).thenApply(v -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)loop).repeatWhile(arg_0, arg_1));
                }
            }));
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerModulesProvider.this.isCaptureApplicable(DebuggerModulesProvider.this.myActionContext);
        }
    }

    protected class CaptureTypesAction
    extends DebuggerResources.AbstractCaptureTypesAction {
        public static final String GROUP = "Dbg1. General";

        public CaptureTypesAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Capture Data Types"}, GROUP));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            Set<TraceModule> modules = DebuggerModulesProvider.getSelectedModules(DebuggerModulesProvider.this.myActionContext);
            if (modules == null) {
                return;
            }
            TraceRecorder recorder = DebuggerModulesProvider.this.modelService.getRecorder(DebuggerModulesProvider.this.currentTrace);
            BackgroundUtils.async(DebuggerModulesProvider.this.tool, DebuggerModulesProvider.this.currentTrace, "Capture Types", true, true, false, (__, monitor) -> AsyncUtils.each((TypeSpec)TypeSpec.VOID, modules.iterator(), (m, loop) -> {
                if (recorder.getTargetModule((TraceModule)m) == null) {
                    loop.repeatWhile(!monitor.isCancelled());
                } else {
                    ((CompletableFuture)recorder.captureDataTypes((TraceModule)m, (TaskMonitor)monitor).thenApply(v -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)loop).repeatWhile(arg_0, arg_1));
                }
            }));
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerModulesProvider.this.isCaptureApplicable(DebuggerModulesProvider.this.myActionContext);
        }
    }

    protected class SelectAddressesAction
    extends DebuggerResources.AbstractSelectAddressesAction {
        public static final String GROUP = "Dbg1. General";

        public SelectAddressesAction() {
            super(DebuggerModulesProvider.this.plugin);
            this.setDescription("Select addresses contained in modules or sections");
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, GROUP));
            DebuggerModulesProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerModulesProvider.this.listingService == null) {
                return;
            }
            AddressSet sel = new AddressSet();
            if (DebuggerModulesProvider.this.myActionContext instanceof DebuggerModuleActionContext) {
                DebuggerModuleActionContext mCtx = (DebuggerModuleActionContext)DebuggerModulesProvider.this.myActionContext;
                for (TraceModule module : DebuggerModulesProvider.getSelectedModulesFromModuleContext(mCtx)) {
                    sel.add(module.getRange());
                }
            } else if (DebuggerModulesProvider.this.myActionContext instanceof DebuggerSectionActionContext) {
                DebuggerSectionActionContext sCtx = (DebuggerSectionActionContext)DebuggerModulesProvider.this.myActionContext;
                for (TraceSection section : DebuggerModulesProvider.getSelectedSectionsFromSectionContext(sCtx)) {
                    sel.add(section.getRange());
                }
            }
            sel = sel.intersect((AddressSetView)DebuggerModulesProvider.this.traceManager.getCurrentView().getMemory());
            ProgramSelection ps = new ProgramSelection((AddressSetView)sel);
            DebuggerModulesProvider.this.listingService.setCurrentSelection(ps);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return DebuggerModulesProvider.this.isContextNonEmpty(context);
        }
    }

    protected class RecordersChangedListener
    implements CollectionChangeListener<TraceRecorder> {
        protected RecordersChangedListener() {
        }

        public void elementAdded(TraceRecorder element) {
            DebuggerModulesProvider.this.contextChanged();
        }

        public void elementRemoved(TraceRecorder element) {
            DebuggerModulesProvider.this.contextChanged();
        }

        public void elementModified(TraceRecorder element) {
            DebuggerModulesProvider.this.contextChanged();
        }
    }

    private class ModulesListener
    extends TraceDomainObjectListener {
        public ModulesListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.ADDED, this::moduleAdded);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.CHANGED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.LIFESPAN_CHANGED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.DELETED, this::moduleDeleted);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.ADDED, this::sectionAdded);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.CHANGED, this::sectionChanged);
            this.listenFor((TraceChangeType)Trace.TraceSectionChangeType.DELETED, this::sectionDeleted);
        }

        private void objectRestored() {
            DebuggerModulesProvider.this.loadModules();
        }

        private void moduleAdded(TraceModule module) {
            DebuggerModulesProvider.this.moduleTableModel.addItem(module);
        }

        private void moduleChanged(TraceModule module) {
            DebuggerModulesProvider.this.moduleTableModel.updateItem(module);
            DebuggerModulesProvider.this.sectionTableModel.fireTableDataChanged();
        }

        private void moduleDeleted(TraceModule module) {
            DebuggerModulesProvider.this.moduleTableModel.deleteItem(module);
            DebuggerModulesProvider.this.sectionTableModel.deleteAllItems(DebuggerModulesProvider.this.sectionTableModel.getMap().values().stream().filter(r -> r.getModule() == module).map(r -> r.getSection()).collect(Collectors.toList()));
        }

        private void sectionAdded(TraceSection section) {
            DebuggerModulesProvider.this.sectionTableModel.addItem(section);
        }

        private void sectionChanged(TraceSection section) {
            DebuggerModulesProvider.this.sectionTableModel.updateItem(section);
        }

        private void sectionDeleted(TraceSection section) {
            DebuggerModulesProvider.this.sectionTableModel.deleteItem(section);
        }
    }

    protected static class SectionTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<SectionTableColumns, ObjectKey, SectionRow, TraceSection> {
        public SectionTableModel() {
            super("Sections", SectionTableColumns.class, TraceObject::getObjectKey, SectionRow::new);
        }
    }

    protected static class ModuleTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<ModuleTableColumns, ObjectKey, ModuleRow, TraceModule> {
        public ModuleTableModel() {
            super("Modules", ModuleTableColumns.class, TraceObject::getObjectKey, ModuleRow::new);
        }
    }

    protected static enum SectionTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<SectionTableColumns, SectionRow>
    {
        START("Start Address", Address.class, SectionRow::getStart),
        END("End Address", Address.class, SectionRow::getEnd),
        NAME("Section Name", String.class, SectionRow::getName, SectionRow::setName),
        MODULE("Module Name", String.class, SectionRow::getModuleName),
        LENGTH("Length", Long.class, SectionRow::getLength);

        private final String header;
        private final Function<SectionRow, ?> getter;
        private final BiConsumer<SectionRow, Object> setter;
        private final Class<?> cls;

        private <T> SectionTableColumns(String header, Class<T> cls, Function<SectionRow, T> getter, BiConsumer<SectionRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> SectionTableColumns(String header, Class<T> cls, Function<SectionRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(SectionRow row) {
            return this.setter != null;
        }

        public void setValueOf(SectionRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(SectionRow row) {
            return this.getter.apply(row);
        }
    }

    protected static enum ModuleTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<ModuleTableColumns, ModuleRow>
    {
        BASE("Base Address", Address.class, ModuleRow::getBase),
        MAX("Max Address", Address.class, ModuleRow::getMaxAddress),
        SHORT_NAME("Name", String.class, ModuleRow::getShortName),
        NAME("Module Name", String.class, ModuleRow::getName, ModuleRow::setName),
        LIFESPAN("Lifespan", Range.class, ModuleRow::getLifespan),
        LENGTH("Length", Long.class, ModuleRow::getLength);

        private final String header;
        private final Function<ModuleRow, ?> getter;
        private final BiConsumer<ModuleRow, Object> setter;
        private final Class<?> cls;

        private <T> ModuleTableColumns(String header, Class<T> cls, Function<ModuleRow, T> getter, BiConsumer<ModuleRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> ModuleTableColumns(String header, Class<T> cls, Function<ModuleRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(ModuleRow row) {
            return this.setter != null;
        }

        public void setValueOf(ModuleRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(ModuleRow row) {
            return this.getter.apply(row);
        }
    }
}

