/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import ghidra.app.plugin.core.byteviewer.MemoryByteBlock;
import ghidra.app.plugin.core.debug.gui.memory.WritesTargetProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.services.TraceRecorder;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WritesTargetMemoryByteBlock
extends MemoryByteBlock {
    protected final WritesTargetProgramByteBlockSet blockSet;

    public WritesTargetMemoryByteBlock(WritesTargetProgramByteBlockSet blockSet, Program program, Memory memory, MemoryBlock block) {
        super(program, memory, block);
        this.blockSet = blockSet;
    }

    protected boolean shouldWriteTarget() {
        return this.blockSet.provider.current.isAliveAndPresent();
    }

    protected TraceRecorder getTraceRecorder() {
        return this.blockSet.provider.current.getRecorder();
    }

    public void setByte(BigInteger index, byte value) throws ByteBlockAccessException {
        if (!this.shouldWriteTarget()) {
            super.setByte(index, value);
            return;
        }
        Address addr = this.getAddress(index);
        this.writeTargetByte(addr, value);
    }

    public void setInt(BigInteger index, int value) throws ByteBlockAccessException {
        if (!this.shouldWriteTarget()) {
            super.setInt(index, value);
            return;
        }
        Address addr = this.getAddress(index);
        this.writeTargetInt(addr, value, this.isBigEndian());
    }

    public void setLong(BigInteger index, long value) throws ByteBlockAccessException {
        if (!this.shouldWriteTarget()) {
            super.setLong(index, value);
            return;
        }
        Address addr = this.getAddress(index);
        this.writeTargetLong(addr, value, this.isBigEndian());
    }

    public void writeTarget(Address addr, byte[] data) {
        TraceRecorder recorder = this.getTraceRecorder();
        recorder.writeProcessMemory(addr, data);
    }

    protected ByteBuffer newBuffer(int size, boolean bigEndian) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    public void writeTargetByte(Address addr, byte value) {
        this.writeTarget(addr, new byte[]{value});
    }

    public void writeTargetInt(Address addr, int value, boolean bigEndian) {
        ByteBuffer buf = this.newBuffer(4, bigEndian);
        buf.putInt(value);
        this.writeTarget(addr, buf.array());
    }

    public void writeTargetLong(Address addr, long value, boolean bigEndian) {
        ByteBuffer buf = this.newBuffer(8, bigEndian);
        buf.putLong(value);
        this.writeTarget(addr, buf.array());
    }

    protected boolean editAllowed(Address addr, long length) {
        return true;
    }
}

