/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import com.google.common.collect.Range;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.util.database.UndoableTransaction;

public class RegionRow {
    private final TraceMemoryRegion region;

    public RegionRow(TraceMemoryRegion region) {
        this.region = region;
    }

    public TraceMemoryRegion getRegion() {
        return this.region;
    }

    public void setName(String name) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.region.getTrace(), (String)"Renamed region", (boolean)true);){
            this.region.setName(name);
            tid.commit();
        }
    }

    public String getName() {
        return this.region.getName();
    }

    public Range<Long> getLifespan() {
        return this.region.getLifespan();
    }

    public long getCreatedSnap() {
        return this.region.getCreationSnap();
    }

    public String getDestroyedSnap() {
        long snap = this.region.getDestructionSnap();
        return snap == Long.MAX_VALUE ? "" : Long.toString(snap);
    }

    public AddressRange getRange() {
        return this.region.getRange();
    }

    public Address getMaxAddress() {
        return this.region.getMaxAddress();
    }

    public Address getMinAddress() {
        return this.region.getMinAddress();
    }

    public long getLength() {
        return this.region.getLength();
    }

    public void setRead(boolean read) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.region.getTrace(), (String)"Toggle region read flag", (boolean)true);){
            this.region.setRead(read);
        }
    }

    public boolean isRead() {
        return this.region.isRead();
    }

    public void setWrite(boolean write) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.region.getTrace(), (String)"Toggle region write flag", (boolean)true);){
            this.region.setWrite(write);
        }
    }

    public boolean isWrite() {
        return this.region.isWrite();
    }

    public void setExecute(boolean execute) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.region.getTrace(), (String)"Toggle region execute flag", (boolean)true);){
            this.region.setExecute(execute);
        }
    }

    public boolean isExecute() {
        return this.region.isExecute();
    }

    public void setVolatile(boolean vol) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.region.getTrace(), (String)"Toggle region volatile flag", (boolean)true);){
            this.region.setVolatile(vol);
        }
    }

    public boolean isVolatile() {
        return this.region.isVolatile();
    }
}

