/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsProvider;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.concurrent.CompletableFuture;

public class LogicalBreakpointRow {
    private final DebuggerBreakpointsProvider provider;
    private final LogicalBreakpoint lb;

    public LogicalBreakpointRow(DebuggerBreakpointsProvider provider, LogicalBreakpoint lb) {
        this.provider = provider;
        this.lb = lb;
    }

    public String toString() {
        return "<Row " + this.lb + ">";
    }

    public LogicalBreakpoint getLogicalBreakpoint() {
        return this.lb;
    }

    public LogicalBreakpoint.Enablement getEnablement() {
        return this.provider.isFilterByCurrentTrace() && this.provider.currentTrace != null ? this.lb.computeEnablementForTrace(this.provider.currentTrace) : this.lb.computeEnablement();
    }

    public void setEnablement(LogicalBreakpoint.Enablement en) {
        assert (en.consistent && en.effective);
        this.setEnabled(en.enabled);
    }

    public Boolean isEnabled() {
        LogicalBreakpoint.Enablement en = this.getEnablement();
        if (!en.consistent) {
            return null;
        }
        return en.enabled && en.effective;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            CompletableFuture<Void> future = this.provider.isFilterByCurrentTrace() ? this.lb.enableForTrace(this.provider.currentTrace) : this.lb.enable();
            future.exceptionally(ex -> {
                this.provider.breakpointError("Toggle Breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        } else {
            CompletableFuture<Void> future = this.provider.isFilterByCurrentTrace() ? this.lb.disableForTrace(this.provider.currentTrace) : this.lb.disable();
            future.exceptionally(ex -> {
                this.provider.breakpointError("Toggle Breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }
    }

    public String getImageName() {
        Program program = this.lb.getProgram();
        if (program == null) {
            return "";
        }
        DomainFile df = program.getDomainFile();
        if (df == null) {
            return program.getName();
        }
        return df.getName();
    }

    public Address getAddress() {
        return this.lb.getAddress();
    }

    public long getLength() {
        return this.lb.getLength();
    }

    public DomainObject getDomainObject() {
        return this.lb.getDomainObject();
    }

    public String getKinds() {
        return TraceBreakpointKind.TraceBreakpointKindSet.encode(this.lb.getKinds());
    }

    public int getLocationCount() {
        if (this.provider.isFilterByCurrentTrace()) {
            return this.lb.getTraceBreakpoints(this.provider.currentTrace).size();
        }
        return this.lb.getTraceBreakpoints().size();
    }

    public boolean isMapped() {
        if (this.provider.isFilterByCurrentTrace()) {
            return this.lb.getMappedTraces().contains(this.provider.currentTrace);
        }
        return !this.lb.getMappedTraces().isEmpty();
    }
}

