/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointsProvider;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.UndoableTransaction;
import java.util.stream.Collectors;

public class BreakpointLocationRow {
    private final DebuggerBreakpointsProvider provider;
    private final TraceBreakpoint loc;

    public BreakpointLocationRow(DebuggerBreakpointsProvider provider, TraceBreakpoint loc) {
        this.provider = provider;
        this.loc = loc;
    }

    public String getName() {
        return this.loc.getName();
    }

    public boolean isEnabled() {
        return this.loc.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        TraceRecorder recorder = this.provider.modelService.getRecorder(this.loc.getTrace());
        TargetBreakpointLocation bpt = recorder.getTargetBreakpoint(this.loc);
        if (enabled) {
            bpt.getSpecification().enable().exceptionally(ex -> {
                this.provider.breakpointError("Toggle breakpoint", "Could not enable breakpoint", (Throwable)ex);
                return null;
            });
        } else {
            bpt.getSpecification().disable().exceptionally(ex -> {
                this.provider.breakpointError("Toggle breakpoint", "Could not disable breakpoint", (Throwable)ex);
                return null;
            });
        }
    }

    public void setName(String name) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.loc.getTrace(), (String)"Set breakpoint name", (boolean)true);){
            this.loc.setName(name);
        }
    }

    public Address getAddress() {
        return this.loc.getMinAddress();
    }

    public String getTraceName() {
        return this.loc.getTrace().getName();
    }

    public String getThreads() {
        return this.loc.getThreads().stream().map(TraceThread::getName).collect(Collectors.toSet()).toString();
    }

    public String getComment() {
        return this.loc.getComment();
    }

    public void setComment(String comment) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.loc.getTrace(), (String)"Set breakpoint comment", (boolean)true);){
            this.loc.setComment(comment);
        }
    }

    public TraceBreakpoint getTraceBreakpoint() {
        return this.loc;
    }
}

