/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public class VisibleAutoReadMemorySpec
implements AutoReadMemorySpec {
    public static final String CONFIG_NAME = "READ_VISIBLE";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Read Visible Memory";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.AutoReadMemoryAction.ICON_VISIBLE;
    }

    @Override
    public CompletableFuture<?> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
        TraceMemoryManager mm;
        AddressSetView alreadyKnown;
        if (!coordinates.isAliveAndReadsPresent()) {
            return AsyncUtils.NIL;
        }
        TraceRecorder recorder = coordinates.getRecorder();
        AddressSet visibleAccessible = recorder.getAccessibleProcessMemory().intersect(visible);
        AddressSet toRead = visibleAccessible.subtract(alreadyKnown = (mm = coordinates.getTrace().getMemoryManager()).getAddressesWithState(coordinates.getSnap().longValue(), (AddressSetView)visibleAccessible, s -> s == TraceMemoryState.KNOWN));
        if (toRead.isEmpty()) {
            return AsyncUtils.NIL;
        }
        return recorder.captureProcessMemory((AddressSetView)toRead, TaskMonitor.DUMMY, false);
    }
}

