/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.buffers.BufferMgr;
import db.buffers.DataBuffer;
import db.buffers.LocalBufferFile;
import ghidra.util.datastruct.IntIntHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import java.io.File;
import java.io.IOException;

class DBParms {
    static int MASTER_TABLE_ROOT_BUFFER_ID_PARM = 0;
    static int DATABASE_ID_HIGH_PARM = 1;
    static int DATABASE_ID_LOW_PARM = 2;
    private static final int NODE_TYPE_SIZE = 1;
    private static final int DATA_LENGTH_SIZE = 4;
    private static final int VERSION_SIZE = 1;
    private static final int NODE_TYPE_OFFSET = 0;
    private static final int DATA_LENGTH_OFFSET = 1;
    private static final int VERSION_OFFSET = 5;
    private static final int PARM_BASE_OFFSET = 6;
    private static final byte VERSION = 1;
    private BufferMgr bufferMgr;
    private int size;
    private IntIntHashtable cache = new IntIntHashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBParms(BufferMgr bufferMgr, boolean create) throws IOException {
        this.bufferMgr = bufferMgr;
        if (create) {
            DataBuffer buffer = null;
            try {
                buffer = bufferMgr.createBuffer();
                if (buffer.getId() != 0) {
                    throw new AssertException("DBParms must be first buffer allocation");
                }
                buffer.clear();
                buffer.putByte(0, (byte)9);
                buffer.putInt(1, 1);
                buffer.putByte(5, (byte)1);
            }
            finally {
                if (buffer != null) {
                    bufferMgr.releaseBuffer(buffer);
                }
            }
        }
        this.refresh();
    }

    private static int getOffset(int parm) {
        return 6 + parm * 4;
    }

    static void poke(File file, int parm, int value) throws IOException {
        DataBuffer buffer = LocalBufferFile.peek(file, 0);
        if (buffer.getByte(0) != 9) {
            throw new AssertException("Unexpected DBParms buffer node type");
        }
        if (buffer.getByte(5) != 1) {
            throw new AssertException("Unsupported DBParms format");
        }
        DBParms.storeParm(parm, value, buffer);
        LocalBufferFile.poke(file, 0, buffer);
    }

    private static void storeParm(int parm, int value, DataBuffer buffer) {
        int maxParmCnt = (buffer.length() - 6) / 4;
        if (parm < 0 || parm >= maxParmCnt) {
            throw new ArrayIndexOutOfBoundsException("Invalid parameter index: " + parm);
        }
        int size = (buffer.getInt(1) - 1) / 4;
        if (parm >= size) {
            int dataLen = (parm + 1) * 4;
            buffer.putInt(1, dataLen + 1);
        }
        buffer.putInt(DBParms.getOffset(parm), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(int parm, int value) throws IOException {
        DataBuffer buffer = this.bufferMgr.getBuffer(0);
        try {
            DBParms.storeParm(parm, value, buffer);
            if (parm >= this.size) {
                for (int i = this.size; i < parm; ++i) {
                    this.cache.put(i, 0);
                }
                this.size = parm + 1;
            }
            this.cache.put(parm, value);
        }
        finally {
            this.bufferMgr.releaseBuffer(buffer);
        }
    }

    int get(int parm) throws IOException, ArrayIndexOutOfBoundsException {
        try {
            return this.cache.get(parm);
        }
        catch (NoValueException e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    void refresh() throws IOException {
        DataBuffer buffer = this.bufferMgr.getBuffer(0);
        try {
            if (buffer.getByte(0) != 9) {
                throw new AssertException("Unexpected DBParms buffer node type");
            }
            if (buffer.getByte(5) != 1) {
                throw new AssertException("Unsupported DBParms format");
            }
            this.size = (buffer.getInt(1) - 1) / 4;
            this.cache = new IntIntHashtable();
            for (int i = 0; i < this.size; ++i) {
                this.cache.put(i, buffer.getInt(DBParms.getOffset(i)));
            }
        }
        finally {
            this.bufferMgr.releaseBuffer(buffer);
        }
    }
}

